/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.legacy.mcauthlib.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import pl.asie.foamfix.repack.com.unascribed.ears.legacy.nanojson.JsonObject;
import pl.asie.foamfix.repack.com.unascribed.ears.legacy.nanojson.JsonParser;
import pl.asie.foamfix.repack.com.unascribed.ears.legacy.nanojson.JsonWriter;

public class HTTP {
    private HTTP() {
    }

    public static void makeRequest(Proxy proxy, URI uri, Object input) throws IOException {
        HTTP.makeRequest(proxy, uri, input, null);
    }

    public static <T> T makeRequest(Proxy proxy, URI uri, Object input, Function<Object, T> parser, Map<String, String> extraHeaders) throws IOException {
        Object response;
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy cannot be null.");
        }
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null.");
        }
        try {
            response = input == null ? HTTP.performGetRequest(proxy, uri, extraHeaders) : HTTP.performPostRequest(proxy, uri, extraHeaders, JsonWriter.string(input), "application/json");
        }
        catch (IOException e) {
            throw new IOException("Could not make request to '" + uri + "'.", e);
        }
        if (response != null) {
            HTTP.checkForError(response);
            if (parser != null) {
                return parser.apply(response);
            }
        }
        return null;
    }

    public static <T> T makeRequest(Proxy proxy, URI uri, Object input, Function<Object, T> parser) throws IOException {
        return HTTP.makeRequest(proxy, uri, input, parser, new HashMap<String, String>());
    }

    public static <T> T makeRequestForm(Proxy proxy, URI uri, Map<String, String> input, Function<Object, T> parser) throws IOException {
        Object response;
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy cannot be null.");
        }
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null.");
        }
        String inputString = HTTP.formMapToString(input);
        try {
            response = HTTP.performPostRequest(proxy, uri, new HashMap<String, String>(), inputString, "application/x-www-form-urlencoded");
        }
        catch (IOException e) {
            throw new IOException("Could not make request to '" + uri + "'.", e);
        }
        if (response != null) {
            HTTP.checkForError(response);
            if (parser != null) {
                return parser.apply(response);
            }
        }
        return null;
    }

    public static String formMapToString(Map<String, String> input) {
        StringBuilder inputString = new StringBuilder();
        for (Map.Entry<String, String> inputField : input.entrySet()) {
            if (inputString.length() > 0) {
                inputString.append("&");
            }
            try {
                inputString.append(URLEncoder.encode(inputField.getKey(), "UTF-8"));
                inputString.append("=");
                inputString.append(URLEncoder.encode(inputField.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return inputString.toString();
    }

    private static void checkForError(Object response) throws IOException {
        JsonObject object;
        if (response instanceof JsonObject && (object = (JsonObject)response).has("error")) {
            String error = object.getString("error");
            String cause = object.has("cause") ? object.getString("cause") : "";
            String errorMessage = object.has("errorMessage") ? object.getString("errorMessage") : "";
            String string = errorMessage = object.has("error_description") ? object.getString("error_description") : errorMessage;
            if (!error.equals("")) {
                if (error.equals("ForbiddenOperationException")) {
                    if (cause != null && cause.equals("UserMigratedException")) {
                        throw new IOException("User migrated: " + errorMessage);
                    }
                    throw new IOException("Invalid credentials: " + errorMessage);
                }
                if (error.equals("authorization_pending")) {
                    throw new IOException("Authorization pending: " + errorMessage);
                }
                throw new IOException(errorMessage);
            }
        }
    }

    private static Object performGetRequest(Proxy proxy, URI uri, Map<String, String> extraHeaders) throws IOException {
        HttpURLConnection connection = HTTP.createUrlConnection(proxy, uri);
        for (Map.Entry<String, String> header : extraHeaders.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        connection.setDoInput(true);
        return HTTP.processResponse(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object performPostRequest(Proxy proxy, URI uri, Map<String, String> extraHeaders, String post, String type) throws IOException {
        byte[] bytes = post.getBytes("UTF-8");
        HttpURLConnection connection = HTTP.createUrlConnection(proxy, uri);
        connection.setRequestProperty("Content-Type", type + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
        for (Map.Entry<String, String> header : extraHeaders.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        try (OutputStream out = connection.getOutputStream();){
            out.write(bytes);
        }
        return HTTP.processResponse(connection);
    }

    public static HttpURLConnection createUrlConnection(Proxy proxy, URI uri) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection(proxy);
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        return connection;
    }

    private static Object processResponse(HttpURLConnection connection) throws IOException {
        try (InputStream in = connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream();){
            Object object = in != null ? JsonParser.any().from(new InputStreamReader(in)) : null;
            return object;
        }
    }

    public static interface Function<T, R> {
        public R apply(T var1);
    }
}

