/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.legacy.nanojson;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import pl.asie.foamfix.repack.com.unascribed.ears.legacy.nanojson.JsonArray;
import pl.asie.foamfix.repack.com.unascribed.ears.legacy.nanojson.JsonLazyNumber;
import pl.asie.foamfix.repack.com.unascribed.ears.legacy.nanojson.JsonObject;
import pl.asie.foamfix.repack.com.unascribed.ears.legacy.nanojson.JsonParserException;
import pl.asie.foamfix.repack.com.unascribed.ears.legacy.nanojson.JsonTokener;

public final class JsonParser {
    private Object value;
    private int token;
    private JsonTokener tokener;
    private boolean lazyNumbers;

    JsonParser(JsonTokener tokener, boolean lazyNumbers) throws JsonParserException {
        this.tokener = tokener;
        this.lazyNumbers = lazyNumbers;
    }

    public static JsonParserContext<JsonObject> object() {
        return new JsonParserContext<JsonObject>(JsonObject.class);
    }

    public static JsonParserContext<JsonArray> array() {
        return new JsonParserContext<JsonArray>(JsonArray.class);
    }

    public static JsonParserContext<Object> any() {
        return new JsonParserContext<Object>(Object.class);
    }

    <T> T parse(Class<T> clazz) throws JsonParserException {
        this.advanceToken();
        Object parsed = this.currentValue();
        if (this.advanceToken() != 0) {
            throw this.tokener.createParseException(null, "Expected end of input, got " + this.token, true);
        }
        if (!(clazz == Object.class || parsed != null && clazz.isAssignableFrom(parsed.getClass()))) {
            throw this.tokener.createParseException(null, "JSON did not contain the correct type, expected " + clazz.getSimpleName() + ".", true);
        }
        return clazz.cast(parsed);
    }

    private Object currentValue() throws JsonParserException {
        if (this.token >= 5) {
            return this.value;
        }
        throw this.tokener.createParseException(null, "Expected JSON value, got " + this.token, true);
    }

    /*
     * Unable to fully structure code
     */
    private int advanceToken() throws JsonParserException {
        this.token = this.tokener.advanceToToken();
        switch (this.token) {
            case 11: {
                list = new JsonArray();
                if (this.advanceToken() == 4) ** GOTO lbl14
                do {
                    list.add(this.currentValue());
                    if (this.advanceToken() == 4) ** GOTO lbl14
                    if (this.token == 1) continue;
                    throw this.tokener.createParseException(null, "Expected a comma or end of the array instead of " + this.token, true);
                } while (this.advanceToken() != 4);
                throw this.tokener.createParseException(null, "Trailing comma found in array", true);
lbl14:
                // 2 sources

                this.value = list;
                this.token = 11;
                return 11;
            }
            case 10: {
                map = new JsonObject();
                if (this.advanceToken() == 3) ** GOTO lbl35
                do {
                    if (this.token != 8) {
                        throw this.tokener.createParseException(null, "Expected STRING, got " + this.token, true);
                    }
                    key = (String)this.value;
                    if (this.advanceToken() != 2) {
                        throw this.tokener.createParseException(null, "Expected COLON, got " + this.token, true);
                    }
                    this.advanceToken();
                    map.put(key, this.currentValue());
                    if (this.advanceToken() == 3) ** GOTO lbl35
                    if (this.token == 1) continue;
                    throw this.tokener.createParseException(null, "Expected a comma or end of the object instead of " + this.token, true);
                } while (this.advanceToken() != 3);
                throw this.tokener.createParseException(null, "Trailing object found in array", true);
lbl35:
                // 2 sources

                this.value = map;
                this.token = 10;
                return 10;
            }
            case 6: {
                this.value = Boolean.TRUE;
                break;
            }
            case 7: {
                this.value = Boolean.FALSE;
                break;
            }
            case 5: {
                this.value = null;
                break;
            }
            case 8: {
                this.value = this.tokener.reusableBuffer.toString();
                break;
            }
            case 9: {
                if (this.lazyNumbers) {
                    this.value = new JsonLazyNumber(this.tokener.reusableBuffer.toString(), this.tokener.isDouble);
                    break;
                }
                this.value = this.parseNumber();
                break;
            }
        }
        return this.token;
    }

    private Number parseNumber() throws JsonParserException {
        String number = this.tokener.reusableBuffer.toString();
        try {
            int length;
            if (this.tokener.isDouble) {
                return Double.parseDouble(number);
            }
            if (number.length() == 1) {
                return number.charAt(0) - 48;
            }
            if (number.length() == 2 && number.charAt(0) == '-') {
                return 48 - number.charAt(1);
            }
            boolean firstMinus = number.charAt(0) == '-';
            int n = length = firstMinus ? number.length() - 1 : number.length();
            if (length < 10 || length == 10 && number.charAt(firstMinus ? 1 : 0) < '2') {
                return Integer.parseInt(number);
            }
            if (length < 19 || length == 19 && number.charAt(firstMinus ? 1 : 0) < '9') {
                return Long.parseLong(number);
            }
            return new BigInteger(number);
        }
        catch (NumberFormatException e) {
            throw this.tokener.createParseException(e, "Malformed number: " + number, true);
        }
    }

    public static final class JsonParserContext<T> {
        private final Class<T> clazz;
        private boolean lazyNumbers;

        JsonParserContext(Class<T> clazz) {
            this.clazz = clazz;
        }

        public JsonParserContext<T> withLazyNumbers() {
            this.lazyNumbers = true;
            return this;
        }

        public T from(String s) throws JsonParserException {
            return new JsonParser(new JsonTokener(new StringReader(s)), this.lazyNumbers).parse(this.clazz);
        }

        public T from(Reader r) throws JsonParserException {
            return new JsonParser(new JsonTokener(r), this.lazyNumbers).parse(this.clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T from(URL url) throws JsonParserException {
            try (InputStream stm = url.openStream();){
                T t = this.from(stm);
                return t;
            }
            catch (IOException e) {
                throw new JsonParserException(e, "IOException opening URL", 1, 1, 0);
            }
        }

        public T from(InputStream stm) throws JsonParserException {
            return new JsonParser(new JsonTokener(stm), this.lazyNumbers).parse(this.clazz);
        }
    }
}

