/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.client.gui;

import com.github.lunatrius.ingameinfo.client.gui.GuiTags;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.Tessellator;

public class GuiTagList
extends GuiListExtended {
    public static final int OFFSET_X = 150;
    public static final int SCROLLBAR_WIDTH = 6;
    private final Minecraft minecraft;
    private final Map<CategoryEntry, Set<TagEntry>> map;
    private GuiListExtended.IGuiListEntry[] entries;

    public GuiTagList(GuiTags guiTags, Minecraft minecraft) {
        super(minecraft, guiTags.field_146294_l, guiTags.field_146295_m, 18, guiTags.field_146295_m - 30, 24);
        this.minecraft = minecraft;
        this.map = new TreeMap<CategoryEntry, Set<TagEntry>>();
        HashMap<String, CategoryEntry> stringCategoryEntryMap = new HashMap<String, CategoryEntry>();
        for (Tag tag : TagRegistry.INSTANCE.getRegisteredTags()) {
            Set<TagEntry> tagEntries;
            String category = tag.getLocalizedCategory();
            String name = tag.getFormattedName();
            String description = tag.getLocalizedDescription();
            CategoryEntry categoryEntry = (CategoryEntry)stringCategoryEntryMap.get(category);
            if (categoryEntry == null) {
                categoryEntry = new CategoryEntry(this.minecraft.field_71466_p, category);
                stringCategoryEntryMap.put(category, categoryEntry);
                this.map.put(categoryEntry, new TreeSet());
            }
            if ((tagEntries = this.map.get(categoryEntry)) == null) continue;
            tagEntries.add(new TagEntry(this.minecraft.field_71466_p, name, description));
        }
        this.filter("");
    }

    public void filter(String pattern) {
        ArrayList<ListEntry> list = new ArrayList<ListEntry>();
        for (Map.Entry<CategoryEntry, Set<TagEntry>> entry : this.map.entrySet()) {
            list.add(entry.getKey());
            boolean added = false;
            for (TagEntry tag : entry.getValue()) {
                if (!tag.getName().toLowerCase().contains(pattern) && !tag.getDesc().toLowerCase().contains(pattern)) continue;
                added = true;
                list.add(tag);
            }
            if (added) continue;
            list.remove(list.size() - 1);
        }
        this.entries = list.toArray(new GuiListExtended.IGuiListEntry[list.size()]);
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.entries[index];
    }

    protected int func_148127_b() {
        return this.entries.length;
    }

    public int func_148139_c() {
        return Math.min(Math.max(this.field_148155_a, 400), 440);
    }

    protected int func_148137_d() {
        return this.field_148155_a / 2 + this.func_148139_c() / 2 - 6;
    }

    public class TagEntry
    extends ListEntry {
        private final FontRenderer fontRenderer;
        private final String name;
        private final String desc;
        private final String[] descArray;

        public TagEntry(FontRenderer fontRenderer, String name, String desc) {
            this.fontRenderer = fontRenderer;
            this.name = name;
            this.desc = desc;
            this.descArray = this.getDescArray(desc);
        }

        private String[] getDescArray(String desc) {
            ArrayList<String> list = new ArrayList<String>();
            int width = GuiTagList.this.func_148139_c() - 150 - 6;
            if (this.fontRenderer.func_78256_a(desc) < width) {
                list.add(desc);
            } else {
                String trimmed;
                int index;
                while (this.fontRenderer.func_78256_a(desc) > width && (index = (trimmed = this.fontRenderer.func_78269_a(desc, width)).lastIndexOf(" ")) >= 1) {
                    desc = desc.substring(index + 1);
                    list.add(trimmed.substring(0, index));
                }
                list.add(desc);
            }
            return list.toArray(new String[list.size()]);
        }

        public void func_148279_a(int index, int x, int y, int width, int height, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            this.fontRenderer.func_78276_b(this.name, x, y + height / 2 - this.fontRenderer.field_78288_b / 2, 0xFFFFFF);
            int lineHeight = this.fontRenderer.field_78288_b + 1;
            for (int i = 0; i < this.descArray.length; ++i) {
                this.fontRenderer.func_78276_b(this.descArray[i], x + 150, y + (height - lineHeight * this.descArray.length) / 2 + lineHeight * i, 0xFFFFFF);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public class CategoryEntry
    extends ListEntry {
        private final FontRenderer fontRenderer;
        private final String name;

        public CategoryEntry(FontRenderer fontRenderer, String name) {
            this.fontRenderer = fontRenderer;
            this.name = name;
        }

        public void func_148279_a(int index, int x, int y, int width, int height, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            this.fontRenderer.func_78276_b(this.name, x + (width - this.fontRenderer.func_78256_a(this.name)) / 2, y + (height - this.fontRenderer.field_78288_b + 1) / 2, 0xFFFFFF);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public abstract class ListEntry
    implements GuiListExtended.IGuiListEntry,
    Comparable<ListEntry> {
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            return false;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }

        public abstract String getName();

        @Override
        public int compareTo(ListEntry listEntry) {
            return this.getName().compareTo(listEntry.getName());
        }
    }
}

