/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.parallelmipmap;

import com.gamerforea.parallelmipmap.CoreMod;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.renderer.texture.TextureMap")) {
            return ASMTransformer.patchTextureMap(bytes);
        }
        return bytes;
    }

    private static byte[] patchTextureMap(byte[] basicClass) {
        ClassNode cNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)cNode, 0);
        String loadTextureAtlas = CoreMod.isObfuscated ? "func_110571_b" : "loadTextureAtlas";
        block11: for (int i = 0; i < cNode.methods.size(); ++i) {
            MethodNode mNode = (MethodNode)cNode.methods.get(i);
            if (!mNode.name.equals(loadTextureAtlas) || !mNode.desc.equals("(Lnet/minecraft/client/resources/IResourceManager;)V")) continue;
            byte[] customBytes = null;
            try {
                InputStream is = ASMTransformer.class.getClassLoader().getResourceAsStream("net/minecraft/client/renderer/texture/TextureMap.class");
                Object object = null;
                try {
                    customBytes = ByteStreams.toByteArray((InputStream)is);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("[ParallelMipMap] Failed loading custom TextureMap.class");
                e.printStackTrace();
                return basicClass;
            }
            ClassNode customNode = new ClassNode();
            new ClassReader(customBytes).accept((ClassVisitor)customNode, 0);
            for (MethodNode customMNode : customNode.methods) {
                if (!customMNode.name.equals(loadTextureAtlas) || !customMNode.desc.equals("(Lnet/minecraft/client/resources/IResourceManager;)V")) continue;
                cNode.methods.set(i, customMNode);
                break block11;
            }
            break;
        }
        ClassWriter cWriter = new ClassWriter(2);
        cNode.accept((ClassVisitor)cWriter);
        return cWriter.toByteArray();
    }
}

