/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.parallelmipmap;

import cpw.mods.fml.common.ProgressManager;
import java.util.Iterator;
import java.util.concurrent.Callable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;

public class ParallelUtils {
    public static void generateMipMaps_MultiThread(final Iterator<TextureAtlasSprite> iterator, final ProgressManager.ProgressBar bar, final int mipmapLevels) {
        Thread[] workers = new Thread[Runtime.getRuntime().availableProcessors()];
        for (int workerId = 0; workerId < workers.length; ++workerId) {
            Thread worker = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        TextureAtlasSprite sprite = null;
                        Iterator iterator2 = iterator;
                        synchronized (iterator2) {
                            if (!iterator.hasNext()) {
                                return;
                            }
                            sprite = (TextureAtlasSprite)iterator.next();
                        }
                        final TextureAtlasSprite finalSprite = sprite;
                        try {
                            finalSprite.func_147963_d(mipmapLevels);
                            ProgressManager.ProgressBar progressBar = bar;
                            synchronized (progressBar) {
                                bar.step(finalSprite.func_94215_i());
                            }
                        }
                        catch (Throwable throwable) {
                            CrashReport report = CrashReport.func_85055_a((Throwable)throwable, (String)"Applying mipmap");
                            CrashReportCategory category = report.func_85058_a("Sprite being mipmapped");
                            category.func_71500_a("Sprite name", (Callable)new Callable<String>(){

                                @Override
                                public String call() {
                                    return finalSprite.func_94215_i();
                                }
                            });
                            category.func_71500_a("Sprite size", (Callable)new Callable<String>(){

                                @Override
                                public String call() {
                                    return finalSprite.func_94211_a() + " x " + finalSprite.func_94216_b();
                                }
                            });
                            category.func_71500_a("Sprite frames", (Callable)new Callable<String>(){

                                @Override
                                public String call() {
                                    return finalSprite.func_110970_k() + " frames";
                                }
                            });
                            category.func_71507_a("Mipmap levels", (Object)mipmapLevels);
                            throw new ReportedException(report);
                        }
                    }
                }
            };
            worker.setDaemon(true);
            worker.setName("MipMap worker #" + workerId);
            worker.start();
            workers[workerId] = worker;
        }
        for (Thread worker : workers) {
            try {
                worker.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

