/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class WaypointsGuiRenderer {
    private IXaeroMinimap modMain;
    private Minecraft mc;

    public WaypointsGuiRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
    }

    public void render(XaeroMinimapSession minimapSession, MinimapRendererHelper rendererHelper, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double zoom, boolean circle, float minimapScale, boolean safeMode) {
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3008);
        if (this.modMain.getSettings().compassOverWaypoints) {
            this.drawWaypoints(waypointsManager, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale);
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false);
            }
        } else {
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false);
            }
            this.drawWaypoints(waypointsManager, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale);
        }
    }

    private void drawWaypoints(WaypointsManager waypointsManager, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double dimDiv, double zoom, boolean circle, float minimapScale) {
        if (this.modMain.getSettings().getShowWaypoints() && waypointsManager.getWaypoints() != null) {
            if (this.modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    this.renderWaypointsList(setEntry.getValue().getList(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle, minimapScale);
                }
            } else {
                this.renderWaypointsList(waypointsManager.getWaypoints().getList(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle, minimapScale);
            }
        }
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = WaypointsManager.customWaypoints;
        if (this.modMain.getSettings().getShowWaypoints() && !customWaypoints.isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                this.renderWaypointsList(modCustomWaypoints.values(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle, minimapScale);
            }
        }
    }

    private void renderWaypointsList(Collection<Waypoint> list, double playerX, double playerZ, int specW, int specH, double ps, double pc, double dimDiv, double zoom, boolean circle, float minimapScale) {
        for (Waypoint w : list) {
            if (w == null || w.isDisabled() || w.getType() == 1 && !this.modMain.getSettings().getDeathpoints()) continue;
            double offx = (double)w.getX(dimDiv) + 0.5 - playerX;
            double offz = (double)w.getZ(dimDiv) + 0.5 - playerZ;
            double distance = Math.sqrt(offx * offx + offz * offz);
            double waypointsDistance = this.modMain.getSettings().getMaxWaypointsDistance();
            if (w.getType() == 0 && !w.isGlobal() && waypointsDistance != 0.0 && distance > waypointsDistance) continue;
            this.translatePosition(specW, specH, ps, pc, offx, offz, zoom, circle);
            GL11.glScalef((float)minimapScale, (float)minimapScale, (float)1.0f);
            this.drawIconOnGUI(w, this.modMain.getSettings(), 0, 0);
            GL11.glPopMatrix();
        }
    }

    public void drawCompass(MinimapRendererHelper rendererHelper, int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background) {
        if (this.modMain.getSettings().compassLocation == 0) {
            return;
        }
        String[] nesw = new String[]{I18n.func_135052_a((String)"gui.xaero_compass_north", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_east", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_south", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_compass_west", (Object[])new Object[0])};
        int color = ModSettings.COLORS[this.modMain.getSettings().compassColor];
        for (int i = 0; i < 4; ++i) {
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            this.translatePosition(specW, specH, ps, pc, offx, offy, zoom, circle);
            GL11.glScalef((float)minimapScale, (float)minimapScale, (float)1.0f);
            GL11.glDisable((int)2929);
            int halfW = this.mc.field_71466_p.func_78256_a(nesw[i]) / 2 - 1;
            if (background) {
                GL11.glDisable((int)3553);
                GL11.glEnable((int)3042);
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                rendererHelper.drawMyColoredRect(-4 - addedFrame, -4 - addedFrame, 5 + addedFrame, 5 + addedFrame, 0x90000000 | color & 0xFFFFFF);
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                GL11.glEnable((int)3553);
            }
            Minecraft.func_71410_x().field_71466_p.func_78276_b(nesw[i], -halfW + 1, -2, color);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(nesw[i], -halfW, -3, -1);
            GL11.glPopMatrix();
        }
    }

    public void translatePosition(int specW, int specH, double ps, double pc, double offx, double offy, double zoom, boolean circle) {
        double X;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(Math.round(borderedX) - 1L), (double)(Math.round(borderedY) - 1L), (double)0.0);
    }

    public void drawIconOnGUI(Waypoint w, ModSettings settings, int drawX, int drawY) {
        int c = ModSettings.COLORS[w.getColor()];
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
        c = a << 24 | r << 16 | g << 8 | b;
        int j = w.getType() == 1 ? 4 : Minecraft.func_71410_x().field_71466_p.func_78256_a(w.getSymbol()) / 2;
        int addedFrame = j > 4 ? j - 4 : 0;
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4 - addedFrame;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5 + addedFrame;
        Gui.func_73734_a((int)rectX1, (int)rectY1, (int)rectX2, (int)rectY2, (int)c);
        if (w.getType() == 0) {
            GL11.glDisable((int)2929);
            Minecraft.func_71410_x().field_71466_p.func_78261_a(w.getSymbol(), drawX + 1 - j, drawY - 3, -1);
        } else if (w.getType() == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            GL11.glColor4f((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1 + 1, rectY1 + 1, 0, 78, 9, 9);
            GL11.glColor4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1, rectY1, 0, 78, 9, 9);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, ScaledResolution res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                GL11.glDisable((int)2929);
                Minecraft.func_71410_x().field_71456_v.func_73732_a(Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), res.func_78326_a() / 2, res.func_78328_b() / 2 + 50, c);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }
}

