/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.IScreenBase;

public class Misc {
    public static void minecraftOrtho(ScaledResolution scaledresolution) {
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFrom) throws IOException {
        Path fromBackupPath;
        Path backupPath;
        block8: {
            backupPath = null;
            fromBackupPath = null;
            if (backupFrom) {
                while (true) {
                    try {
                        fromBackupPath = Misc.quickFileBackupMove(from);
                        break block8;
                    }
                    catch (IOException ioe2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            fromBackupPath = from;
        }
        if (Files.exists(to, new LinkOption[0])) {
            backupPath = Misc.quickFileBackupMove(to);
        }
        Files.move(fromBackupPath, to, new CopyOption[0]);
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static boolean inputMatchesKeyBinding(boolean mouse, int code, KeyBinding kb) {
        if (code == 0) {
            return false;
        }
        if (mouse) {
            code -= 100;
        }
        return kb.func_151463_i() == code;
    }

    public static boolean screenShouldSkipWorldRender(IXaeroMinimap modMain, GuiScreen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && modMain.getSupportMods().worldmap() && modMain.getSupportMods().worldmapSupport.screenShouldSkipWorldRender(screen);
    }

    public static long getChunkPosAsLong(Chunk chunk) {
        return (long)chunk.field_76635_g & 0xFFFFFFFFL | ((long)chunk.field_76647_h & 0xFFFFFFFFL) << 32;
    }

    public static Field getFieldReflection(Class<?> c, String obfuscatedName, String name) {
        Field field = null;
        try {
            field = c.getDeclaredField(obfuscatedName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = c.getDeclaredField(name);
            }
            catch (NoSuchFieldException e1) {
                throw new RuntimeException(e1);
            }
        }
        return field;
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static void download(BufferedOutputStream output, InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        input.close();
        output.close();
    }

    public static Vec3 getLookVec() {
        float pitchCos = ActiveRenderInfo.field_74589_e;
        float pitchSin = ActiveRenderInfo.field_74596_h / ActiveRenderInfo.field_74588_d;
        return Vec3.func_72443_a((double)(-ActiveRenderInfo.field_74586_f * pitchCos), (double)(-pitchSin), (double)(ActiveRenderInfo.field_74588_d * pitchCos));
    }

    public static double getYawRadians() {
        float yawSin = ActiveRenderInfo.field_74586_f;
        float yawCos = ActiveRenderInfo.field_74588_d;
        double aSin = Math.asin(yawSin);
        if (yawCos > 0.0f) {
            return aSin;
        }
        if (aSin > 0.0) {
            return Math.PI - aSin;
        }
        return -Math.PI - aSin;
    }

    public static double getPitchRadians() {
        float pitchSin = ActiveRenderInfo.field_74596_h / ActiveRenderInfo.field_74588_d;
        return Math.asin(pitchSin);
    }

    public static double getEntityY(Entity e) {
        return e.field_70121_D == null ? e.field_70163_u - 1.0 : e.field_70121_D.field_72338_b;
    }
}

