/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.config;

import com.falsepattern.lib.config.Config;

@Config(modid="archaicfix")
public class ArchaicConfig {
    @Config.Comment(value={"Enables the 1.8-style occlusion culling originally developed by CoFHTweaks. Not compatible with OptiFine or FastCraft."})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean enableOcclusionTweaks;
    @Config.Comment(value={"EXPERIMENTAL: Enables multi-threaded chunk updating. At the moment it only works if enableOcclusionTweaks is turned on."})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean enableThreadedChunkUpdates;
    @Config.Comment(value={"The number of threads to use for chunk building. The default is 1, which shouldn't be any laggier than vanilla but will reduce stutter. If you have a lot of cores increasing this may be beneficial."})
    @Config.DefaultInt(value=1)
    @Config.RangeInt(min=1)
    @Config.RequiresMcRestart
    public static int numChunkUpdateThreads;
    @Config.Comment(value={"Changes the enableThreadedChunkUpdates option to never wait for chunk updates. Improves framerate when blocks are placed or destroyed, at the cost of introducing visual delay. This is analogous to 1.18's 'Chunk Builder' option, false meaning 'Fully Blocking', and true meaning 'Threaded'."})
    @Config.DefaultBoolean(value=false)
    public static boolean disableBlockingChunkUpdates;
    @Config.DefaultBoolean(value=true)
    public static boolean hideDownloadingTerrainScreen;
    @Config.Comment(value={"Prevents buttons from showing a yellow text color when hovered, as was done in 1.14+."})
    @Config.DefaultBoolean(value=false)
    public static boolean enableNewButtonAppearance;
    @Config.Comment(value={"Use a faster and asynchronous implementation of creative search."})
    @Config.DefaultBoolean(value=true)
    public static boolean asyncCreativeSearch;
    @Config.Comment(value={"Cap the integrated server render distance at a minimum of 8 chunks, and adjust despawn ranges so mobs will always despawn properly on low render distances."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixMobSpawnsAtLowRenderDist;
    @Config.Comment(value={"Replace the regional difficulty calculation with a TMCW-style one that increases with playtime, not time per chunk."})
    @Config.DefaultBoolean(value=false)
    public static boolean betterRegionalDifficulty;
    @Config.Comment(value={"Allow 65000 block updates to be performed per tick, rather than 1000."})
    @Config.DefaultBoolean(value=true)
    public static boolean increaseBlockUpdateLimit;
    @Config.Comment(value={"EXPERIMENTAL: Cache matching crafting recipes to avoid needing to scan the whole list each time."})
    @Config.DefaultBoolean(value=false)
    public static boolean cacheRecipes;
    @Config.Comment(value={"Disable spawn chunks"})
    @Config.DefaultBoolean(value=false)
    public static boolean disableSpawnChunks;
    @Config.Comment(value={"Reduce lag caused by item entities"})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean itemLagReduction;
    @Config.Comment(value={"Increase the amount of armor mobs wear on average. From TMCW."})
    @Config.DefaultBoolean(value=false)
    public static boolean increaseMobArmor;
    @Config.Comment(value={"Increase the maximum render distance if OptiFine and FastCraft are not installed."})
    @Config.DefaultBoolean(value=false)
    public static boolean raiseMaxRenderDistance;
    @Config.Comment(value={"What the maximum render distance should be if raiseMaxRenderDistance is enabled."})
    @Config.DefaultInt(value=32)
    @Config.RangeInt(min=16, max=128)
    public static int newMaxRenderDistance;
    @Config.Comment(value={"EXPERIMENTAL: Replace the Thaumcraft hashing implementation. This really hasn't been tested and probably breaks everything."})
    @Config.DefaultBoolean(value=false)
    public static boolean betterThaumcraftHashing;
    @Config.Comment(value={"Log when cascading worldgen occurs."})
    @Config.DefaultBoolean(value=true)
    public static boolean logCascadingWorldgen;
    @Config.Comment(value={"Print a stacktrace when cascading worldgen occurs. Use only for development as this will add more lag in game."})
    @Config.DefaultBoolean(value=false)
    public static boolean logCascadingWorldgenStacktrace;
    @Config.Comment(value={"Fix instances of cascading worldgen in Mekanism."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixMekanismCascadingWorldgen;
    @Config.Comment(value={"Fix instances of cascading worldgen in vanilla Minecraft. Turn this option off if you require 100% seed parity."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixVanillaCascadingWorldgen;
    @Config.Comment(value={"Force all mixins to be loaded and the cache to be cleared. This saves RAM, but may reveal bugs in mods' mixin configs. Based on MemoryLeakFix."})
    @Config.DefaultBoolean(value=false)
    public static boolean clearMixinCache;
    @Config.Comment(value={"Clean up LaunchClassLoader cache."})
    @Config.DefaultBoolean(value=true)
    public static boolean clearLaunchLoaderCache;
    @Config.Comment(value={"Only show GT6 tooltip data when Shift is pressed."})
    @Config.DefaultBoolean(value=true)
    public static boolean hideGT6TooltipDataBehindKey;
    @Config.Comment(value={"Fix the 'TickNextTick list out of synch' error."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixTickListSynchronization;
    @Config.Comment(value={"Make sure entities don't spawn inside blocks that would make them suffocate. Off by default because it might reduce the number of passive entities that spawn during worldgen."})
    @Config.DefaultBoolean(value=false)
    public static boolean preventEntitySuffocationWorldgen;
    @Config.Comment(value={"Show block registry name and meta value in F3, similar to 1.8+."})
    @Config.DefaultBoolean(value=false)
    public static boolean showBlockDebugInfo;
    @Config.Comment(value={"Prevent entities outside a certain distance from being ticked. This does not affect tile entities, and is essentially another view distance slider."})
    @Config.DefaultBoolean(value=false)
    public static boolean optimizeEntityTicking;
    @Config.Comment(value={"Squared distance outside which most entities aren't ticked, default is 64 blocks."})
    @Config.DefaultInt(value=4096)
    public static int optimizeEntityTickingDistance;
    @Config.Comment(value={"Distance in chunks at which blocks are ticked, the default value of 0 means to use the render distance."})
    @Config.DefaultInt(value=0)
    public static int optimizeBlockTickingDistance;
    @Config.Comment(value={"List of entities to ignore for entity ticking optimization."})
    @Config.DefaultStringList(value={"Wither", "EnderDragon"})
    public static String[] optimizeEntityTickingIgnoreList;
    @Config.Comment(value={"Disable OptiFine's version checker."})
    @Config.DefaultBoolean(value=true)
    public static boolean disableOFVersionCheck;
    @Config.Comment(value={"Fix TileEntity unloading being laggy."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixTEUnloadLag;
    @Config.Comment(value={"Attempt to fix hanging in SP when logging in."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixLoginRaceCondition;
    @Config.Comment(value={"Fix MC-1406."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixPlacementFlicker;
    @Config.Comment(value={"Optimize vanilla's ID-to-object map."})
    @Config.DefaultBoolean(value=true)
    public static boolean optimizeObjectIntIdentityMap;
    @Config.Comment(value={"Fix the client leaking memory by holding on to skins and player instances that aren't needed."})
    @Config.DefaultBoolean(value=true)
    public static boolean fixSkinMemoryLeak;
    @Config.Comment(value={"Show memory usage during game load."})
    @Config.DefaultBoolean(value=true)
    public static boolean showSplashMemoryBar;
    @Config.Comment(value={"Tweak F3 screen to be closer to modern versions."})
    @Config.DefaultBoolean(value=true)
    public static boolean modernizeF3Screen;
    @Config.Comment(value={"Replace tall grass texture with modern version."})
    @Config.DefaultBoolean(value=false)
    public static boolean modernizeTextures;
    @Config.Comment(value={"Remove JourneyMap debug feature."})
    @Config.DefaultBoolean(value=false)
    public static boolean removeJourneymapDebug;
    @Config.Comment(value={"When true, the Phosphor backport is enabled. Disabling is not recommended as it will generally add lag."})
    @Config.DefaultBoolean(value=true)
    public static boolean enablePhosphor;
    @Config.Comment(value={"When true, dropped items will always render as though fancy graphics are enabled."})
    @Config.DefaultBoolean(value=false)
    public static boolean forceFancyItems;
    @Config.Comment(value={"Disable Food Plus' update message."})
    @Config.DefaultBoolean(value=true)
    public static boolean disableFoodPlusUpdates;
}

