/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.client.occlusion;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.embeddedt.archaicfix.occlusion.ChunkThread;
import org.embeddedt.archaicfix.occlusion.ICulledChunk;
import org.embeddedt.archaicfix.occlusion.OcclusionHelpers;
import org.embeddedt.archaicfix.occlusion.VisGraph;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class})
public abstract class MixinChunk
implements ICulledChunk {
    @Shadow
    public World field_76637_e;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    private VisGraph[] visibility;
    private static ChunkThread worker = new ChunkThread();

    @Shadow
    public abstract Block func_150810_a(int var1, int var2, int var3);

    @Override
    public Chunk buildCulledSides() {
        if (!this.field_76637_e.func_72863_F().func_73149_a(this.field_76635_g, this.field_76647_h)) {
            return null;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int y = 0; y < 256; ++y) {
                    this.checkPosSolid(i, y, j, null);
                }
            }
        }
        OcclusionHelpers.updateArea(this.field_76635_g * 16 - 1, 0, this.field_76647_h * 16 - 1, this.field_76635_g * 16 + 16, 255, this.field_76647_h * 16 + 16);
        return (Chunk)this;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;II)V"}, at={@At(value="RETURN")})
    private void onInit(World p_i1995_1_, int p_i1995_2_, int p_i1995_3_, CallbackInfo ci) {
        this.visibility = new VisGraph[16];
        for (int i = 0; i < 16; ++i) {
            this.visibility[i] = new VisGraph();
        }
    }

    @Override
    public VisGraph[] getVisibility() {
        return this.visibility;
    }

    boolean checkPosSolid(int x, int y, int z, Block block) {
        if (y > 255 || y < 0) {
            return false;
        }
        if (block == null) {
            block = this.func_150810_a(x, y, z);
        }
        VisGraph chunk = this.visibility[y >> 4];
        chunk.setOpaque(x, y &= 0xF, z, block.func_149662_c());
        return chunk.isDirty();
    }

    @Inject(method={"func_150807_a"}, at={@At(value="RETURN")})
    private void onSetBlock(int x, int y, int z, Block block, int meta, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue() && this.field_76637_e.field_72995_K && this.checkPosSolid(x & 0xF, y, z & 0xF, block)) {
            MixinChunk.worker.modified.add((Chunk)this);
        }
    }

    @Inject(method={"fillChunk"}, at={@At(value="RETURN")})
    private void onFillChunk(byte[] p_76607_1_, int p_76607_2_, int p_76607_3_, boolean p_76607_4_, CallbackInfo ci) {
        MixinChunk.worker.loaded.add((Chunk)this);
    }

    static {
        worker.start();
    }
}

