/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.client.occlusion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderList;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.util.RenderDistanceSorter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import org.embeddedt.archaicfix.helpers.WorldRendererDistanceHelper;
import org.embeddedt.archaicfix.occlusion.BasicDistanceSorter;
import org.embeddedt.archaicfix.occlusion.CameraInfo;
import org.embeddedt.archaicfix.occlusion.DefaultRendererUpdateOrderProvider;
import org.embeddedt.archaicfix.occlusion.ICulledChunk;
import org.embeddedt.archaicfix.occlusion.IRenderGlobal;
import org.embeddedt.archaicfix.occlusion.IRenderGlobalListener;
import org.embeddedt.archaicfix.occlusion.IRendererUpdateOrderProvider;
import org.embeddedt.archaicfix.occlusion.IWorldRenderer;
import org.embeddedt.archaicfix.occlusion.OcclusionHelpers;
import org.embeddedt.archaicfix.occlusion.PreviousActiveRenderInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderGlobal.class}, priority=-2)
public abstract class MixinRenderGlobal
implements IRenderGlobal {
    @Shadow
    private int field_72743_C;
    @Shadow
    private int field_72779_z;
    @Shadow
    private int field_72742_B;
    @Shadow
    private int field_72780_y;
    @Shadow
    private int field_72737_D;
    @Shadow
    private int field_72741_A;
    @Shadow
    private int field_72766_m;
    @Shadow
    private int field_72763_n;
    @Shadow
    private int field_72764_o;
    @Shadow
    private WorldRenderer[] field_72765_l;
    @Shadow
    private WorldClient field_72769_h;
    @Shadow
    private List field_72767_j;
    @Shadow
    private int field_72753_P;
    @Shadow
    private int field_72744_L;
    @Shadow
    private int field_72745_M;
    @Shadow
    private int field_72746_N;
    @Shadow
    private int field_72747_O;
    @Shadow
    public int field_72751_K;
    @Shadow
    private Minecraft field_72777_q;
    @Shadow
    private int field_72749_I;
    @Shadow
    private int field_72750_J;
    @Shadow
    public WorldRenderer[] field_72768_k;
    @Shadow
    private int field_72752_Q;
    @Shadow
    private int field_147603_i;
    @Shadow
    private int field_147600_j;
    @Shadow
    private int field_147601_k;
    @Shadow
    private double field_147596_f;
    @Shadow
    private double field_147597_g;
    @Shadow
    private double field_147602_h;
    @Shadow
    private RenderList[] field_72754_S;
    @Shadow
    public int field_72739_F;
    @Shadow
    private int field_72757_g;
    private Thread clientThread;
    private ArrayList<WorldRenderer> worldRenderersToUpdateList;
    private double prevRenderX;
    private double prevRenderY;
    private double prevRenderZ;
    private int cameraStaticTime;
    private short alphaSortProgress = 0;
    private byte frameCounter;
    private byte frameTarget;
    private int renderersNeedUpdate;
    private boolean resortUpdateList;
    private IRendererUpdateOrderProvider rendererUpdateOrderProvider;
    private List<IRenderGlobalListener> eventListeners;
    private volatile boolean deferNewRenderUpdates;

    @Shadow
    protected abstract void func_72722_c(int var1, int var2, int var3);

    @Shadow
    public abstract void func_72733_a(int var1, double var2);

    @Shadow
    public abstract void func_72712_a();

    private void addRendererToUpdateQueue(WorldRenderer wr) {
        if (!((IWorldRenderer)wr).arch$isInUpdateList()) {
            ((IWorldRenderer)wr).arch$setInUpdateList(true);
            if (this.field_72777_q.field_71451_h == null || this.resortUpdateList) {
                this.worldRenderersToUpdateList.add(wr);
                this.resortUpdateList = true;
                return;
            }
            if (this.worldRenderersToUpdateList.size() > 0) {
                double targetDistance = WorldRendererDistanceHelper.betterDistanceSquared((Entity)this.field_72777_q.field_71451_h, wr);
                int low = 0;
                int high = this.worldRenderersToUpdateList.size() - 1;
                int finalIndex = -1;
                while (low <= high) {
                    int mid = low + (high - low) / 2;
                    WorldRenderer other = this.worldRenderersToUpdateList.get(mid);
                    double otherDistance = WorldRendererDistanceHelper.betterDistanceSquared((Entity)this.field_72777_q.field_71451_h, other);
                    if (otherDistance < targetDistance) {
                        low = mid + 1;
                        continue;
                    }
                    if (otherDistance > targetDistance) {
                        high = mid - 1;
                        continue;
                    }
                    finalIndex = mid;
                    break;
                }
                if (finalIndex == -1) {
                    finalIndex = high;
                }
                this.worldRenderersToUpdateList.add(finalIndex + 1, wr);
            } else {
                this.worldRenderersToUpdateList.add(wr);
            }
        }
    }

    @Inject(method={"markBlocksForUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleOffthreadUpdate(int x1, int y1, int z1, int x2, int y2, int z2, CallbackInfo ci) {
        ci.cancel();
        if (this.deferNewRenderUpdates || Thread.currentThread() != this.clientThread) {
            OcclusionHelpers.updateArea(x1, y1, z1, x2, y2, z2);
        } else {
            this.internalMarkBlockUpdate(x1, y1, z1, x2, y2, z2);
        }
    }

    @Override
    public void internalMarkBlockUpdate(int x1, int y1, int z1, int x2, int y2, int z2) {
        int xStart = MathHelper.func_76137_a((int)x1, (int)16);
        int yStart = MathHelper.func_76137_a((int)y1, (int)16);
        int zStart = MathHelper.func_76137_a((int)z1, (int)16);
        int xEnd = MathHelper.func_76137_a((int)x2, (int)16);
        int yEnd = MathHelper.func_76137_a((int)y2, (int)16);
        int zEnd = MathHelper.func_76137_a((int)z2, (int)16);
        int width = this.field_72766_m;
        int height = this.field_72763_n;
        int depth = this.field_72764_o;
        WorldRenderer[] worldRenderers = this.field_72765_l;
        boolean rebuild = false;
        for (int i = xStart; i <= xEnd; ++i) {
            int x = i % width;
            x += width & x >> 31;
            for (int j = yStart; j <= yEnd; ++j) {
                int y = j % height;
                y += height & y >> 31;
                for (int k = zStart; k <= zEnd; ++k) {
                    int z = k % depth;
                    z += depth & z >> 31;
                    int k4 = (z * height + y) * width + x;
                    WorldRenderer worldrenderer = worldRenderers[k4];
                    if (!worldrenderer.field_78939_q || worldrenderer.field_78936_t && !((IWorldRenderer)worldrenderer).arch$isInUpdateList()) {
                        worldrenderer.func_78914_f();
                        Chunk chunk = this.field_72769_h.func_72938_d(worldrenderer.field_78923_c, worldrenderer.field_78921_e);
                        if (((ICulledChunk)chunk).getVisibility()[worldrenderer.field_78920_d >> 4].isRenderDirty()) {
                            rebuild = true;
                        }
                        this.addRendererToUpdateQueue(worldrenderer);
                        continue;
                    }
                    for (IRenderGlobalListener l : this.eventListeners) {
                        l.onDirtyRendererChanged(worldrenderer);
                    }
                }
            }
        }
        if (rebuild) {
            OcclusionHelpers.worker.dirty = true;
        }
    }

    @Redirect(method={"renderEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/RenderManager;renderEntitySimple(Lnet/minecraft/entity/Entity;F)Z"))
    private boolean skipRenderingIfNotVisible(RenderManager instance, Entity entity, float tick) {
        WorldRenderer rend = this.getRenderer(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (rend != null && !rend.field_78936_t) {
            --this.field_72749_I;
            ++this.field_72750_J;
            return false;
        }
        return RenderManager.field_78727_a.func_147937_a(entity, tick);
    }

    @Overwrite
    public String func_72735_c() {
        StringBuilder r = new StringBuilder(80);
        r.append("C: ").append(this.field_72746_N).append('/').append(this.field_72751_K).append('/').append(this.field_72765_l.length);
        r.append(". F: ").append(this.field_72744_L);
        r.append(", O: ").append(this.field_72745_M);
        r.append(", E: ").append(this.field_72747_O);
        r.append(", I: ").append(this.field_72753_P);
        r.append("; U: ").append(this.renderersNeedUpdate);
        r.append(", N: ").append(this.field_72767_j.size());
        return r.toString();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initBetterLists(Minecraft p_i1249_1_, CallbackInfo ci) {
        this.worldRenderersToUpdateList = new ArrayList();
        this.field_72767_j = Collections.unmodifiableList(this.worldRenderersToUpdateList);
        this.clientThread = Thread.currentThread();
        this.rendererUpdateOrderProvider = new DefaultRendererUpdateOrderProvider();
        this.eventListeners = new ArrayList<IRenderGlobalListener>();
    }

    @Redirect(method={"loadRenderers"}, at=@At(value="INVOKE", target="Ljava/util/List;clear()V", ordinal=0))
    private void clearRendererUpdateQueue(List instance) {
        if (instance == this.field_72767_j) {
            for (WorldRenderer wr : this.worldRenderersToUpdateList) {
                ((IWorldRenderer)wr).arch$setInUpdateList(false);
            }
        } else {
            throw new AssertionError((Object)"Transformer applied to the wrong List.clear method");
        }
        this.worldRenderersToUpdateList.clear();
    }

    @Redirect(method={"loadRenderers", "markRenderersForNewPosition"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0))
    private boolean sortAndAddRendererUpdateQueue(List instance, Object renderer) {
        if (instance == this.field_72767_j) {
            this.addRendererToUpdateQueue((WorldRenderer)renderer);
            return true;
        }
        throw new AssertionError((Object)"Transformer applied to the wrong List.clear method");
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/OpenGlCapsChecker;checkARBOcclusion()Z"))
    private boolean neverEnableOcclusion() {
        return false;
    }

    private static int fixPos(int pos, int amt) {
        int r = Math.floorDiv(pos, 16) % amt;
        if (r < 0) {
            r += amt;
        }
        return r;
    }

    @Override
    public WorldRenderer getRenderer(int x, int y, int z) {
        if (y - 15 > this.field_72743_C || y < this.field_72779_z || x - 15 > this.field_72742_B || x < this.field_72780_y || z - 15 > this.field_72737_D || z < this.field_72741_A) {
            return null;
        }
        x = MixinRenderGlobal.fixPos(x, this.field_72766_m);
        y = MixinRenderGlobal.fixPos(y, this.field_72763_n);
        z = MixinRenderGlobal.fixPos(z, this.field_72764_o);
        return this.field_72765_l[(z * this.field_72763_n + y) * this.field_72766_m + x];
    }

    @Override
    public WorldRenderer getRenderer(double x, double y, double z) {
        int X = MathHelper.func_76128_c((double)x);
        int Y = MathHelper.func_76128_c((double)y);
        int Z = MathHelper.func_76128_c((double)z);
        return this.getRenderer(X, Y, Z);
    }

    private boolean rebuildChunks(EntityLivingBase view, long deadline) {
        int updateLimit = deadline == 0L ? 5 : Integer.MAX_VALUE;
        int updates = 0;
        boolean spareTime = true;
        this.deferNewRenderUpdates = true;
        this.rendererUpdateOrderProvider.prepare(this.worldRenderersToUpdateList);
        int c = 0;
        while (updates < updateLimit && this.rendererUpdateOrderProvider.hasNext(this.worldRenderersToUpdateList)) {
            WorldRenderer worldrenderer = this.rendererUpdateOrderProvider.next(this.worldRenderersToUpdateList);
            ((IWorldRenderer)worldrenderer).arch$setInUpdateList(false);
            if (worldrenderer.field_78927_l & worldrenderer.field_78936_t || OcclusionHelpers.DEBUG_LAZY_CHUNK_UPDATES) {
                long t;
                boolean e = worldrenderer.field_78935_u;
                worldrenderer.func_147892_a(view);
                worldrenderer.field_78936_t = worldrenderer.field_78936_t & !e;
                worldrenderer.field_78935_u = worldrenderer.func_78906_e() || this.field_72777_q.field_71441_e.func_72938_d(worldrenderer.field_78923_c, worldrenderer.field_78921_e) instanceof EmptyChunk;
                ++updates;
                if ((!worldrenderer.field_78935_u || deadline != 0L || OcclusionHelpers.DEBUG_LAZY_CHUNK_UPDATES) && (t = System.nanoTime()) > deadline) {
                    spareTime = false;
                    break;
                }
            }
            ++c;
        }
        this.rendererUpdateOrderProvider.cleanup(this.worldRenderersToUpdateList);
        this.deferNewRenderUpdates = false;
        return spareTime;
    }

    @Inject(method={"updateRenderers"}, at={@At(value="HEAD")}, cancellable=true)
    private void performCullingUpdates(EntityLivingBase view, boolean p_72716_2_, CallbackInfoReturnable<Boolean> cir) {
        this.field_72769_h.field_72984_F.func_76320_a("deferred_updates");
        while (OcclusionHelpers.deferredAreas.size() > 0) {
            OcclusionHelpers.processUpdate(this);
        }
        this.field_72769_h.field_72984_F.func_76318_c("rebuild");
        CameraInfo cam = CameraInfo.getInstance();
        boolean cameraMoved = cam.getEyeX() != this.prevRenderX || cam.getEyeY() != this.prevRenderY || cam.getEyeZ() != this.prevRenderZ;
        this.prevRenderX = cam.getEyeX();
        this.prevRenderY = cam.getEyeY();
        this.prevRenderZ = cam.getEyeZ();
        boolean cameraRotated = PreviousActiveRenderInfo.changed();
        this.cameraStaticTime = !cameraRotated && !cameraMoved ? ++this.cameraStaticTime : 0;
        if (this.resortUpdateList) {
            this.worldRenderersToUpdateList.sort(new BasicDistanceSorter(this.field_72777_q.field_71451_h));
            this.resortUpdateList = false;
        }
        if (!this.field_72767_j.isEmpty()) {
            this.frameCounter = (byte)(this.frameCounter + 1);
            boolean doUpdateAcceleration = this.cameraStaticTime > 2 && !OcclusionHelpers.DEBUG_LAZY_CHUNK_UPDATES && !OcclusionHelpers.DEBUG_NO_UPDATE_ACCELERATION;
            this.rebuildChunks(view, !doUpdateAcceleration ? OcclusionHelpers.chunkUpdateDeadline : this.field_72777_q.field_71460_t.field_78510_Z + 33333333L);
        }
        this.field_72769_h.field_72984_F.func_76318_c("scan");
        int yaw = MathHelper.func_76141_d((float)(view.field_70177_z + 45.0f)) >> 4;
        int pitch = MathHelper.func_76141_d((float)(view.field_70125_A + 45.0f)) >> 4;
        if (OcclusionHelpers.worker.dirty || cameraRotated || OcclusionHelpers.DEBUG_ALWAYS_RUN_OCCLUSION) {
            OcclusionHelpers.worker.run(true);
            PreviousActiveRenderInfo.update();
        }
        this.field_72769_h.field_72984_F.func_76319_b();
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"setWorldAndLoadRenderers"}, at={@At(value="HEAD")})
    private void setWorkerWorld(WorldClient world, CallbackInfo ci) {
        OcclusionHelpers.worker.setWorld((RenderGlobal)this, world);
    }

    @Inject(method={"loadRenderers"}, at={@At(value="HEAD")})
    private void resetLoadedRenderers(CallbackInfo ci) {
        if (this.field_72769_h != null) {
            this.field_72751_K = 0;
        }
    }

    @Inject(method={"loadRenderers"}, at={@At(value="TAIL")})
    private void resetOcclusionWorker(CallbackInfo ci) {
        OcclusionHelpers.updateRendererNeighbors((RenderGlobal)this, this.field_72765_l, this.field_72766_m, this.field_72764_o, this.field_72763_n);
        if (OcclusionHelpers.worker != null) {
            OcclusionHelpers.worker.dirty = true;
        }
    }

    @Override
    public void pushWorkerRenderer(WorldRenderer wr) {
        if (!(this.field_72777_q.field_71441_e.func_72938_d(wr.field_78923_c, wr.field_78921_e) instanceof EmptyChunk)) {
            this.addRendererToUpdateQueue(wr);
        }
    }

    @Redirect(method={"loadRenderers"}, at=@At(value="INVOKE", target="Ljava/util/Arrays;sort([Ljava/lang/Object;Ljava/util/Comparator;)V", ordinal=0))
    private void skipSort2(Object[] ts, Comparator<?> comparator) {
    }

    @Redirect(method={"loadRenderers"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;markDirty()V", ordinal=0))
    private void markRendererInvisible(WorldRenderer instance) {
        instance.field_78936_t = false;
        instance.field_78927_l = false;
        instance.func_78914_f();
    }

    @Redirect(method={"markRenderersForNewPosition"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;setPosition(III)V"))
    private void setPositionAndMarkInvisible(WorldRenderer wr, int x, int y, int z) {
        wr.func_78913_a(x, y, z);
        if (((IWorldRenderer)wr).arch$isInUpdateList()) {
            this.resortUpdateList = true;
        }
        if (!wr.field_78915_A) {
            wr.field_78935_u = false;
            wr.field_78936_t = false;
        }
    }

    @Inject(method={"markRenderersForNewPosition"}, at={@At(value="TAIL")})
    private void runWorker(int p_72722_1_, int p_72722_2_, int p_72722_3_, CallbackInfo ci) {
        OcclusionHelpers.updateRendererNeighbors((RenderGlobal)this, this.field_72765_l, this.field_72766_m, this.field_72764_o, this.field_72763_n);
        OcclusionHelpers.worker.run(true);
    }

    @Overwrite
    public int func_72719_a(EntityLivingBase view, int pass, double tick) {
        CameraInfo cam = CameraInfo.getInstance();
        cam.update(view, tick);
        this.field_72769_h.field_72984_F.func_76320_a("sortchunks");
        if (this.field_72777_q.field_71474_y.field_151451_c != this.field_72739_F && !(this.field_72777_q.field_71462_r instanceof GuiVideoSettings)) {
            this.func_72712_a();
        }
        WorldRenderer[] sortedWorldRenderers = this.field_72768_k;
        if (this.field_72751_K > 0) {
            int e = this.field_72751_K - 10;
            e &= e >> 31;
            e += 10;
            for (int j = 0; j < e; ++j) {
                this.field_72752_Q = (this.field_72752_Q + 1) % this.field_72751_K;
                WorldRenderer rend = sortedWorldRenderers[this.field_72752_Q];
                if (!(rend.field_78927_l & rend.field_78936_t & (rend.field_78939_q || !rend.field_78915_A) & !(this.field_72777_q.field_71441_e.func_72938_d(rend.field_78923_c, rend.field_78921_e) instanceof EmptyChunk))) continue;
                this.addRendererToUpdateQueue(rend);
            }
        }
        this.field_72769_h.field_72984_F.func_76320_a("reposition_chunks");
        if (this.field_147603_i != cam.getChunkCoordX() || this.field_147600_j != cam.getChunkCoordY() || this.field_147601_k != cam.getChunkCoordZ()) {
            this.field_147603_i = cam.getChunkCoordX();
            this.field_147600_j = cam.getChunkCoordY();
            this.field_147601_k = cam.getChunkCoordZ();
            this.func_72722_c(MathHelper.func_76128_c((double)cam.getX()), MathHelper.func_76128_c((double)cam.getY()), MathHelper.func_76128_c((double)cam.getZ()));
            this.resortUpdateList = true;
        }
        this.field_72769_h.field_72984_F.func_76319_b();
        if (pass == 1) {
            int amt;
            this.field_72769_h.field_72984_F.func_76320_a("alpha_sort");
            if (MixinRenderGlobal.distanceSquared(cam.getX(), cam.getY(), cam.getZ(), this.field_147596_f, this.field_147597_g, this.field_147602_h) > 1.0) {
                this.field_147596_f = cam.getX();
                this.field_147597_g = cam.getY();
                this.field_147602_h = cam.getZ();
                this.alphaSortProgress = 0;
            }
            int n = amt = this.field_72751_K < 27 ? this.field_72751_K : Math.max(this.field_72751_K >> 1, 27);
            if (this.alphaSortProgress < amt) {
                int amountPerFrame = 1;
                for (int i = 0; i < amountPerFrame && this.alphaSortProgress < amt; ++i) {
                    short s = this.alphaSortProgress;
                    this.alphaSortProgress = (short)(s + 1);
                    WorldRenderer r = sortedWorldRenderers[s];
                    r.func_147889_b(view);
                }
            }
            this.field_72769_h.field_72984_F.func_76319_b();
        }
        this.field_72769_h.field_72984_F.func_76318_c("render");
        RenderHelper.func_74518_a();
        int k = this.func_72724_a(0, this.field_72751_K, pass, tick);
        this.field_72769_h.field_72984_F.func_76319_b();
        return k;
    }

    @Overwrite
    protected int func_72724_a(int start, int end, int pass, double tick) {
        CameraInfo cam = CameraInfo.getInstance();
        RenderList[] allRenderLists = this.field_72754_S;
        for (int i = 0; i < allRenderLists.length; ++i) {
            allRenderLists[i].func_78421_b();
        }
        int loopStart = start;
        int loopEnd = end;
        int dir = 1;
        if (pass == 1) {
            loopStart = end - 1;
            loopEnd = start - 1;
            dir = -1;
        }
        if (pass == 0 && this.field_72777_q.field_71474_y.field_74330_P) {
            this.field_72777_q.field_71441_e.field_72984_F.func_76320_a("debug_info");
            int renderersNotInitialized = 0;
            int renderersBeingClipped = 0;
            int renderersBeingOccluded = 0;
            int renderersBeingRendered = 0;
            int renderersSkippingRenderPass = 0;
            int renderersNeedUpdate = 0;
            for (WorldRenderer rend : this.field_72765_l) {
                if (!rend.field_78915_A) {
                    ++renderersNotInitialized;
                } else if (!rend.field_78927_l) {
                    ++renderersBeingClipped;
                } else if (!rend.field_78936_t) {
                    ++renderersBeingOccluded;
                } else if (rend.field_78935_u) {
                    ++renderersSkippingRenderPass;
                } else {
                    ++renderersBeingRendered;
                }
                if (!rend.field_78939_q) continue;
                ++renderersNeedUpdate;
            }
            this.field_72753_P = renderersNotInitialized;
            this.field_72744_L = renderersBeingClipped;
            this.field_72745_M = renderersBeingOccluded;
            this.field_72746_N = renderersBeingRendered;
            this.field_72747_O = renderersSkippingRenderPass;
            this.renderersNeedUpdate = renderersNeedUpdate;
            this.field_72777_q.field_71441_e.field_72984_F.func_76319_b();
        }
        this.field_72777_q.field_71441_e.field_72984_F.func_76320_a("setup_lists");
        int glListsRendered = 0;
        int allRenderListsLength = 0;
        WorldRenderer[] sortedWorldRenderers = this.field_72768_k;
        for (int i = loopStart; i != loopEnd; i += dir) {
            int renderListIndex;
            WorldRenderer rend;
            block14: {
                rend = sortedWorldRenderers[i];
                if (!rend.field_78936_t || !(rend.field_78927_l & !rend.field_78928_m[pass])) continue;
                for (int j = 0; j < allRenderListsLength; ++j) {
                    if (!allRenderLists[j].func_78418_a(rend.field_78918_f, rend.field_78919_g, rend.field_78931_h)) continue;
                    renderListIndex = j;
                    break block14;
                }
                renderListIndex = allRenderListsLength++;
                allRenderLists[renderListIndex].func_78422_a(rend.field_78918_f, rend.field_78919_g, rend.field_78931_h, cam.getEyeX(), cam.getEyeY(), cam.getEyeZ());
            }
            allRenderLists[renderListIndex].func_78420_a(rend.func_78909_a(pass));
            ++glListsRendered;
        }
        this.field_72777_q.field_71441_e.field_72984_F.func_76318_c("call_lists");
        int xSort = MathHelper.func_76128_c((double)cam.getX());
        int zSort = MathHelper.func_76128_c((double)cam.getZ());
        xSort -= xSort & 0x3FF;
        zSort -= zSort & 0x3FF;
        Arrays.sort(allRenderLists, new RenderDistanceSorter(xSort, zSort));
        this.func_72733_a(pass, tick);
        this.field_72777_q.field_71441_e.field_72984_F.func_76319_b();
        return glListsRendered;
    }

    @Overwrite
    public void func_72729_a(ICamera p_72729_1_, float p_72729_2_) {
        for (int i = 0; i < this.field_72765_l.length; ++i) {
            if ((i + this.field_72757_g & 0xF) != 0) continue;
            WorldRenderer wr = this.field_72765_l[i];
            IWorldRenderer iwr = (IWorldRenderer)wr;
            if (!wr.field_78927_l || !iwr.arch$getCullInfo().isFrustumCheckPending) continue;
            wr.func_78908_a(p_72729_1_);
            iwr.arch$getCullInfo().isFrustumCheckPending = false;
            if (wr.field_78927_l) continue;
            ++OcclusionHelpers.worker.dirtyFrustumRenderers;
        }
        ++this.field_72757_g;
        if (this.field_72757_g % 15 == 0 && OcclusionHelpers.worker.dirtyFrustumRenderers > 0) {
            OcclusionHelpers.worker.dirty = true;
            OcclusionHelpers.worker.dirtyFrustumRenderers = 0;
        }
    }

    @Override
    public void arch$setRendererUpdateOrderProvider(IRendererUpdateOrderProvider orderProvider) {
        this.rendererUpdateOrderProvider = orderProvider;
    }

    @Override
    public void arch$addRenderGlobalListener(IRenderGlobalListener listener) {
        this.eventListeners.add(listener);
    }

    private static double distanceSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0);
    }
}

