/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.client.threadedupdates;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.client.ForgeHooksClient;
import org.embeddedt.archaicfix.threadedupdates.IRendererUpdateResultHolder;
import org.embeddedt.archaicfix.threadedupdates.ThreadedChunkUpdateHelper;
import org.embeddedt.archaicfix.threadedupdates.api.ThreadedChunkUpdates;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RenderBlocks.class})
public class MixinRenderBlocks {
    @Inject(method={"renderBlockByRenderType"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;setBlockBoundsBasedOnState(Lnet/minecraft/world/IBlockAccess;III)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void cancelRenderDelegatedToDifferentThread(Block block, int x, int y, int z, CallbackInfoReturnable<Boolean> cir, int renderType) {
        boolean offThreadBlock;
        int pass = ForgeHooksClient.getWorldRenderPass();
        boolean mainThread = Thread.currentThread() == ThreadedChunkUpdateHelper.MAIN_THREAD;
        ThreadedChunkUpdateHelper.UpdateTask task = mainThread ? ((IRendererUpdateResultHolder)ThreadedChunkUpdateHelper.lastWorldRenderer).arch$getRendererUpdateTask() : null;
        boolean bl = offThreadBlock = ThreadedChunkUpdateHelper.canBlockBeRenderedOffThread(block, pass, renderType) && (task == null || !task.cancelled);
        if ((!mainThread || pass >= 0) && (mainThread ? offThreadBlock : !offThreadBlock)) {
            cir.setReturnValue((Object)(mainThread ? task.result[pass].renderedSomething : false));
        }
    }

    @Redirect(method={"*"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/Tessellator;instance:Lnet/minecraft/client/renderer/Tessellator;"))
    private Tessellator modifyTessellatorAccess() {
        return ThreadedChunkUpdates.getThreadTessellator();
    }
}

