/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.core;

import com.google.common.collect.Iterators;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.ducks.IArchaicWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class}, priority=1100)
public class MixinChunk {
    @Shadow
    @Final
    private List<Entity>[] field_76645_j;
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    public Map field_150816_i;
    private static LinkedList<ChunkCoordIntPair> arch$populatingChunk = new LinkedList();

    @Inject(method={"onChunkUnload"}, at={@At(value="HEAD")})
    public void handlePlayerChunkUnload(CallbackInfo ci) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (List<Entity> list : this.field_76645_j) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityPlayer)) continue;
                players.add((EntityPlayer)entity);
            }
        }
        for (EntityPlayer player : players) {
            this.field_76637_e.func_72866_a((Entity)player, false);
        }
    }

    @Redirect(method={"onChunkUnload"}, at=@At(value="INVOKE", target="Ljava/util/Collection;iterator()Ljava/util/Iterator;", ordinal=0))
    private Iterator markTEForUnload(Collection instance) {
        if (ArchaicConfig.fixTEUnloadLag) {
            ((IArchaicWorld)this.field_76637_e).arch$markTileEntitiesInChunkForRemoval((Chunk)this);
            return Iterators.emptyIterator();
        }
        return instance.iterator();
    }

    @Inject(method={"getBiomeGenForWorldCoords"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/biome/WorldChunkManager;getBiomeGenAt(II)Lnet/minecraft/world/biome/BiomeGenBase;")}, cancellable=true)
    private void avoidBiomeGenOnClient(int p_76591_1_, int p_76591_2_, WorldChunkManager p_76591_3_, CallbackInfoReturnable<BiomeGenBase> cir) {
        if (this.field_76637_e.field_72995_K) {
            cir.setReturnValue((Object)BiomeGenBase.field_76771_b);
        }
    }

    private void logCascadingWorldGeneration() {
        ModContainer activeModContainer = Loader.instance().activeModContainer();
        String format = "{} loaded a new chunk {} in dimension {} ({}) while populating chunk {}, causing cascading worldgen lag.";
        ChunkCoordIntPair pos = new ChunkCoordIntPair(this.field_76635_g, this.field_76647_h);
        if (activeModContainer == null) {
            ArchaicLogger.LOGGER.warn(format, new Object[]{"Minecraft", pos, this.field_76637_e.field_73011_w.field_76574_g, this.field_76637_e.field_73011_w.func_80007_l(), arch$populatingChunk.peek()});
        } else {
            ArchaicLogger.LOGGER.warn(format, new Object[]{activeModContainer.getName(), pos, this.field_76637_e.field_73011_w.field_76574_g, this.field_76637_e.field_73011_w.func_80007_l(), arch$populatingChunk.peek()});
            ArchaicLogger.LOGGER.warn("Please report this to the mod's issue tracker. This log can be disabled in the ArchaicFix config.");
        }
        if (ArchaicConfig.logCascadingWorldgenStacktrace) {
            ArchaicLogger.LOGGER.warn("Stacktrace", (Throwable)new Exception("Cascading world generation"));
        }
    }

    @Inject(method={"populateChunk"}, at={@At(value="HEAD")})
    private void savePopulatingChunk(IChunkProvider p_76624_1_, IChunkProvider p_76624_2_, int x, int z, CallbackInfo ci) {
        if (arch$populatingChunk.size() > 0 && ArchaicConfig.logCascadingWorldgen) {
            this.logCascadingWorldGeneration();
        }
        arch$populatingChunk.push(new ChunkCoordIntPair(x, z));
    }

    @Inject(method={"populateChunk"}, at={@At(value="TAIL")})
    private void restorePopulatingChunk(IChunkProvider p_76624_1_, IChunkProvider p_76624_2_, int p_76624_3_, int p_76624_4_, CallbackInfo ci) {
        arch$populatingChunk.pop();
    }
}

