/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.lighting;

import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.embeddedt.archaicfix.lighting.api.IChunkLighting;
import org.embeddedt.archaicfix.lighting.api.IChunkLightingData;
import org.embeddedt.archaicfix.lighting.api.ILightingEngine;
import org.embeddedt.archaicfix.lighting.api.ILightingEngineProvider;
import org.embeddedt.archaicfix.lighting.world.WorldChunkSlice;
import org.embeddedt.archaicfix.lighting.world.lighting.LightingHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class})
public abstract class MixinChunk
implements IChunkLighting,
IChunkLightingData,
ILightingEngineProvider {
    private static final EnumFacing[] HORIZONTAL = LightingHooks.HORIZONTAL_FACINGS;
    private short[] neighborLightChecks;
    private boolean isLightInitialized;
    private ILightingEngine lightingEngine;
    @Shadow
    public World field_76637_e;
    @Shadow
    private ExtendedBlockStorage[] field_76652_q;
    @Shadow
    public int[] field_76634_f;
    @Shadow
    public int field_82912_p;
    @Shadow
    public boolean field_76646_k;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    private boolean field_76650_s;
    @Shadow
    public boolean[] field_76639_c;
    @Shadow
    public boolean field_76643_l;
    @Shadow
    private int field_76649_t;

    @Inject(method={"getBlockLightValue"}, at={@At(value="HEAD")})
    private void onGetLightSubtracted(int x, int y, int z, int amount, CallbackInfoReturnable<Integer> cir) {
        this.getLightingEngine().processLightUpdates();
    }

    @Inject(method={"onChunkLoad"}, at={@At(value="RETURN")})
    private void onLoad(CallbackInfo ci) {
        LightingHooks.scheduleRelightChecksForChunkBoundaries(this.field_76637_e, (Chunk)this);
    }

    @Redirect(method={"setLightValue"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;generateSkylightMap()V"), expect=0)
    private void setLightForRedirectGenerateSkylightMap(Chunk chunk, EnumSkyBlock type, int x, int y, int z, int value) {
        LightingHooks.initSkylightForSection(this.field_76637_e, (Chunk)this, this.field_76652_q[y >> 4]);
    }

    private int getBlockLightOpacity(int x, int y, int z) {
        return this.func_150810_a(x, y, z).getLightOpacity((IBlockAccess)this.field_76637_e, x, y, z);
    }

    @Overwrite
    public void func_76615_h(int x, int y, int z) {
        int i;
        int j = i = this.field_76634_f[z << 4 | x] & 0xFF;
        if (y > i) {
            j = y;
        }
        while (j > 0 && this.getBlockLightOpacity(x, j - 1, z) == 0) {
            --j;
        }
        if (j != i) {
            int l1;
            this.field_76634_f[z << 4 | x] = j;
            if (!this.field_76637_e.field_73011_w.field_76576_e) {
                LightingHooks.relightSkylightColumn(this.field_76637_e, (Chunk)this, x, z, i, j);
            }
            if ((l1 = this.field_76634_f[z << 4 | x]) < this.field_82912_p) {
                this.field_82912_p = l1;
            }
        }
    }

    @Overwrite
    public int func_76614_a(EnumSkyBlock type, int x, int y, int z) {
        this.getLightingEngine().processLightUpdatesForType(type);
        return this.getCachedLightFor(type, x, y, z);
    }

    @Overwrite
    public void func_150809_p() {
        this.field_76646_k = true;
        LightingHooks.checkChunkLighting((Chunk)this, this.field_76637_e);
    }

    @Overwrite
    public void func_150803_c(boolean onlyOne) {
        this.field_76637_e.field_72984_F.func_76320_a("recheckGaps");
        WorldChunkSlice slice = new WorldChunkSlice(this.field_76637_e, this.field_76635_g, this.field_76647_h);
        if (this.field_76637_e.func_72873_a(this.field_76635_g * 16 + 8, 0, this.field_76647_h * 16 + 8, 16)) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (!this.recheckGapsForColumn(slice, x, z) || !onlyOne) continue;
                    this.field_76637_e.field_72984_F.func_76319_b();
                    return;
                }
            }
            this.field_76650_s = false;
        }
        this.field_76637_e.field_72984_F.func_76319_b();
    }

    private boolean recheckGapsForColumn(WorldChunkSlice slice, int x, int z) {
        int i = x + z * 16;
        if (this.field_76639_c[i]) {
            this.field_76639_c[i] = false;
            int height = this.func_76611_b(x, z);
            int x1 = this.field_76635_g * 16 + x;
            int z1 = this.field_76647_h * 16 + z;
            int max = this.recheckGapsGetLowestHeight(slice, x1, z1);
            this.recheckGapsSkylightNeighborHeight(slice, x1, z1, height, max);
            return true;
        }
        return false;
    }

    private int recheckGapsGetLowestHeight(WorldChunkSlice slice, int x, int z) {
        int max = Integer.MAX_VALUE;
        for (EnumFacing facing : HORIZONTAL) {
            int j = x + facing.func_82601_c();
            int k = z + facing.func_82599_e();
            max = Math.min(max, slice.getChunkFromWorldCoords((int)j, (int)k).field_82912_p);
        }
        return max;
    }

    private void recheckGapsSkylightNeighborHeight(WorldChunkSlice slice, int x, int z, int height, int max) {
        this.checkSkylightNeighborHeight(slice, x, z, max);
        for (EnumFacing facing : HORIZONTAL) {
            int j = x + facing.func_82601_c();
            int k = z + facing.func_82599_e();
            this.checkSkylightNeighborHeight(slice, j, k, height);
        }
    }

    private void checkSkylightNeighborHeight(WorldChunkSlice slice, int x, int z, int maxValue) {
        int i = slice.getChunkFromWorldCoords(x, z).func_76611_b(x & 0xF, z & 0xF);
        if (i > maxValue) {
            this.updateSkylightNeighborHeight(slice, x, z, maxValue, i + 1);
        } else if (i < maxValue) {
            this.updateSkylightNeighborHeight(slice, x, z, i, maxValue + 1);
        }
    }

    private void updateSkylightNeighborHeight(WorldChunkSlice slice, int x, int z, int startY, int endY) {
        if (endY > startY) {
            if (!slice.isLoaded(x, z, 16)) {
                return;
            }
            for (int i = startY; i < endY; ++i) {
                this.field_76637_e.func_147463_c(EnumSkyBlock.Sky, x, i, z);
            }
            this.field_76643_l = true;
        }
    }

    @Overwrite
    public void func_76594_o() {
        if (this.field_76649_t >= 4096) {
            return;
        }
        boolean isActiveChunk = this.field_76637_e.field_72993_I.contains(new ChunkCoordIntPair(this.field_76635_g, this.field_76647_h));
        int lightRecheckSpeed = this.field_76637_e.field_72995_K && isActiveChunk ? 256 : (this.field_76637_e.field_72995_K ? 64 : 32);
        for (int i = 0; i < lightRecheckSpeed; ++i) {
            if (this.field_76649_t >= 4096) {
                return;
            }
            int section = this.field_76649_t % 16;
            int x = this.field_76649_t / 16 % 16;
            int z = this.field_76649_t / 256;
            ++this.field_76649_t;
            int bx = (this.field_76635_g << 4) + x;
            int bz = (this.field_76647_h << 4) + z;
            for (int y = 0; y < 16; ++y) {
                int by = (section << 4) + y;
                ExtendedBlockStorage storage = this.field_76652_q[section];
                boolean performFullLightUpdate = false;
                if (storage == null && (y == 0 || y == 15 || x == 0 || x == 15 || z == 0 || z == 15)) {
                    performFullLightUpdate = true;
                } else if (storage != null) {
                    Block block = storage.func_150819_a(x, y, z);
                    if (block.getLightOpacity((IBlockAccess)this.field_76637_e, bx, by, bz) >= 255 && block.getLightValue((IBlockAccess)this.field_76637_e, bx, by, bz) <= 0) {
                        int prevLight = storage.func_76674_d(x, y, z);
                        if (prevLight != 0) {
                            storage.func_76677_d(x, y, z, 0);
                            this.field_76637_e.func_147458_c(bx, by, bz, bx, by, bz);
                        }
                    } else {
                        performFullLightUpdate = true;
                    }
                }
                if (!performFullLightUpdate) continue;
                this.field_76637_e.func_147451_t(bx, by, bz);
            }
        }
    }

    @Shadow
    public abstract int func_76611_b(int var1, int var2);

    @Override
    public short[] getNeighborLightChecks() {
        return this.neighborLightChecks;
    }

    @Override
    public void setNeighborLightChecks(short[] data) {
        this.neighborLightChecks = data;
    }

    @Override
    public ILightingEngine getLightingEngine() {
        if (this.lightingEngine == null) {
            this.lightingEngine = ((ILightingEngineProvider)this.field_76637_e).getLightingEngine();
            if (this.lightingEngine == null) {
                throw new IllegalStateException();
            }
        }
        return this.lightingEngine;
    }

    @Override
    public boolean isLightInitialized() {
        return this.isLightInitialized;
    }

    @Override
    public void setLightInitialized(boolean lightInitialized) {
        this.isLightInitialized = lightInitialized;
    }

    @Shadow
    public abstract boolean func_76619_d(int var1, int var2, int var3);

    @Shadow
    public abstract Block func_150810_a(int var1, int var2, int var3);

    @Override
    public void setSkylightUpdatedPublic() {
        for (int i = 0; i < this.field_76639_c.length; ++i) {
            this.field_76639_c[i] = true;
        }
        this.func_150803_c(false);
    }

    @Override
    public int getCachedLightFor(EnumSkyBlock type, int xIn, int yIn, int zIn) {
        int i = xIn & 0xF;
        int j = yIn;
        int k = zIn & 0xF;
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[j >> 4];
        if (extendedblockstorage == null) {
            if (this.func_76619_d(i, j, k)) {
                return type.field_77198_c;
            }
            return 0;
        }
        if (type == EnumSkyBlock.Sky) {
            if (this.field_76637_e.field_73011_w.field_76576_e) {
                return 0;
            }
            return extendedblockstorage.func_76670_c(i, j & 0xF, k);
        }
        if (type == EnumSkyBlock.Block) {
            return extendedblockstorage.func_76674_d(i, j & 0xF, k);
        }
        return type.field_77198_c;
    }
}

