/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.occlusion;

import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import org.embeddedt.archaicfix.occlusion.SetVisibility;
import org.embeddedt.archaicfix.occlusion.util.IntStack;

public class VisGraph {
    private static final int X_OFFSET = (int)Math.pow(16.0, 0.0);
    private static final int Z_OFFSET = (int)Math.pow(16.0, 1.0);
    private static final int Y_OFFSET = (int)Math.pow(16.0, 2.0);
    private static final int[] EDGES = new int[1352];
    public static final long ALL_VIS = -1L;
    private final BitSet opaqueBlocks = new BitSet(4096);
    private final BitSet visibleBlocks = new BitSet(4096);
    private short transparentBlocks = (short)4096;
    private boolean dirty = true;
    private boolean computedVis = true;
    private long[] visibility = new long[]{-1L};

    private static int getIndex(int x, int y, int z) {
        return x << 0 | y << 8 | z << 4;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isRenderDirty() {
        if (this.isDirty()) {
            return true;
        }
        boolean r = this.computedVis;
        this.computedVis = false;
        return r;
    }

    public void setOpaque(int x, int y, int z, boolean opaque) {
        boolean prev = this.opaqueBlocks.get(VisGraph.getIndex(x, y, z));
        if (prev != opaque) {
            this.opaqueBlocks.set(VisGraph.getIndex(x, y, z), opaque);
            this.transparentBlocks = (short)(this.transparentBlocks + (opaque ? -1 : 1));
            this.dirty = true;
        }
    }

    public long getVisibility() {
        return this.visibility[0];
    }

    public long[] getVisibilityArray() {
        return this.visibility;
    }

    public void computeVisibility() {
        this.dirty = false;
        long setvisibility = 0L;
        if (4096 - this.transparentBlocks < 256) {
            setvisibility = -1L;
        } else if (this.transparentBlocks == 0) {
            setvisibility = 0L;
        } else {
            int[] edges = EDGES;
            int i = edges.length;
            this.visibleBlocks.andNot(this.visibleBlocks);
            this.visibleBlocks.or(this.opaqueBlocks);
            IntStack linkedlist = new IntStack(1024, 512);
            for (int j = 0; j < i; ++j) {
                int k = edges[j];
                if (!this.opaqueBlocks.get(k)) {
                    setvisibility = SetVisibility.setManyVisible(setvisibility, this.computeVisibleFacingsFrom(k, linkedlist));
                }
                linkedlist.setSize(0);
            }
        }
        this.visibility[0] = setvisibility;
        this.computedVis = true;
    }

    public Set<EnumFacing> getVisibleFacingsFrom(int x, int y, int z) {
        this.visibleBlocks.andNot(this.visibleBlocks);
        this.visibleBlocks.or(this.opaqueBlocks);
        return this.computeVisibleFacingsFrom(VisGraph.getIndex(x & 0xF, y & 0xF, z & 0xF), new IntStack(256, 512));
    }

    private EnumSet computeVisibleFacingsFrom(int index, IntStack linkedlist) {
        EnumSet<EnumFacing> enumset = EnumSet.noneOf(EnumFacing.class);
        linkedlist.add(index);
        BitSet blocks = this.visibleBlocks;
        blocks.set(index, true);
        EnumFacing[] facings = EnumFacing.values();
        int k = facings.length;
        while (!linkedlist.isEmpty()) {
            int j = linkedlist.poll();
            this.addSides(j, enumset);
            for (int l = 0; l < k; ++l) {
                EnumFacing face = facings[l];
                int i1 = this.stepTo(j, face);
                if (i1 < 0 || blocks.get(i1)) continue;
                blocks.set(i1, true);
                linkedlist.add(i1);
            }
        }
        return enumset;
    }

    private void addSides(int index, Set<EnumFacing> set) {
        int j = index >> 0 & 0xF;
        if (j == 0) {
            set.add(EnumFacing.EAST);
        } else if (j == 15) {
            set.add(EnumFacing.WEST);
        }
        int k = index >> 8 & 0xF;
        if (k == 0) {
            set.add(EnumFacing.DOWN);
        } else if (k == 15) {
            set.add(EnumFacing.UP);
        }
        int l = index >> 4 & 0xF;
        if (l == 0) {
            set.add(EnumFacing.NORTH);
        } else if (l == 15) {
            set.add(EnumFacing.SOUTH);
        }
    }

    private int stepTo(int index, EnumFacing side) {
        switch (side) {
            case DOWN: {
                if ((index >> 8 & 0xF) == 0) {
                    return -1;
                }
                return index - Y_OFFSET;
            }
            case UP: {
                if ((index >> 8 & 0xF) == 15) {
                    return -1;
                }
                return index + Y_OFFSET;
            }
            case NORTH: {
                if ((index >> 4 & 0xF) == 0) {
                    return -1;
                }
                return index - Z_OFFSET;
            }
            case SOUTH: {
                if ((index >> 4 & 0xF) == 15) {
                    return -1;
                }
                return index + Z_OFFSET;
            }
            case EAST: {
                if ((index >> 0 & 0xF) == 0) {
                    return -1;
                }
                return index - X_OFFSET;
            }
            case WEST: {
                if ((index >> 0 & 0xF) == 15) {
                    return -1;
                }
                return index + X_OFFSET;
            }
        }
        return -1;
    }

    static {
        int var2 = 0;
        for (int var3 = 0; var3 < 16; ++var3) {
            for (int var4 = 0; var4 < 16; ++var4) {
                for (int var5 = 0; var5 < 16; ++var5) {
                    if (var3 != 0 && var3 != 15 && var4 != 0 && var4 != 15 && var5 != 0 && var5 != 15) continue;
                    VisGraph.EDGES[var2++] = VisGraph.getIndex(var3, var4, var5);
                }
            }
        }
    }
}

