/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.proxy;

import com.google.common.base.Objects;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.helpers.BuiltInResourcePack;
import org.embeddedt.archaicfix.helpers.SoundDeviceThread;
import org.embeddedt.archaicfix.occlusion.OcclusionHelpers;
import org.embeddedt.archaicfix.proxy.CommonProxy;
import zone.rong.loliasm.api.LoliStringPool;

public class ClientProxy
extends CommonProxy {
    SoundDeviceThread soundThread = null;
    public static volatile boolean soundSystemReloadLock = false;
    float lastIntegratedTickTime;
    private float gameStartTime = -1.0f;

    @Override
    public void preinit() {
        super.preinit();
        Minecraft.field_71444_a = new byte[0];
        if (ArchaicConfig.enableOcclusionTweaks) {
            OcclusionHelpers.init();
        }
        MinecraftForge.EVENT_BUS.register((Object)new LoliStringPool.EventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        if (ArchaicConfig.modernizeTextures) {
            BuiltInResourcePack.register("vanilla_overrides");
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient() && event.phase == TickEvent.Phase.END) {
            IntegratedServer srv = Minecraft.func_71410_x().func_71401_C();
            if (srv != null) {
                long currentTickTime = srv.field_71311_j[srv.func_71259_af() % 100];
                this.lastIntegratedTickTime = this.lastIntegratedTickTime * 0.8f + (float)currentTickTime / 1000000.0f * 0.2f;
            } else {
                this.lastIntegratedTickTime = 0.0f;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (!event.isCanceled() && event.gui instanceof GuiMainMenu && this.gameStartTime == -1.0f) {
            this.gameStartTime = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
            ArchaicLogger.LOGGER.info("The game loaded in " + this.gameStartTime + " seconds.");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        IntegratedServer srv;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.isCanceled() || !mc.field_71474_y.field_74330_P || event.left.size() < 1) {
            return;
        }
        NetHandlerPlayClient cl = mc.func_147114_u();
        if (cl != null && (srv = mc.func_71401_C()) != null) {
            String s = String.format("Integrated server @ %.0f ms ticks", Float.valueOf(this.lastIntegratedTickTime));
            event.left.add(1, s);
        }
        if (ArchaicConfig.showBlockDebugInfo && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (!event.right.isEmpty() && ((String)Objects.firstNonNull(event.right.get(event.right.size() - 1), (Object)"")).length() > 0) {
                event.right.add("");
            }
            Block block = mc.field_71441_e.func_147439_a(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
            int meta = mc.field_71441_e.func_72805_g(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
            event.right.add(Block.field_149771_c.func_148750_c((Object)block));
            event.right.add("meta: " + meta);
        }
        if (ArchaicConfig.modernizeF3Screen) {
            boolean hasReplacedXYZ = false;
            for (int i = 0; i < event.left.size() - 3; ++i) {
                String heading_str;
                if (hasReplacedXYZ || !((String)Objects.firstNonNull(event.left.get(i), (Object)"")).startsWith("x:") || !((String)Objects.firstNonNull(event.left.get(i + 1), (Object)"")).startsWith("y:") || !((String)Objects.firstNonNull(event.left.get(i + 2), (Object)"")).startsWith("z:") || !((String)Objects.firstNonNull(event.left.get(i + 3), (Object)"")).startsWith("f:")) continue;
                hasReplacedXYZ = true;
                int heading = MathHelper.func_76128_c((double)((double)(mc.field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                switch (heading) {
                    case 0: {
                        heading_str = "Towards positive Z";
                        break;
                    }
                    case 1: {
                        heading_str = "Towards negative X";
                        break;
                    }
                    case 2: {
                        heading_str = "Towards negative Z";
                        break;
                    }
                    case 3: {
                        heading_str = "Towards positive X";
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                event.left.set(i, String.format("XYZ: %.3f / %.5f / %.3f", mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70121_D.field_72338_b, mc.field_71439_g.field_70161_v));
                int blockX = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
                int blockY = MathHelper.func_76128_c((double)mc.field_71439_g.field_70121_D.field_72338_b);
                int blockZ = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
                event.left.set(i + 1, String.format("Block: %d %d %d [%d %d %d]", blockX, blockY, blockZ, blockX & 0xF, blockY & 0xF, blockZ & 0xF));
                event.left.set(i + 2, String.format("Chunk: %d %d %d", blockX >> 4, blockY >> 4, blockZ >> 4));
                event.left.set(i + 3, String.format("Facing: %s (%s) (%.1f / %.1f)", Direction.field_82373_c[heading].toLowerCase(Locale.ROOT), heading_str, Float.valueOf(MathHelper.func_76142_g((float)mc.field_71439_g.field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)mc.field_71439_g.field_70125_A))));
            }
            event.setCanceled(true);
            FontRenderer fontrenderer = mc.field_71466_p;
            int fontColor = 0xE0E0E0;
            int rectColor = -1873784752;
            for (int x = 0; x < event.left.size(); ++x) {
                String msg = (String)event.left.get(x);
                if (msg == null) continue;
                int strX = 2;
                int strY = 2 + x * fontrenderer.field_78288_b;
                Gui.func_73734_a((int)1, (int)(strY - 1), (int)(strX + fontrenderer.func_78256_a(msg) + 1), (int)(strY + fontrenderer.field_78288_b - 1), (int)rectColor);
                fontrenderer.func_78276_b(msg, strX, strY, fontColor);
            }
            int width = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d).func_78326_a();
            for (int x = 0; x < event.right.size(); ++x) {
                String msg = (String)event.right.get(x);
                if (msg == null) continue;
                int w = fontrenderer.func_78256_a(msg);
                int strX = width - w - 2;
                int strY = 2 + x * fontrenderer.field_78288_b;
                Gui.func_73734_a((int)(strX - 1), (int)(strY - 1), (int)(strX + w + 1), (int)(strY + fontrenderer.field_78288_b - 1), (int)rectColor);
                fontrenderer.func_78276_b(msg, strX, strY, fontColor);
            }
        }
    }

    @SubscribeEvent
    public void onSoundSetup(SoundLoadEvent event) {
        soundSystemReloadLock = false;
        if (this.soundThread == null) {
            ArchaicLogger.LOGGER.info("Starting sound device thread");
            this.soundThread = new SoundDeviceThread();
            this.soundThread.start();
        }
    }
}

