/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.asm;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.asm.exceptions.AsmClassNotFoundException;
import com.falsepattern.lib.asm.exceptions.AsmFieldNotFoundException;
import com.falsepattern.lib.asm.exceptions.AsmMethodNotFoundException;
import com.falsepattern.lib.internal.asm.CoreLoadingPlugin;
import com.falsepattern.lib.mapping.MappingManager;
import com.falsepattern.lib.mapping.types.MappingType;
import com.falsepattern.lib.mapping.types.NameType;
import com.falsepattern.lib.mapping.types.UniversalClass;
import com.falsepattern.lib.mapping.types.UniversalField;
import com.falsepattern.lib.mapping.types.UniversalMethod;
import java.util.Arrays;
import java.util.Objects;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@StableAPI(since="0.10.0")
public class ASMUtil {
    @StableAPI.Expose
    public static FieldNode findFieldStandard(ClassNode cn, String name, boolean optional) {
        for (FieldNode ret : cn.fields) {
            if (!name.equals(ret.name)) continue;
            return ret;
        }
        if (optional) {
            return null;
        }
        throw new AsmFieldNotFoundException(name);
    }

    @StableAPI.Expose
    public static FieldNode findFieldFromMCP(ClassNode cn, String fieldName, boolean optional) {
        MappingType classMapping = ASMUtil.discoverClassMappingType(cn);
        if (classMapping == null) {
            throw new AsmClassNotFoundException("The class " + cn + " is not from Minecraft, or the mapping managerdoesn't have it, cannot use findFieldFromMCP! Use findFieldStandard instead!");
        }
        return ASMUtil.findFieldStandard(cn, MappingManager.classForName(NameType.Internal, classMapping, cn.name).getField(MappingType.MCP, fieldName).getName(classMapping), optional);
    }

    @StableAPI.Expose
    public static FieldNode findFieldFromUniversal(ClassNode cn, UniversalField field, boolean optional) {
        Object[] objectArray;
        if (CoreLoadingPlugin.isObfuscated()) {
            String[] stringArray = new String[2];
            stringArray[0] = field.getName(MappingType.SRG);
            objectArray = stringArray;
            stringArray[1] = field.getName(MappingType.Notch);
        } else {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = field.getName(MappingType.MCP);
        }
        Object[] possibilities = objectArray;
        for (FieldNode ret : cn.fields) {
            if (!ASMUtil.anyEquals(ret.name, (String[])possibilities)) continue;
            return ret;
        }
        if (optional) {
            return null;
        }
        throw new AsmFieldNotFoundException((String)(possibilities.length == 1 ? possibilities[0] : Arrays.toString(possibilities)));
    }

    @StableAPI.Expose
    public static MethodNode findMethodStandard(ClassNode cn, String name, String descriptor, boolean optional) {
        for (MethodNode ret : cn.methods) {
            if (!name.equals(ret.name) || !descriptor.equals(ret.desc)) continue;
            return ret;
        }
        if (optional) {
            return null;
        }
        throw new AsmMethodNotFoundException(name);
    }

    @StableAPI.Expose
    public static MethodNode findMethodFromMCP(ClassNode cn, String mcpName, String mcpDescriptor, boolean optional) {
        MappingType classMapping = ASMUtil.discoverClassMappingType(cn);
        if (classMapping == null) {
            throw new AsmClassNotFoundException("The class " + cn + " is not from Minecraft, or the mapping managerdoesn't have it, cannot use findMethodFromMCP! Use findFieldStandard instead!");
        }
        UniversalMethod method = MappingManager.classForName(NameType.Internal, classMapping, cn.name).getMethod(MappingType.MCP, mcpName, mcpDescriptor);
        return ASMUtil.findMethodStandard(cn, method.getName(classMapping), method.getDescriptor(classMapping), optional);
    }

    @StableAPI.Expose
    public static MethodNode findMethodFromUniversal(ClassNode cn, UniversalMethod method, boolean optional) {
        Object[] objectArray;
        String[] stringArray;
        if (CoreLoadingPlugin.isObfuscated()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = method.getName(MappingType.SRG);
            stringArray = stringArray2;
            stringArray2[1] = method.getName(MappingType.Notch);
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = method.getName(MappingType.MCP);
        }
        String[] possibleNames = stringArray;
        if (CoreLoadingPlugin.isObfuscated()) {
            String[] stringArray4 = new String[2];
            stringArray4[0] = method.getDescriptor(MappingType.SRG);
            objectArray = stringArray4;
            stringArray4[1] = method.getDescriptor(MappingType.Notch);
        } else {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = method.getDescriptor(MappingType.MCP);
        }
        Object[] possibleDescriptors = objectArray;
        for (MethodNode ret : cn.methods) {
            if (!ASMUtil.anyEquals(ret.name, possibleNames) || !ASMUtil.anyEquals(ret.desc, (String[])possibleDescriptors)) continue;
            return ret;
        }
        if (optional) {
            return null;
        }
        throw new AsmFieldNotFoundException((String)(possibleDescriptors.length == 1 ? possibleDescriptors[0] : Arrays.toString(possibleDescriptors)));
    }

    @StableAPI.Expose
    public static MappingType discoverClassMappingType(ClassNode cn) {
        if (CoreLoadingPlugin.isObfuscated()) {
            if (MappingManager.containsClass(NameType.Internal, MappingType.MCP, cn.name)) {
                return MappingType.MCP;
            }
        } else {
            if (MappingManager.containsClass(NameType.Internal, MappingType.SRG, cn.name)) {
                return MappingType.SRG;
            }
            if (MappingManager.containsClass(NameType.Internal, MappingType.Notch, cn.name)) {
                return MappingType.Notch;
            }
        }
        return null;
    }

    @StableAPI.Expose
    public static UniversalClass toUniversalClass(ClassNode cn) {
        if (CoreLoadingPlugin.isObfuscated()) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.MCP, cn.name);
            }
            catch (ClassNotFoundException e) {
                throw new AsmClassNotFoundException(cn.name);
            }
        }
        try {
            return MappingManager.classForName(NameType.Internal, MappingType.SRG, cn.name);
        }
        catch (ClassNotFoundException e) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.Notch, cn.name);
            }
            catch (ClassNotFoundException ex) {
                throw new AsmClassNotFoundException(cn.name);
            }
        }
    }

    @StableAPI.Expose
    public static ClassNode parseClass(byte[] bytes, int readerFlags) {
        ClassNode cn = new ClassNode(327680);
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)cn, readerFlags);
        return cn;
    }

    @StableAPI.Expose
    public static byte[] serializeClass(ClassNode cn, int writerFlags) {
        ClassWriter writer = new ClassWriter(writerFlags);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    @StableAPI.Expose
    public static boolean anyEquals(String str, String ... options) {
        for (String option : options) {
            if (!Objects.equals(str, option)) continue;
            return true;
        }
        return false;
    }
}

