/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.asm;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.asm.ASMUtil;
import com.falsepattern.lib.asm.IClassNodeTransformer;
import com.falsepattern.lib.internal.asm.CoreLoadingPlugin;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;

@StableAPI(since="0.10.0")
public interface SmartTransformer
extends IClassTransformer {
    @StableAPI.Expose
    public Logger logger();

    @StableAPI.Expose
    public List<IClassNodeTransformer> transformers();

    default public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ArrayList<IClassNodeTransformer> transformers = new ArrayList<IClassNodeTransformer>();
        ClassNode cn = ASMUtil.parseClass(bytes, 8);
        for (IClassNodeTransformer iClassNodeTransformer : this.transformers()) {
            if (!iClassNodeTransformer.shouldTransform(cn, transformedName, CoreLoadingPlugin.isObfuscated())) continue;
            transformers.add(iClassNodeTransformer);
        }
        if (transformers.isEmpty()) {
            return bytes;
        }
        transformers.sort(Comparator.comparingInt(IClassNodeTransformer::internalSortingOrder));
        Logger log = this.logger();
        for (IClassNodeTransformer transformer : transformers) {
            log.debug("Patching {} with {}...", new Object[]{transformedName, transformer.getName()});
            try {
                transformer.transform(cn, transformedName, CoreLoadingPlugin.isObfuscated());
            }
            catch (Error | RuntimeException t) {
                log.error("Error transforming {} with {}: {}", new Object[]{transformedName, transformer.getName(), t.getMessage()});
                throw t;
            }
            catch (Throwable t) {
                log.error("Error transforming {} with {}: {}", new Object[]{transformedName, transformer.getName(), t.getMessage()});
                throw new RuntimeException(t);
            }
        }
        byte[] byArray = ASMUtil.serializeClass(cn, 2);
        log.debug("Patched {} successfully.", new Object[]{transformedName});
        return byArray;
    }
}

