/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.compat;

import com.falsepattern.lib.DeprecationDetails;
import com.falsepattern.lib.StableAPI;
import java.util.Random;

@Deprecated
@DeprecationDetails(deprecatedSince="0.10.0")
@StableAPI(since="0.9.2")
public class MathHelper {
    private static final int[] multiplyDeBruijnBitPosition;
    private static final float[] SIN_TABLE;

    @StableAPI.Expose
    public static float sin(float a) {
        return SIN_TABLE[(int)(a * 10430.378f) & 0xFFFF];
    }

    @StableAPI.Expose
    public static float cos(float a) {
        return SIN_TABLE[(int)(a * 10430.378f + 16384.0f) & 0xFFFF];
    }

    @StableAPI.Expose
    public static float sqrt_float(float a) {
        return (float)Math.sqrt(a);
    }

    @StableAPI.Expose
    public static float sqrt_double(double a) {
        return (float)Math.sqrt(a);
    }

    @StableAPI.Expose
    public static int floor_float(float a) {
        int i = (int)a;
        return a < (float)i ? i - 1 : i;
    }

    @StableAPI.Expose
    public static int truncateDoubleToInt(double a) {
        return (int)(a + 1024.0) - 1024;
    }

    @StableAPI.Expose
    public static int floor_double(double a) {
        int i = (int)a;
        return a < (double)i ? i - 1 : i;
    }

    @StableAPI.Expose
    public static long floor_double_long(double a) {
        long i = (long)a;
        return a < (double)i ? i - 1L : i;
    }

    @StableAPI.Expose
    public static int absFloor(double a) {
        return (int)(a >= 0.0 ? a : -a + 1.0);
    }

    @StableAPI.Expose
    public static float abs(float a) {
        return a >= 0.0f ? a : -a;
    }

    @StableAPI.Expose
    public static int abs_int(int a) {
        return a >= 0 ? a : -a;
    }

    @StableAPI.Expose
    public static int ceiling_float_int(float a) {
        int i = (int)a;
        return a > (float)i ? i + 1 : i;
    }

    @StableAPI.Expose
    public static int ceiling_double_int(double a) {
        int i = (int)a;
        return a > (double)i ? i + 1 : i;
    }

    @StableAPI.Expose
    public static int clamp_int(int a, int min, int max) {
        return a < min ? min : Math.min(a, max);
    }

    @StableAPI.Expose
    public static float clamp_float(float a, float min, float max) {
        return a < min ? min : Math.min(a, max);
    }

    @StableAPI.Expose
    public static double clamp_double(double a, double min, double max) {
        return a < min ? min : Math.min(a, max);
    }

    @StableAPI.Expose
    public static double denormalizeClamp(double min, double max, double normalized) {
        return normalized < 0.0 ? min : (normalized > 1.0 ? max : min + (max - min) * normalized);
    }

    @StableAPI.Expose
    public static double abs_max(double a, double b) {
        if (a < 0.0) {
            a = -a;
        }
        if (b < 0.0) {
            b = -b;
        }
        return Math.max(a, b);
    }

    @StableAPI.Expose
    public static int bucketInt(int i, int bucketSize) {
        return i < 0 ? -((-i - 1) / bucketSize) - 1 : i / bucketSize;
    }

    @StableAPI.Expose
    public static boolean stringNullOrLengthZero(String str) {
        return str == null || str.length() == 0;
    }

    @StableAPI.Expose
    public static int getRandomIntegerInRange(Random rng, int min, int max) {
        return min >= max ? min : rng.nextInt(max - min + 1) + min;
    }

    @StableAPI.Expose
    public static float randomFloatClamp(Random rng, float min, float max) {
        return min >= max ? min : rng.nextFloat() * (max - min) + min;
    }

    @StableAPI.Expose
    public static double getRandomDoubleInRange(Random rng, double min, double max) {
        return min >= max ? min : rng.nextDouble() * (max - min) + min;
    }

    @StableAPI.Expose
    public static double average(long[] values) {
        long i = 0L;
        for (long l : values) {
            i += l;
        }
        return (double)i / (double)values.length;
    }

    @StableAPI.Expose
    public static float wrapAngleTo180_float(float angle) {
        if ((angle %= 360.0f) >= 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @StableAPI.Expose
    public static double wrapAngleTo180_double(double angle) {
        if ((angle %= 360.0) >= 180.0) {
            angle -= 360.0;
        }
        if (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    @StableAPI.Expose
    public static int parseIntWithDefault(String str, int def) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    @StableAPI.Expose
    public static int parseIntWithDefaultAndMax(String str, int def, int min) {
        int k;
        try {
            k = Integer.parseInt(str);
        }
        catch (Throwable throwable) {
            k = def;
        }
        if (k < min) {
            k = min;
        }
        return k;
    }

    @StableAPI.Expose
    public static double parseDoubleWithDefault(String str, double def) {
        double d1 = def;
        try {
            d1 = Double.parseDouble(str);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return d1;
    }

    @StableAPI.Expose
    public static double parseDoubleWithDefaultAndMin(String str, double def, double min) {
        double d2;
        try {
            d2 = Double.parseDouble(str);
        }
        catch (Throwable throwable) {
            d2 = def;
        }
        if (d2 < min) {
            d2 = min;
        }
        return d2;
    }

    @StableAPI.Expose
    public static int roundUpToPowerOfTwo(int a) {
        int j = a - 1;
        j |= j >> 1;
        j |= j >> 2;
        j |= j >> 4;
        j |= j >> 8;
        j |= j >> 16;
        return j + 1;
    }

    private static boolean isPowerOfTwo(int a) {
        return a != 0 && (a & a - 1) == 0;
    }

    private static int calculateLogBaseTwoDeBruijn(int a) {
        a = MathHelper.isPowerOfTwo(a) ? a : MathHelper.roundUpToPowerOfTwo(a);
        return multiplyDeBruijnBitPosition[(int)((long)a * 125613361L >> 27) & 0x1F];
    }

    @StableAPI.Expose
    public static int calculateLogBaseTwo(int a) {
        return MathHelper.calculateLogBaseTwoDeBruijn(a) - (MathHelper.isPowerOfTwo(a) ? 0 : 1);
    }

    @StableAPI.Expose
    public static int roundUp(int a, int b) {
        int k;
        if (b == 0) {
            return 0;
        }
        if (a < 0) {
            b *= -1;
        }
        return (k = a % b) == 0 ? a : a + b - k;
    }

    static {
        SIN_TABLE = new float[65536];
        for (int i = 0; i < 65536; ++i) {
            MathHelper.SIN_TABLE[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
        multiplyDeBruijnBitPosition = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    }
}

