/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.dependencies;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.dependencies.SemanticVersion;
import com.falsepattern.lib.dependencies.Version;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.NonNull;

@StableAPI(since="0.6.0")
public class ComplexVersion
extends Version {
    final Version[] versions;

    @StableAPI.Expose
    public ComplexVersion(@NonNull Version mainVersion, Version ... subVersions) {
        if (mainVersion == null) {
            throw new NullPointerException("mainVersion is marked non-null but is null");
        }
        this.versions = new Version[subVersions.length + 1];
        this.versions[0] = mainVersion;
        System.arraycopy(subVersions, 0, this.versions, 1, subVersions.length);
    }

    @Override
    public int compareTo(@NonNull Version o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        if (o instanceof ComplexVersion) {
            ComplexVersion other = (ComplexVersion)o;
            int count = Math.min(this.versions.length, other.versions.length);
            for (int i = 0; i < count; ++i) {
                int result = this.versions[i].compareTo(other.versions[i]);
                if (result == 0) continue;
                return result;
            }
            if (this.versions.length != other.versions.length) {
                return this.versions.length - other.versions.length;
            }
            return 0;
        }
        if (o instanceof SemanticVersion) {
            SemanticVersion other = (SemanticVersion)o;
            int result = other.compareTo(this.versions[0]);
            if (result != 0) {
                return result;
            }
            if (this.versions.length > 1) {
                return -1;
            }
            return 0;
        }
        throw new IllegalArgumentException("Could not compare version with class " + o.getClass().getName());
    }

    public String toString() {
        return Arrays.stream(this.versions).map(Object::toString).collect(Collectors.joining("-"));
    }
}

