/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.asm;

import com.falsepattern.lib.asm.IClassNodeTransformer;
import com.falsepattern.lib.internal.asm.FPTransformer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;

public class IMixinPluginTransformer
implements IClassNodeTransformer {
    private static final String IMIXINPLUGIN = "com.falsepattern.lib.mixin.IMixinPlugin";
    private static final String IMIXINPLUGIN_INTERNAL = "com.falsepattern.lib.mixin.IMixinPlugin".replace('.', '/');
    private static final String IMIXINCONFIGPLUGIN = "org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin";
    private static final String IMIXINCONFIGPLUGIN_INTERNAL = "org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin".replace('.', '/');
    private static final Map<Class<?>, String> primitiveDescriptors = new HashMap();
    private static String PREAPPLY_DESC = null;
    private static String POSTAPPLY_DESC = null;
    private static String CLASSNODE_REAL = null;

    @Override
    public String getName() {
        return "IMixinPluginTransformer";
    }

    @Override
    public boolean shouldTransform(ClassNode cn, String transformedName, boolean obfuscated) {
        return IMIXINPLUGIN.equals(transformedName) || IMIXINCONFIGPLUGIN.equals(transformedName) || cn.interfaces.stream().anyMatch(i -> IMIXINPLUGIN_INTERNAL.equals(i) || IMIXINCONFIGPLUGIN_INTERNAL.equals(i));
    }

    @Override
    public void transform(ClassNode cn, String transformedName, boolean obfuscated) {
        if (IMIXINCONFIGPLUGIN.equals(transformedName)) {
            IMixinPluginTransformer.extractMixinConfigPluginData(cn);
        } else {
            IMixinPluginTransformer.transformPlugin(cn, transformedName);
        }
    }

    private static void extractMixinConfigPluginData(ClassNode cn) {
        block8: for (MethodNode method : cn.methods) {
            switch (method.name) {
                case "preApply": {
                    PREAPPLY_DESC = method.desc;
                    break;
                }
                case "postApply": {
                    POSTAPPLY_DESC = method.desc;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (CLASSNODE_REAL == null) continue;
            for (LocalVariableNode local : method.localVariables) {
                if (!local.desc.contains("ClassNode;")) continue;
                local.desc = local.desc.replaceAll("L[a-zA-Z/$]+[a-zA-Z$]+/ClassNode;", CLASSNODE_REAL);
            }
        }
    }

    private static void transformPlugin(ClassNode cn, String transformedName) {
        FPTransformer.LOG.info("Transforming " + transformedName + " to fit current mixin environment.");
        if (PREAPPLY_DESC == null) {
            PREAPPLY_DESC = IMixinPluginTransformer.extractMethodWithReflection("preApply");
        }
        if (POSTAPPLY_DESC == null) {
            POSTAPPLY_DESC = IMixinPluginTransformer.extractMethodWithReflection("postApply");
        }
        for (MethodNode method : cn.methods) {
            switch (method.name) {
                case "preApply": {
                    method.desc = PREAPPLY_DESC;
                    break;
                }
                case "postApply": {
                    method.desc = POSTAPPLY_DESC;
                }
            }
        }
    }

    private static String extractMethodWithReflection(String m) {
        for (Method method : IMixinConfigPlugin.class.getDeclaredMethods()) {
            if (!method.getName().equals(m)) continue;
            StringBuilder b = new StringBuilder("(");
            for (Class<?> param : method.getParameterTypes()) {
                if (param.getName().contains("ClassNode")) {
                    CLASSNODE_REAL = "L" + param.getName().replace('.', '/') + ";";
                }
                b.append(IMixinPluginTransformer.classToRaw(param));
            }
            b.append(")").append(IMixinPluginTransformer.classToRaw(method.getReturnType()));
            return b.toString();
        }
        throw new RuntimeException("Could not extract " + m + " from IMixinConfigPlugin!");
    }

    private static String classToRaw(Class<?> clazz) {
        if (primitiveDescriptors.containsKey(clazz)) {
            return primitiveDescriptors.get(clazz);
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    static {
        primitiveDescriptors.put(Void.TYPE, "V");
        primitiveDescriptors.put(Boolean.TYPE, "Z");
        primitiveDescriptors.put(Byte.TYPE, "B");
        primitiveDescriptors.put(Short.TYPE, "S");
        primitiveDescriptors.put(Integer.TYPE, "I");
        primitiveDescriptors.put(Long.TYPE, "J");
        primitiveDescriptors.put(Float.TYPE, "F");
        primitiveDescriptors.put(Double.TYPE, "D");
        primitiveDescriptors.put(Character.TYPE, "C");
    }
}

