/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.event;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigSyncEvent;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.config.LibraryConfig;
import com.falsepattern.lib.text.FormattedText;
import com.falsepattern.lib.toasts.GuiToast;
import com.falsepattern.lib.toasts.SimpleToast;
import com.falsepattern.lib.toasts.icon.ToastBG;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandlerPre {
    private static final ClientEventHandlerPre INSTANCE = new ClientEventHandlerPre();

    public static void registerBus() {
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onValidationErrorToast(ConfigValidationFailureEvent e) {
        if (LibraryConfig.CONFIG_ERROR_LOUDNESS == LibraryConfig.ValidationLogging.LogAndToast) {
            e.toast();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onConfigSyncFinished(ConfigSyncEvent.End e) {
        Config cfg = e.configClass.getAnnotation(Config.class);
        if (e.successful) {
            GuiToast.add(new SimpleToast(ToastBG.TOAST_DARK, null, (IChatComponent)FormattedText.parse(EnumChatFormatting.GREEN + "Synced config").toChatText().get(0), (IChatComponent)FormattedText.parse(cfg.modid() + ":" + cfg.category()).toChatText().get(0), false, 5000L));
        } else {
            GuiToast.add(new SimpleToast(ToastBG.TOAST_DARK, null, (IChatComponent)FormattedText.parse(EnumChatFormatting.RED + "Failed to sync config").toChatText().get(0), (IChatComponent)FormattedText.parse(cfg.modid() + ":" + cfg.category()).toChatText().get(0), false, 5000L));
        }
    }

    private ClientEventHandlerPre() {
    }
}

