/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class AConfigField<T> {
    public final boolean noSync;
    protected final Field field;
    protected final Configuration configuration;
    protected final String category;
    protected final String name;
    protected final String langKey;
    protected final Property.Type type;
    protected final Property property;
    protected final String comment;
    private boolean uninitialized;

    protected AConfigField(Field field, Configuration configuration, String category, Property.Type type) {
        this(field, configuration, category, type, false);
    }

    protected AConfigField(Field field, Configuration configuration, String category, Property.Type type, boolean isList) {
        this.field = field;
        this.configuration = configuration;
        this.category = category;
        this.comment = Optional.ofNullable(field.getAnnotation(Config.Comment.class)).map(Config.Comment::value).map(lines -> String.join((CharSequence)"\n", lines)).orElse("");
        this.name = Optional.ofNullable(field.getAnnotation(Config.Name.class)).map(Config.Name::value).orElse(field.getName());
        this.langKey = Optional.ofNullable(field.getAnnotation(Config.LangKey.class)).map(Config.LangKey::value).orElse(this.name);
        this.type = type;
        ConfigCategory cat = configuration.getCategory(category);
        this.uninitialized = !cat.containsKey(this.name);
        this.property = isList ? configuration.get(category, this.name, new String[0], this.comment, type) : configuration.get(category, this.name, "", this.comment, type);
        this.property.setLanguageKey(this.langKey);
        this.noSync = field.isAnnotationPresent(Config.NoSync.class);
    }

    protected abstract T getField();

    protected abstract void putField(T var1);

    protected abstract T getConfig();

    protected abstract void putConfig(T var1);

    protected abstract T getDefault();

    public void save() {
        if (!this.validateField()) {
            this.setToDefault();
        } else {
            this.putConfig(this.getField());
        }
    }

    public void load() {
        this.putField(this.getConfig());
        if (!this.validateField()) {
            this.setToDefault();
        }
    }

    public void setToDefault() {
        this.putField(this.getDefault());
        this.putConfig(this.getDefault());
    }

    public void init() {
        if (this.uninitialized) {
            this.uninitialized = false;
            this.putField(this.getDefault());
            this.putConfig(this.getDefault());
        }
    }

    public Property getProperty() {
        return this.property;
    }

    public abstract boolean validateField();

    public abstract void transmit(DataOutput var1) throws IOException;

    public abstract void receive(DataInput var1) throws IOException;

    public Field getJavaField() {
        return this.field;
    }
}

