/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.impl.config.fields.AListConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class DoubleListConfigField
extends AListConfigField<double[]> {
    private final double min;
    private final double max;
    private final double[] defaultValue;

    public DoubleListConfigField(Field field, Configuration configuration, String category) throws ConfigException {
        super(field, configuration, category, Property.Type.INTEGER);
        Optional<Config.RangeDouble> range = Optional.ofNullable(field.getAnnotation(Config.RangeDouble.class));
        this.min = range.map(Config.RangeDouble::min).orElse(-1.7976931348623157E308);
        this.max = range.map(Config.RangeDouble::max).orElse((Double)Double.MAX_VALUE);
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultDoubleList.class)).map(Config.DefaultDoubleList::value).orElseGet(() -> {
            Share.LOG.warn("The field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " has no DefaultDoubleList annotation!\nThis will be a crash in FalsePatternLib 0.11, update your code!");
            try {
                return (double[])field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        this.property.setDefaultValues(this.defaultValue);
        this.property.setMinValue(this.min);
        this.property.setMaxValue(this.max);
        if (!this.property.isDoubleList()) {
            this.setToDefault();
        }
        this.property.comment = this.property.comment + "\n[range: " + this.min + " ~ " + this.max + ", default: " + Arrays.toString(this.defaultValue) + "]";
    }

    @Override
    protected int length(double[] arr) {
        return arr.length;
    }

    @Override
    protected double[] arrayCopy(double[] arr) {
        return Arrays.copyOf(arr, arr.length);
    }

    @Override
    protected void transmitElements(DataOutput output, double[] arr) throws IOException {
        for (double i : arr) {
            output.writeDouble(i);
        }
    }

    @Override
    protected void receiveElements(DataInput input, double[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = input.readInt();
        }
    }

    @Override
    protected double[] createArray(int length) {
        return new double[length];
    }

    @Override
    public boolean validateField() {
        if (!super.validateField()) {
            return false;
        }
        double[] doubles = (double[])this.getField();
        boolean valid = true;
        for (int j = 0; j < doubles.length; ++j) {
            double d = doubles[j];
            if (!(d < this.min) && !(d > this.max)) continue;
            ConfigValidationFailureEvent.postNumericRangeOutOfBounds(this.field, j, Double.toString(d), Double.toString(this.min), Double.toString(this.max));
            valid = false;
        }
        return valid;
    }

    @Override
    protected double[] getConfig() {
        return this.property.getDoubleList();
    }

    @Override
    protected void putConfig(double[] value) {
        this.property.set(value);
    }

    @Override
    protected double[] getDefault() {
        return Arrays.copyOf(this.defaultValue, this.defaultValue.length);
    }
}

