/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import com.falsepattern.lib.util.MathUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@Deprecated
public class FloatConfigField
extends AConfigField<Float> {
    private final boolean primitive;
    private final float defaultValue;
    private final boolean hasMinMax;
    private final float min;
    private final float max;

    public FloatConfigField(Field field, Configuration configuration, String category) {
        super(field, configuration, category, Property.Type.STRING);
        Share.LOG.warn("Warning: float configuration properties are DEPRECATED! Use doubles instead!\nField name: " + field.getName() + ", location: " + field.getDeclaringClass().getName());
        this.primitive = field.getType().isPrimitive();
        Optional<Config.RangeFloat> range = Optional.ofNullable(field.getAnnotation(Config.RangeFloat.class));
        this.hasMinMax = range.isPresent();
        this.min = this.hasMinMax ? range.map(Config.RangeFloat::min).orElse(Float.valueOf(-3.4028235E38f)).floatValue() : 0.0f;
        this.max = this.hasMinMax ? range.map(Config.RangeFloat::max).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue() : 0.0f;
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultFloat.class)).map(Config.DefaultFloat::value).orElseGet(() -> {
            try {
                return Float.valueOf(field.getType().isPrimitive() ? field.getFloat(null) : ((Float)field.get(null)).floatValue());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).floatValue();
        this.property.setDefaultValue((double)this.defaultValue);
        this.property.setMinValue((double)this.min);
        this.property.setMaxValue((double)this.max);
        this.property.comment = this.property.comment + "\n[range: " + this.min + " ~ " + this.max + ", default: " + this.defaultValue + "]";
    }

    @Override
    protected Float getField() {
        return Float.valueOf(this.primitive ? this.field.getFloat(null) : (float)((Integer)this.field.get(null)).intValue());
    }

    @Override
    protected void putField(Float value) {
        if (this.primitive) {
            this.field.setFloat(null, value.floatValue());
        } else {
            this.field.set(null, value);
        }
    }

    @Override
    protected Float getConfig() {
        try {
            return Float.valueOf(MathUtil.clamp(Float.parseFloat(this.property.getString()), this.min, this.max));
        }
        catch (NumberFormatException e) {
            return Float.valueOf(this.defaultValue);
        }
    }

    @Override
    protected void putConfig(Float value) {
        this.property.set(Float.toString(value.floatValue()));
    }

    @Override
    protected Float getDefault() {
        return Float.valueOf(this.defaultValue);
    }

    @Override
    public boolean validateField() {
        if (!this.primitive && this.field.get(null) == null) {
            ConfigValidationFailureEvent.fieldIsNull(this.field, -1);
            return false;
        }
        if (this.hasMinMax) {
            float value = this.getField().floatValue();
            if (value >= this.min && value <= this.max) {
                return true;
            }
            ConfigValidationFailureEvent.postNumericRangeOutOfBounds(this.field, -1, Float.toString(value), Float.toString(this.min), Float.toString(this.max));
            return false;
        }
        return true;
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        output.writeFloat(this.getField().floatValue());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(Float.valueOf(input.readFloat()));
    }
}

