/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class IntConfigField
extends AConfigField<Integer> {
    private final boolean primitive;
    private final int defaultValue;
    private final int min;
    private final int max;

    public IntConfigField(Field field, Configuration configuration, String category) {
        super(field, configuration, category, Property.Type.INTEGER);
        this.primitive = field.getType().isPrimitive();
        Optional<Config.RangeInt> range = Optional.ofNullable(field.getAnnotation(Config.RangeInt.class));
        this.min = range.map(Config.RangeInt::min).orElse(Integer.MIN_VALUE);
        this.max = range.map(Config.RangeInt::max).orElse(Integer.MAX_VALUE);
        this.defaultValue = Optional.ofNullable(field.getAnnotation(Config.DefaultInt.class)).map(Config.DefaultInt::value).orElseGet(() -> {
            Share.LOG.warn("The field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " has no DefaultInt annotation!\nThis will be a crash in FalsePatternLib 0.11, update your code!");
            try {
                return field.getType().isPrimitive() ? field.getInt(null) : ((Integer)field.get(null)).intValue();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        this.property.setDefaultValue(this.defaultValue);
        this.property.setMinValue(this.min);
        this.property.setMaxValue(this.max);
        if (!this.property.isIntValue()) {
            this.setToDefault();
        }
        this.property.comment = this.property.comment + "\n[range: " + this.min + " ~ " + this.max + ", default: " + this.defaultValue + "]";
    }

    @Override
    protected Integer getField() {
        return this.primitive ? this.field.getInt(null) : ((Integer)this.field.get(null)).intValue();
    }

    @Override
    protected void putField(Integer value) {
        if (this.primitive) {
            this.field.setInt(null, value);
        } else {
            this.field.set(null, value);
        }
    }

    @Override
    protected Integer getConfig() {
        return this.property.getInt();
    }

    @Override
    protected void putConfig(Integer value) {
        this.property.set(value.intValue());
    }

    @Override
    protected Integer getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean validateField() {
        if (!this.primitive && this.field.get(null) == null) {
            ConfigValidationFailureEvent.fieldIsNull(this.field, -1);
            return false;
        }
        int value = this.getField();
        if (value >= this.min && value <= this.max) {
            return true;
        }
        ConfigValidationFailureEvent.postNumericRangeOutOfBounds(this.field, -1, Integer.toString(value), Integer.toString(this.min), Integer.toString(this.max));
        return false;
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        output.writeInt(this.getField());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(input.readInt());
    }
}

