/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.dependencies;

import com.falsepattern.lib.dependencies.DependencyLoader;
import com.falsepattern.lib.dependencies.Library;
import com.falsepattern.lib.dependencies.Version;
import com.falsepattern.lib.internal.Internet;
import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.config.LibraryConfig;
import com.falsepattern.lib.util.FileUtil;
import io.netty.util.internal.ConcurrentSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DependencyLoaderImpl {
    private static final String[] CHECKSUM_TYPES = new String[]{"sha512", "sha256", "sha1", "md5"};
    private static final Map<String, Version> loadedLibraries = new ConcurrentHashMap<String, Version>();
    private static final Map<String, String> loadedLibraryMods = new ConcurrentHashMap<String, String>();
    private static final Set<String> mavenRepositories = new ConcurrentSet();
    private static final Logger log = LogManager.getLogger((String)"FalsePatternLib Library Downloader");
    private static final AtomicLong counter = new AtomicLong(0L);
    private static final ExecutorService executor = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("Dependency Download Thread " + counter.incrementAndGet());
        return thread;
    });

    public static void addMavenRepo(String url) {
        mavenRepositories.add(url);
    }

    @Deprecated
    public static void loadLibrary(@NonNull String loadingModId, @NonNull String groupId, @NonNull String artifactId, @NonNull Version minVersion, Version maxVersion, @NonNull Version preferredVersion, String regularSuffix, String devSuffix) {
        if (loadingModId == null) {
            throw new NullPointerException("loadingModId is marked non-null but is null");
        }
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (artifactId == null) {
            throw new NullPointerException("artifactId is marked non-null but is null");
        }
        if (minVersion == null) {
            throw new NullPointerException("minVersion is marked non-null but is null");
        }
        if (preferredVersion == null) {
            throw new NullPointerException("preferredVersion is marked non-null but is null");
        }
        new DependencyLoadTask(loadingModId, groupId, artifactId, minVersion, maxVersion, preferredVersion, regularSuffix, devSuffix).load();
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static String digest(String algo, byte[] data) {
        return DependencyLoaderImpl.bytesToHex(MessageDigest.getInstance(algo).digest(data));
    }

    private static String hash(String algo, File file) {
        byte[] data = Files.readAllBytes(file.toPath());
        switch (algo) {
            case "md5": {
                algo = "MD5";
                break;
            }
            case "sha1": {
                algo = "SHA-1";
                break;
            }
            case "sha256": {
                algo = "SHA-256";
                break;
            }
            case "sha512": {
                algo = "SHA-512";
            }
        }
        return DependencyLoaderImpl.digest(algo, data);
    }

    private static void checkedDelete(File file) {
        if (!file.delete()) {
            log.fatal("Failed to delete file {}", new Object[]{file});
            throw new RuntimeException("Failed to delete file " + file);
        }
    }

    private static synchronized void addToClasspath(File file) {
        try {
            LaunchClassLoader cl = (LaunchClassLoader)DependencyLoader.class.getClassLoader();
            cl.addURL(file.toURI().toURL());
            log.debug("Injected file {} into classpath!", new Object[]{file.getPath()});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add library to classpath: " + file.getAbsolutePath(), e);
        }
    }

    private static void download(InputStream is, File target) {
        if (target.exists()) {
            return;
        }
        Internet.transferAndClose(is, new BufferedOutputStream(Files.newOutputStream(target.toPath(), new OpenOption[0])));
    }

    public static void loadLibraries(Library ... libraries) {
        DependencyLoaderImpl.loadLibrariesAsync(libraries).join();
    }

    public static CompletableFuture<Void> loadLibrariesAsync(Library ... libraries) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Library library : libraries) {
            DependencyLoadTask task = new DependencyLoadTask(library.loadingModId, library.groupId, library.artifactId, library.minVersion, library.maxVersion, library.preferredVersion, library.regularSuffix, library.devSuffix);
            futures.add(CompletableFuture.runAsync(() -> task.load(), executor));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private static class DependencyLoadTask {
        @NonNull
        private final String loadingModId;
        @NonNull
        private final String groupId;
        @NonNull
        private final String artifactId;
        @NonNull
        private final Version minVersion;
        private final Version maxVersion;
        @NonNull
        private final Version preferredVersion;
        private final String regularSuffix;
        private final String devSuffix;
        private String suffix;
        private String artifactLogName;
        private String artifact;
        private String mavenJarName;
        private String jarName;
        private File libDir;
        private File file;

        private void load() {
            this.setupLibraryNames();
            if (loadedLibraries.containsKey(this.artifact)) {
                this.alreadyLoaded();
                return;
            }
            this.setupPaths();
            if (this.tryLoadingExistingFile()) {
                return;
            }
            this.validateDownloadsAllowed();
            for (String repo : mavenRepositories) {
                if (!this.tryDownloadFromMaven(repo)) continue;
                return;
            }
            this.crashCouldNotDownload();
        }

        private void crashCouldNotDownload() {
            String errorMessage = "Failed to download library " + this.groupId + ":" + this.artifactId + ":" + this.preferredVersion + (this.suffix != null ? ":" + this.suffix : "") + " from any repository! Requested by mod: " + this.loadingModId;
            log.fatal(errorMessage);
            throw new IllegalStateException(errorMessage);
        }

        private void setupLibraryNames() {
            this.suffix = Share.DEV_ENV ? this.devSuffix : this.regularSuffix;
            this.artifactLogName = String.format("%s:%s:%s%s", this.groupId, this.artifactId, this.preferredVersion, this.suffix != null ? "-" + this.suffix : "");
            log.info("Adding library {}, requested by mod {}", new Object[]{this.artifactLogName, this.loadingModId});
            this.artifact = this.groupId + ":" + this.artifactId + ":" + this.suffix;
        }

        private void alreadyLoaded() {
            Version currentVer = (Version)loadedLibraries.get(this.artifact);
            if (currentVer.equals(this.preferredVersion)) {
                return;
            }
            String rangeString = "(minimum: " + this.minVersion + (this.maxVersion == null ? "" : ", maximum: " + this.maxVersion) + ")";
            if (this.minVersion.compareTo(currentVer) > 0 || this.maxVersion != null && this.maxVersion.compareTo(currentVer) < 0) {
                int i;
                for (i = 0; i < 16; ++i) {
                    log.fatal("ALERT VVVVVVVVVVVV ALERT");
                }
                log.fatal("Library {}:{}{} already loaded with version {}, but a version in the range {} was requested! Thing may go horribly wrong! Requested by mod: {}, previously loaded by mod: {}", new Object[]{this.groupId, this.artifactId, this.suffix != null ? ":" + this.suffix : "", currentVer, rangeString, this.loadingModId, loadedLibraryMods.get(this.artifact)});
                for (i = 0; i < 16; ++i) {
                    log.fatal("ALERT ^^^^^^^^^^^^ ALERT");
                }
            } else {
                log.info("Attempted loading of library {}:{}{} with preferred version {}, but version {} was already loaded, which matched the range {}. This is not an error. Requested by mod: {}, previously loaded by mod: {}", new Object[]{this.groupId, this.artifactId, this.suffix != null ? ":" + this.suffix : "", this.preferredVersion, currentVer, rangeString, this.loadingModId, loadedLibraryMods.get(this.artifact)});
            }
        }

        private void setupPaths() {
            String homeDir = System.getProperty("minecraft.sharedDataDir");
            if (homeDir == null && (homeDir = System.getenv("MINECRAFT_SHARED_DATA_DIR")) == null) {
                homeDir = FileUtil.getMinecraftHome().getAbsolutePath();
            }
            File modsDir = Paths.get(homeDir, "mods").toFile();
            File oldLibDir = new File(modsDir, "falsepattern");
            this.libDir = new File(homeDir, "falsepattern");
            this.mavenJarName = String.format("%s-%s%s.jar", this.artifactId, this.preferredVersion, this.suffix != null ? "-" + this.suffix : "");
            this.jarName = this.groupId + "-" + this.mavenJarName;
            if (!this.libDir.exists() && !this.libDir.mkdirs()) {
                log.fatal("Failed to create directory {}", new Object[]{this.libDir});
                throw new RuntimeException("Failed to create directory " + this.libDir);
            }
            if (oldLibDir.exists()) {
                log.info("Migrating old library folder. From: " + oldLibDir.getAbsolutePath() + ", To: " + this.libDir.getAbsolutePath());
                File[] oldFiles = oldLibDir.listFiles();
                if (oldFiles != null) {
                    for (File file : oldFiles) {
                        try {
                            Files.move(file.toPath(), this.libDir.toPath().resolve(oldLibDir.toPath().relativize(file.toPath())), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            log.warn("Failed to move file " + file.getName() + " to new dir! Deleting instead.");
                            try {
                                Files.deleteIfExists(file.toPath());
                            }
                            catch (IOException ex) {
                                log.warn("Failed to delete file " + file.getPath() + "!");
                                file.deleteOnExit();
                            }
                        }
                    }
                }
                try {
                    Files.deleteIfExists(oldLibDir.toPath());
                }
                catch (IOException e) {
                    log.warn("Failed to delete old library directory!");
                    oldLibDir.deleteOnExit();
                }
            }
            this.file = new File(this.libDir, this.jarName);
        }

        private boolean tryLoadingExistingFile() {
            if (!this.file.exists()) {
                return false;
            }
            try {
                ChecksumStatus status = this.validateChecksum(this.file);
                if (status == ChecksumStatus.FAILED) {
                    return false;
                }
                if (status == ChecksumStatus.MISSING) {
                    log.debug("Library {} is missing checksum data! Either it was manually deleted, or the source repo didn't have it in the first place", new Object[]{this.artifactLogName});
                }
            }
            catch (IOException e) {
                log.error("Failed to execute validation check for " + this.artifactLogName, (Throwable)e);
                DependencyLoaderImpl.checkedDelete(this.file);
                return false;
            }
            try {
                DependencyLoaderImpl.addToClasspath(this.file);
                loadedLibraries.put(this.artifact, this.preferredVersion);
                log.debug("Library {} successfully loaded from disk!", new Object[]{this.artifactLogName});
                return true;
            }
            catch (RuntimeException e) {
                log.warn("Failed to load library {} from file! Re-downloading...", new Object[]{this.artifactLogName});
                DependencyLoaderImpl.checkedDelete(this.file);
                return false;
            }
        }

        private void validateDownloadsAllowed() {
            if (!LibraryConfig.ENABLE_LIBRARY_DOWNLOADS) {
                String errorMessage = "Failed to load library " + this.groupId + ":" + this.artifactId + ":" + this.preferredVersion + (this.suffix != null ? ":" + this.suffix : "") + ": " + "FalsePatternLib" + " library downloading has been disabled in the config, and the library is not present on disk! Requested by mod: " + this.loadingModId;
                log.fatal(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
        }

        private boolean tryDownloadFromMaven(String repo) {
            try {
                if (!repo.endsWith("/")) {
                    repo = repo + "/";
                }
                String url = String.format("%s%s/%s/%s/%s", repo, this.groupId.replace('.', '/'), this.artifactId, this.preferredVersion, this.mavenJarName);
                String finalRepo = repo;
                int retryCount = 0;
                block7: while (++retryCount <= 3) {
                    AtomicBoolean success = new AtomicBoolean(false);
                    Internet.connect(new URL(url), ex -> log.debug("Artifact {} could not be downloaded from repo {}: {}", new Object[]{this.artifactLogName, finalRepo, ex.getMessage()}), input -> {
                        log.debug("Downloading {} from {}", new Object[]{this.artifactLogName, finalRepo});
                        DependencyLoaderImpl.download(input, this.file);
                        log.debug("Downloaded {} from {}", new Object[]{this.artifactLogName, finalRepo});
                        success.set(true);
                    });
                    if (!success.get()) continue;
                    log.debug("Validating checksum for {}", new Object[]{this.artifactLogName});
                    ChecksumStatus hadChecksum = this.validateChecksum(url);
                    switch (hadChecksum) {
                        case FAILED: {
                            continue block7;
                        }
                        case OK: {
                            break;
                        }
                        case MISSING: {
                            log.warn("The library {} had no checksum available on the repository.\nThere's a chance it might have gotten corrupted during download,\nbut we're loading it anyways.", new Object[]{this.artifactLogName});
                        }
                    }
                    loadedLibraries.put(this.artifact, this.preferredVersion);
                    loadedLibraryMods.put(this.artifact, this.loadingModId);
                    DependencyLoaderImpl.addToClasspath(this.file);
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        private ChecksumStatus validateChecksum(String url) throws IOException {
            for (String checksumType : CHECKSUM_TYPES) {
                String checksumURL = url + "." + checksumType;
                File checksumFile = new File(this.libDir, this.jarName + "." + checksumType);
                log.debug("Attempting to get {} checksum...", new Object[]{checksumType});
                AtomicBoolean success = new AtomicBoolean(false);
                Internet.connect(new URL(checksumURL), ex -> log.debug("Could not get {} checksum for {}: {}", new Object[]{checksumType, this.artifactLogName, ex.getMessage()}), input -> {
                    log.debug("Downloading {} checksum for {}", new Object[]{checksumType, this.artifactLogName});
                    DependencyLoaderImpl.download(input, checksumFile);
                    log.debug("Downloaded {} checksum for {}", new Object[]{checksumType, this.artifactLogName});
                    success.set(true);
                });
                if (!success.get()) continue;
                return this.getChecksumStatus(this.file, checksumType, checksumFile);
            }
            return ChecksumStatus.MISSING;
        }

        private ChecksumStatus validateChecksum(File file) throws IOException {
            for (String checksumType : CHECKSUM_TYPES) {
                File checksumFile = new File(this.libDir, this.jarName + "." + checksumType);
                log.debug("Attempting to read {} checksum from file...", new Object[]{checksumType});
                if (!checksumFile.exists()) continue;
                return this.getChecksumStatus(file, checksumType, checksumFile);
            }
            return ChecksumStatus.MISSING;
        }

        private ChecksumStatus getChecksumStatus(File file, String checksumType, File checksumFile) throws IOException {
            String referenceHash;
            String fileHash = DependencyLoaderImpl.hash(checksumType, file);
            if (!fileHash.equals(referenceHash = new String(Files.readAllBytes(checksumFile.toPath())))) {
                log.error("Failed {} checksum validation for {}.", new Object[]{checksumType, this.artifactLogName});
                DependencyLoaderImpl.checkedDelete(file);
                DependencyLoaderImpl.checkedDelete(checksumFile);
                return ChecksumStatus.FAILED;
            }
            log.debug("Successfully validated {} checksum for {}.", new Object[]{checksumType, this.artifactLogName});
            return ChecksumStatus.OK;
        }

        public DependencyLoadTask(@NonNull String loadingModId, @NonNull String groupId, @NonNull String artifactId, @NonNull Version minVersion, Version maxVersion, @NonNull Version preferredVersion, String regularSuffix, String devSuffix) {
            if (loadingModId == null) {
                throw new NullPointerException("loadingModId is marked non-null but is null");
            }
            if (groupId == null) {
                throw new NullPointerException("groupId is marked non-null but is null");
            }
            if (artifactId == null) {
                throw new NullPointerException("artifactId is marked non-null but is null");
            }
            if (minVersion == null) {
                throw new NullPointerException("minVersion is marked non-null but is null");
            }
            if (preferredVersion == null) {
                throw new NullPointerException("preferredVersion is marked non-null but is null");
            }
            this.loadingModId = loadingModId;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
            this.preferredVersion = preferredVersion;
            this.regularSuffix = regularSuffix;
            this.devSuffix = devSuffix;
        }

        private static enum ChecksumStatus {
            OK,
            FAILED,
            MISSING;

        }
    }
}

