/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.mixin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import sun.misc.URLClassPath;

public final class UCPImpl {
    private static final URLClassPath ucp;
    private static final boolean GRIMOIRE;

    public static void addJar(File pathToJar) throws Exception {
        if (!GRIMOIRE) {
            ucp.addURL(pathToJar.toURI().toURL());
        }
    }

    static {
        String[] knownGrimoireClassNames;
        boolean grimoire = false;
        for (String className : knownGrimoireClassNames = new String[]{"io.github.crucible.grimoire.Grimoire", "io.github.crucible.grimoire.common.GrimoireCore"}) {
            try {
                if (Launch.classLoader.getClassBytes(className) == null) continue;
                grimoire = true;
                break;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!(GRIMOIRE = grimoire)) {
            try {
                Field ucpField = LaunchClassLoader.class.getSuperclass().getDeclaredField("ucp");
                ucpField.setAccessible(true);
                ucp = (URLClassPath)ucpField.get(Launch.classLoader);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            ucp = null;
            System.err.println("Grimoire detected, disabling jar loading utility");
        }
    }
}

