/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.updates;

import com.falsepattern.json.node.JsonNode;
import com.falsepattern.lib.dependencies.DependencyLoader;
import com.falsepattern.lib.dependencies.Library;
import com.falsepattern.lib.dependencies.SemanticVersion;
import com.falsepattern.lib.internal.Internet;
import com.falsepattern.lib.internal.config.LibraryConfig;
import com.falsepattern.lib.text.FormattedText;
import com.falsepattern.lib.updates.ModUpdateInfo;
import com.falsepattern.lib.updates.UpdateCheckException;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.resources.I18n;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public final class UpdateCheckerImpl {
    private static final AtomicBoolean jsonLibraryLoaded = new AtomicBoolean(false);

    public static List<IChatComponent> updateListToChatMessages(String initiator, List<ModUpdateInfo> updates) {
        if (updates == null || updates.size() == 0) {
            return null;
        }
        ArrayList<ChatComponentText> updateText = new ArrayList<ChatComponentText>(FormattedText.parse(I18n.func_135052_a((String)"falsepatternlib.chat.updatesavailable", (Object[])new Object[]{initiator})).toChatText());
        Map mods = Loader.instance().getIndexedModList();
        for (ModUpdateInfo update : updates) {
            ModContainer mod = (ModContainer)mods.get(update.modID);
            updateText.addAll(FormattedText.parse(I18n.func_135052_a((String)"falsepatternlib.chat.modname", (Object[])new Object[]{mod.getName()})).toChatText());
            updateText.addAll(FormattedText.parse(I18n.func_135052_a((String)"falsepatternlib.chat.currentversion", (Object[])new Object[]{update.currentVersion})).toChatText());
            updateText.addAll(FormattedText.parse(I18n.func_135052_a((String)"falsepatternlib.chat.latestversion", (Object[])new Object[]{update.latestVersion})).toChatText());
            if (update.updateURL.isEmpty()) continue;
            List<ChatComponentText> pre = FormattedText.parse(I18n.func_135052_a((String)"falsepatternlib.chat.updateurlpre", (Object[])new Object[0])).toChatText();
            List<ChatComponentText> link = FormattedText.parse(I18n.func_135052_a((String)"falsepatternlib.chat.updateurl", (Object[])new Object[0])).toChatText();
            List<ChatComponentText> post = FormattedText.parse(I18n.func_135052_a((String)"falsepatternlib.chat.updateurlpost", (Object[])new Object[0])).toChatText();
            pre.get(pre.size() - 1).func_150257_a((IChatComponent)link.get(0));
            link.get(link.size() - 1).func_150257_a((IChatComponent)post.get(0));
            for (ChatComponentText l : link) {
                l.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, update.updateURL));
            }
            link.remove(0);
            post.remove(0);
            updateText.addAll(pre);
            updateText.addAll(link);
            updateText.addAll(post);
        }
        return updateText;
    }

    public static CompletableFuture<List<ModUpdateInfo>> fetchUpdatesAsync(String url) {
        return CompletableFuture.supplyAsync(() -> {
            JsonNode parsed;
            URL URL2;
            if (!LibraryConfig.ENABLE_UPDATE_CHECKER) {
                throw new CompletionException(new UpdateCheckException("Update checker is disabled in config!"));
            }
            try {
                URL2 = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new CompletionException(new UpdateCheckException("Invalid URL: " + url, e));
            }
            if (!jsonLibraryLoaded.get()) {
                try {
                    DependencyLoader.addMavenRepo("https://mvn.falsepattern.com/releases/");
                    DependencyLoader.loadLibraries(Library.builder().loadingModId("falsepatternlib").groupId("com.falsepattern").artifactId("json").minVersion(new SemanticVersion(0, 4, 0)).maxVersion(new SemanticVersion(0, Integer.MAX_VALUE, Integer.MAX_VALUE)).preferredVersion(new SemanticVersion(0, 4, 1)).build());
                }
                catch (Exception e) {
                    throw new CompletionException(new UpdateCheckException("Failed to load json library for update checker!", e));
                }
                jsonLibraryLoaded.set(true);
            }
            ArrayList<ModUpdateInfo> result = new ArrayList<ModUpdateInfo>();
            try {
                parsed = JsonNode.parse((String)((String)((CompletableFuture)Internet.download(URL2).thenApply(String::new)).join()));
            }
            catch (CompletionException e) {
                throw new CompletionException(new UpdateCheckException("Failed to download update checker JSON file!", e.getCause() == null ? e : e.getCause()));
            }
            List<JsonNode> modList = parsed.isList() ? parsed.getJavaList() : Collections.singletonList(parsed);
            Map installedMods = Loader.instance().getIndexedModList();
            for (JsonNode node : modList) {
                String currentVersion;
                List<String> latestVersions;
                String modid;
                if (!node.isObject() || !node.containsKey("modid") || !node.containsKey("latestVersion") || !installedMods.containsKey(modid = node.getString("modid"))) continue;
                ModContainer mod = (ModContainer)installedMods.get(modid);
                JsonNode latestVersionsNode = node.get("latestVersion");
                if (latestVersionsNode.isString()) {
                    latestVersions = Collections.singletonList(latestVersionsNode.stringValue());
                } else {
                    if (!latestVersionsNode.isList()) continue;
                    latestVersions = new ArrayList<String>();
                    for (JsonNode version : latestVersionsNode.getJavaList()) {
                        if (!version.isString()) continue;
                        latestVersions.add(version.stringValue());
                    }
                }
                if (latestVersions.contains(currentVersion = mod.getVersion())) continue;
                String updateURL = node.containsKey("updateURL") && node.get("updateURL").isString() ? node.getString("updateURL") : "";
                result.add(new ModUpdateInfo(modid, currentVersion, latestVersions.get(0), updateURL));
            }
            return result;
        });
    }

    public static List<ModUpdateInfo> fetchUpdates(String url) throws UpdateCheckException {
        try {
            return UpdateCheckerImpl.fetchUpdatesAsync(url).join();
        }
        catch (CompletionException e) {
            try {
                throw e.getCause();
            }
            catch (UpdateCheckException e1) {
                throw e1;
            }
            catch (Throwable e1) {
                throw new UpdateCheckException("Failed to check for updates!", e1);
            }
        }
    }
}

