/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.proxy;

import com.falsepattern.lib.internal.FalsePatternLib;
import com.falsepattern.lib.internal.Share;
import com.falsepattern.lib.internal.config.LibraryConfig;
import com.falsepattern.lib.internal.impl.config.event.CommonEventHandlerPost;
import com.falsepattern.lib.internal.impl.config.event.CommonEventHandlerPre;
import com.falsepattern.lib.internal.impl.config.net.SyncPrompt;
import com.falsepattern.lib.internal.impl.config.net.SyncPromptHandler;
import com.falsepattern.lib.internal.impl.config.net.SyncReply;
import com.falsepattern.lib.internal.impl.config.net.SyncReplyHandler;
import com.falsepattern.lib.internal.impl.config.net.SyncRequest;
import com.falsepattern.lib.internal.impl.config.net.SyncRequestHandler;
import com.falsepattern.lib.updates.ModUpdateInfo;
import com.falsepattern.lib.updates.UpdateChecker;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class CommonProxy {
    protected CompletableFuture<List<ModUpdateInfo>> updatesFuture;

    public void construct(FMLConstructionEvent e) {
        FalsePatternLib.NETWORK.registerMessage(SyncRequestHandler.class, SyncRequest.class, 0, Side.SERVER);
        FalsePatternLib.NETWORK.registerMessage(SyncReplyHandler.class, SyncReply.class, 1, Side.CLIENT);
        FalsePatternLib.NETWORK.registerMessage(SyncPromptHandler.class, SyncPrompt.class, 2, Side.CLIENT);
    }

    public void preInit(FMLPreInitializationEvent e) {
        CommonEventHandlerPre.registerBus();
        if (LibraryConfig.ENABLE_UPDATE_CHECKER) {
            Share.LOG.info("Launching asynchronous update check.");
            this.updatesFuture = ((CompletableFuture)UpdateChecker.fetchUpdatesAsync("https://falsepattern.com/mc/versions.json").thenApplyAsync(updates -> {
                if (updates == null) {
                    updates = Collections.emptyList();
                }
                if (updates.isEmpty()) {
                    Share.LOG.info("No updates found.");
                } else {
                    Share.LOG.info("Found {} updates.", new Object[]{updates.size()});
                    for (ModUpdateInfo update : updates) {
                        update.log(Share.LOG);
                    }
                }
                return updates;
            })).exceptionally(ex -> {
                Share.LOG.error("Failed to check for updates!", ex);
                return Collections.emptyList();
            });
        } else {
            this.updatesFuture = CompletableFuture.completedFuture(Collections.emptyList());
        }
    }

    public void postInit(FMLPostInitializationEvent e) {
        CommonEventHandlerPost.registerBus();
    }
}

