/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin;

import com.falsepattern.lib.StableAPI;
import com.google.common.io.Files;
import java.nio.file.Path;
import java.util.function.Predicate;

@StableAPI(since="0.8.0")
public interface ITargetedMod {
    @StableAPI.Expose
    public String getModName();

    @StableAPI.Expose
    public boolean isLoadInDevelopment();

    @StableAPI.Expose
    default public boolean isMatchingJar(Path path) {
        String pathString = path.toString();
        String nameLowerCase = Files.getNameWithoutExtension((String)pathString).toLowerCase();
        String fileExtension = Files.getFileExtension((String)pathString);
        return "jar".equals(fileExtension) && this.getCondition().test(nameLowerCase);
    }

    @StableAPI.Expose
    public Predicate<String> getCondition();

    @StableAPI(since="0.5.0")
    public static final class PredicateHelpers {
        @StableAPI.Expose
        public static Predicate<String> startsWith(String subString) {
            return name -> name.startsWith(subString.toLowerCase());
        }

        @StableAPI.Expose
        public static Predicate<String> contains(String subString) {
            return name -> name.contains(subString.toLowerCase());
        }

        @StableAPI.Expose
        public static Predicate<String> matches(String regex) {
            return name -> name.matches(regex);
        }
    }
}

