/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.PngReader;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.PngjOutputException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.CRC32;

public class PngHelperInternal {
    private static final ThreadLocal<CRC32> crcProvider = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };
    public static Charset charsetLatin1 = Charset.forName("ISO-8859-1");
    public static Charset charsetUTF8 = Charset.forName("UTF-8");
    static boolean DEBUG = false;

    public static byte[] getPngIdSignature() {
        return new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    }

    public static int doubleToInt100000(double d) {
        return (int)(d * 100000.0 + 0.5);
    }

    public static double intToDouble100000(int i) {
        return (double)i / 100000.0;
    }

    public static int readByte(InputStream is) {
        try {
            return is.read();
        }
        catch (IOException e) {
            throw new PngjInputException("error reading byte", e);
        }
    }

    public static int readInt2(InputStream is) {
        try {
            int b1 = is.read();
            int b2 = is.read();
            if (b1 == -1 || b2 == -1) {
                return -1;
            }
            return (b1 << 8) + b2;
        }
        catch (IOException e) {
            throw new PngjInputException("error reading readInt2", e);
        }
    }

    public static int readInt4(InputStream is) {
        try {
            int b1 = is.read();
            int b2 = is.read();
            int b3 = is.read();
            int b4 = is.read();
            if (b1 == -1 || b2 == -1 || b3 == -1 || b4 == -1) {
                return -1;
            }
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
        }
        catch (IOException e) {
            throw new PngjInputException("error reading readInt4", e);
        }
    }

    public static int readInt1fromByte(byte[] b, int offset) {
        return b[offset] & 0xFF;
    }

    public static int readInt2fromBytes(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 16 | b[offset + 1] & 0xFF;
    }

    public static int readInt4fromBytes(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    public static void writeByte(OutputStream os, byte b) {
        try {
            os.write(b);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static void writeInt2(OutputStream os, int n) {
        byte[] temp = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        PngHelperInternal.writeBytes(os, temp);
    }

    public static void writeInt4(OutputStream os, int n) {
        byte[] temp = new byte[4];
        PngHelperInternal.writeInt4tobytes(n, temp, 0);
        PngHelperInternal.writeBytes(os, temp);
    }

    public static void writeInt2tobytes(int n, byte[] b, int offset) {
        b[offset] = (byte)(n >> 8 & 0xFF);
        b[offset + 1] = (byte)(n & 0xFF);
    }

    public static void writeInt4tobytes(int n, byte[] b, int offset) {
        b[offset] = (byte)(n >> 24 & 0xFF);
        b[offset + 1] = (byte)(n >> 16 & 0xFF);
        b[offset + 2] = (byte)(n >> 8 & 0xFF);
        b[offset + 3] = (byte)(n & 0xFF);
    }

    public static void readBytes(InputStream is, byte[] b, int offset, int len) {
        if (len == 0) {
            return;
        }
        try {
            int n;
            for (int read = 0; read < len; read += n) {
                n = is.read(b, offset + read, len - read);
                if (n >= 1) continue;
                throw new PngjInputException("error reading bytes, " + n + " !=" + len);
            }
        }
        catch (IOException e) {
            throw new PngjInputException("error reading", e);
        }
    }

    public static void skipBytes(InputStream is, int len) {
        byte[] buf = new byte[32768];
        try {
            int read;
            for (int remain = len; remain > 0; remain -= read) {
                read = is.read(buf, 0, remain > buf.length ? buf.length : remain);
                if (read >= 0) continue;
                throw new PngjInputException("error reading (skipping) : EOF");
            }
        }
        catch (IOException e) {
            throw new PngjInputException("error reading (skipping)", e);
        }
    }

    public static void writeBytes(OutputStream os, byte[] b) {
        try {
            os.write(b);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static void writeBytes(OutputStream os, byte[] b, int offset, int n) {
        try {
            os.write(b, offset, n);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static void logdebug(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public static CRC32 getCRC() {
        return crcProvider.get();
    }

    public static int filterRowNone(int r) {
        return r & 0xFF;
    }

    public static int filterRowSub(int r, int left) {
        return r - left & 0xFF;
    }

    public static int filterRowUp(int r, int up) {
        return r - up & 0xFF;
    }

    public static int filterRowAverage(int r, int left, int up) {
        return r - (left + up) / 2 & 0xFF;
    }

    public static int filterRowPaeth(int r, int left, int up, int upleft) {
        return r - PngHelperInternal.filterPaethPredictor(left, up, upleft) & 0xFF;
    }

    public static int unfilterRowNone(int r) {
        return r & 0xFF;
    }

    public static int unfilterRowSub(int r, int left) {
        return r + left & 0xFF;
    }

    public static int unfilterRowUp(int r, int up) {
        return r + up & 0xFF;
    }

    public static int unfilterRowAverage(int r, int left, int up) {
        return r + (left + up) / 2 & 0xFF;
    }

    public static int unfilterRowPaeth(int r, int left, int up, int upleft) {
        return r + PngHelperInternal.filterPaethPredictor(left, up, upleft) & 0xFF;
    }

    static int filterPaethPredictor(int a, int b, int c) {
        int pc;
        int p = a + b - c;
        int pa = p >= a ? p - a : a - p;
        int pb = p >= b ? p - b : b - p;
        int n = pc = p >= c ? p - c : c - p;
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    public static void initCrcForTests(PngReader pngr) {
        pngr.initCrctest();
    }

    public static long getCrctestVal(PngReader pngr) {
        return pngr.getCrctestVal();
    }
}

