/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium;

import com.falsepattern.triangulator.api.ToggleableTessellator;
import cpw.mods.fml.common.Loader;
import java.util.List;
import makamys.neodymium.Neodymium;
import makamys.neodymium.util.OFUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GLContext;

public class Compat {
    private static boolean wasAdvancedOpenGLEnabled;

    public static void applyCompatibilityTweaks() {
        if (Loader.isModLoaded((String)"triangulator")) {
            Compat.disableTriangulator();
        }
    }

    private static void disableTriangulator() {
        ((ToggleableTessellator)Tessellator.field_78398_a).disableTriangulator();
    }

    public static void getCompatibilityWarnings(List<String> warns, List<String> criticalWarns) {
        if (Minecraft.func_71410_x().field_71474_y.field_74349_h) {
            warns.add("Advanced OpenGL is enabled, performance may be poor.");
        }
        if (Loader.isModLoaded((String)"FastCraft") && !OFUtil.isOptiFinePresent()) {
            criticalWarns.add("FastCraft is present without OptiFine, this is not supported.");
        }
        try {
            Class<?> shaders = Class.forName("shadersmod.client.Shaders");
            try {
                String shaderPack = (String)shaders.getMethod("getShaderPackName", new Class[0]).invoke(null, new Object[0]);
                if (shaderPack != null) {
                    criticalWarns.add("A shader pack is enabled, this is not supported.");
                }
            }
            catch (Exception e) {
                Neodymium.LOGGER.warn("Failed to get shader pack name");
                e.printStackTrace();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!GLContext.getCapabilities().OpenGL33) {
            criticalWarns.add("OpenGL 3.3 is not supported.");
        }
    }

    public static boolean hasChanged() {
        boolean changed = false;
        boolean advGL = Minecraft.func_71410_x().field_71474_y.field_74349_h;
        if (advGL != wasAdvancedOpenGLEnabled) {
            changed = true;
        }
        wasAdvancedOpenGLEnabled = advGL;
        return changed;
    }
}

