/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import makamys.neodymium.Compat;
import makamys.neodymium.config.Config;
import makamys.neodymium.renderer.NeoRenderer;
import makamys.neodymium.repackage.makamys.mclib.core.MCLib;
import makamys.neodymium.repackage.makamys.mclib.core.MCLibModules;
import makamys.neodymium.util.ChatUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="neodymium", version="0.1.6", guiFactory="makamys.neodymium.config.GuiFactory")
public class Neodymium {
    public static final String MODID = "neodymium";
    public static final String VERSION = "0.1.6";
    public static final Logger LOGGER = LogManager.getLogger((String)"neodymium");
    private static final Config.ReloadInfo CONFIG_RELOAD_INFO = new Config.ReloadInfo();
    private boolean renderDebugText = false;
    public static NeoRenderer renderer;
    private static World rendererWorld;

    @Mod.EventHandler
    public void preInit(FMLConstructionEvent event) {
        MCLib.init();
        Compat.applyCompatibilityTweaks();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MCLibModules.updateCheckAPI.submitModTask(MODID, "https://raw.githubusercontent.com/makamys/neodymium/master/updatejson/update.json");
        if (VERSION.equals(VERSION)) {
            event.getModMetadata().autogenerated = false;
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.modID.equals(MODID)) {
            Config.flush();
        }
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        Config.reloadConfig();
        ChatUtil.resetShownChatMessages();
    }

    private void onPlayerWorldChanged(World newWorld) {
        if (this.getRendererWorld() == null && newWorld != null) {
            Config.reloadConfig();
        }
        if (renderer != null) {
            Neodymium.destroyRenderer();
        }
        if (Config.enabled && newWorld != null) {
            Pair<List<String>, List<String>> warnsAndCriticalWarns = Neodymium.checkCompat();
            List warns = (List)warnsAndCriticalWarns.getLeft();
            List criticalWarns = (List)warnsAndCriticalWarns.getRight();
            if (criticalWarns.isEmpty() || Config.ignoreIncompatibilities) {
                renderer = new NeoRenderer(newWorld);
                Neodymium.renderer.hasIncompatibilities = !warns.isEmpty() || !criticalWarns.isEmpty();
            }
        }
        rendererWorld = newWorld;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!Config.enabled) {
            return;
        }
        if (event.world == this.getRendererWorld()) {
            this.onPlayerWorldChanged(null);
        }
    }

    public static boolean isActive() {
        return renderer != null && Neodymium.renderer.hasInited && !Neodymium.renderer.destroyPending;
    }

    private World getRendererWorld() {
        return rendererWorld;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Config.enabled) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && Neodymium.isActive() && Config.hotswap && Config.reloadIfChanged(CONFIG_RELOAD_INFO)) {
            if (Neodymium.CONFIG_RELOAD_INFO.needReload) {
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
            } else if (renderer != null) {
                renderer.reloadShader();
            }
        }
        if (event.phase == TickEvent.Phase.START && Compat.hasChanged()) {
            Pair<List<String>, List<String>> warns = Neodymium.checkCompat();
            if (renderer != null) {
                Neodymium.renderer.hasIncompatibilities = !((List)warns.getLeft()).isEmpty() || !((List)warns.getRight()).isEmpty();
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!Config.enabled) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            World world;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            World world2 = world = player != null ? player.field_70170_p : null;
            if (world != this.getRendererWorld()) {
                this.onPlayerWorldChanged(world);
            }
            if (Neodymium.isActive()) {
                Neodymium.renderer.forceRenderFog = true;
            }
        } else if (event.phase == TickEvent.Phase.END && Neodymium.isActive()) {
            renderer.onRenderTickEnd();
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (Config.showDebugInfo && Neodymium.isActive()) {
            if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.DEBUG)) {
                this.renderDebugText = true;
            } else if (this.renderDebugText && event instanceof RenderGameOverlayEvent.Text && event.type.equals((Object)RenderGameOverlayEvent.ElementType.TEXT)) {
                this.renderDebugText = false;
                RenderGameOverlayEvent.Text text = (RenderGameOverlayEvent.Text)event;
                text.right.add(null);
                text.right.addAll(renderer.getDebugText());
            }
        }
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (Neodymium.isActive()) {
            Neodymium.renderer.forceRenderFog = false;
        }
    }

    public static boolean shouldRenderVanillaWorld() {
        return !Neodymium.isActive() || Neodymium.isActive() && Neodymium.renderer.renderWorld && !Neodymium.renderer.rendererActive;
    }

    public static String modifySplash(String splash) {
        if (splash.equals("OpenGL 1.2!")) {
            return "OpenGL 3.3 (if supported)!";
        }
        return splash;
    }

    public static void destroyRenderer() {
        if (renderer != null) {
            renderer.destroy();
            renderer = null;
        }
        rendererWorld = null;
    }

    private static Pair<List<String>, List<String>> checkCompat() {
        ArrayList<String> warns = new ArrayList<String>();
        ArrayList<String> criticalWarns = new ArrayList<String>();
        Compat.getCompatibilityWarnings(warns, criticalWarns);
        if (!criticalWarns.isEmpty()) {
            criticalWarns.add("Neodymium has been disabled due to a critical incompatibility.");
        }
        for (String warn : warns) {
            LOGGER.warn(warn);
        }
        for (String criticalWarn : criticalWarns) {
            LOGGER.warn("Critical: " + criticalWarn);
        }
        return Pair.of(warns, criticalWarns);
    }
}

