/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import makamys.neodymium.Neodymium;
import makamys.neodymium.config.Config;
import makamys.neodymium.ducks.IWorldRenderer;
import makamys.neodymium.renderer.Mesh;
import makamys.neodymium.renderer.MeshQuad;
import makamys.neodymium.renderer.QuadNormal;
import makamys.neodymium.util.BufferWriter;
import makamys.neodymium.util.RecyclingList;
import makamys.neodymium.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ChunkMesh
extends Mesh {
    WorldRenderer wr;
    private int tesselatorDataCount;
    private int[] subMeshStart = new int[NORMAL_ORDER.length];
    public static int usedRAM = 0;
    public static int instances = 0;
    private static RecyclingList<MeshQuad> quadBuf = new RecyclingList<MeshQuad>(() -> new MeshQuad());
    private static ChunkMesh meshCaptureTarget;
    private static final QuadNormal[] NORMAL_ORDER;
    private static final Comparator<MeshQuad> MESH_QUAD_RENDER_COMPARATOR;
    private static final int[] QUAD_NORMAL_TO_NORMAL_ORDER;
    private static final Flags FLAGS;

    public ChunkMesh(WorldRenderer wr, int pass) {
        this.x = wr.field_78923_c / 16;
        this.y = wr.field_78920_d / 16;
        this.z = wr.field_78921_e / 16;
        this.wr = wr;
        this.pass = pass;
        Arrays.fill(this.subMeshStart, -1);
        ++instances;
        if (!quadBuf.getAsList().isEmpty()) {
            Neodymium.LOGGER.error("Invalid state: tried to construct a chunk mesh before the previous one has finished constructing!");
        }
    }

    public static void preTessellatorDraw(Tessellator t) {
        if (meshCaptureTarget != null) {
            meshCaptureTarget.addTessellatorData(t);
        }
    }

    private void addTessellatorData(Tessellator t) {
        ++this.tesselatorDataCount;
        if (t.field_78406_i == 0) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (t.field_78409_u != 7 && t.field_78409_u != 4) {
            errors.add("Unsupported draw mode: " + t.field_78409_u);
        }
        if (!(t.field_78400_o && t.field_78414_p && t.field_78399_n)) {
            errors.add(String.format("Unsupported tessellator flags: (hasTexture=%b, hasBrightness=%b, hasColor=%b)", t.field_78400_o, t.field_78414_p, t.field_78399_n));
        }
        if (t.field_78413_q && GL11.glIsEnabled((int)2896)) {
            errors.add("Chunk uses GL lighting, this is not implemented.");
        }
        if (!errors.isEmpty()) {
            if (!Config.silenceErrors) {
                try {
                    throw new IllegalArgumentException();
                }
                catch (IllegalArgumentException e) {
                    Neodymium.LOGGER.error("Errors in chunk ({}, {}, {})", new Object[]{this.x, this.y, this.z});
                    for (String error : errors) {
                        Neodymium.LOGGER.error("Error: " + error);
                    }
                    Neodymium.LOGGER.error("(World renderer pos: ({}, {}, {}), Tessellator pos: ({}, {}, {}), Tessellation count: {}", new Object[]{this.wr.field_78923_c, this.wr.field_78920_d, this.wr.field_78921_e, t.field_78408_v, t.field_78407_w, t.field_78417_x, this.tesselatorDataCount});
                    Neodymium.LOGGER.error("Stack trace:");
                    e.printStackTrace();
                    Neodymium.LOGGER.error("Skipping chunk due to errors.");
                }
            }
            return;
        }
        int verticesPerPrimitive = t.field_78409_u == 7 ? 4 : 3;
        for (int quadI = 0; quadI < t.field_78406_i / verticesPerPrimitive; ++quadI) {
            quadBuf.next().setState(t.field_78405_h, quadI * (verticesPerPrimitive * 8), FLAGS, t.field_78409_u, (float)(-t.field_78408_v), (float)(-t.field_78407_w), (float)(-t.field_78417_x));
        }
    }

    private static String tessellatorToString(Tessellator t) {
        return "(" + t.field_78408_v + ", " + t.field_78407_w + ", " + t.field_78417_x + ")";
    }

    public void finishConstruction() {
        List<MeshQuad> quads = quadBuf.getAsList();
        if (Config.simplifyChunkMeshes) {
            int plane;
            ArrayList quadsByPlaneDir = new ArrayList();
            for (int i = 0; i < 3; ++i) {
                quadsByPlaneDir.add(new ArrayList());
            }
            for (MeshQuad quad : quads) {
                if (quad.getPlane() == MeshQuad.Plane.NONE) continue;
                ((ArrayList)quadsByPlaneDir.get(quad.getPlane().ordinal() - 1)).add(quad);
            }
            for (plane = 0; plane < 3; ++plane) {
                ((ArrayList)quadsByPlaneDir.get(plane)).sort(MeshQuad.QuadPlaneComparator.quadPlaneComparators[plane]);
            }
            for (plane = 0; plane < 3; ++plane) {
                List planeDirQuads = (List)quadsByPlaneDir.get(plane);
                int planeStart = 0;
                for (int quadI = 0; quadI < planeDirQuads.size(); ++quadI) {
                    MeshQuad nextQuad;
                    MeshQuad quad = (MeshQuad)planeDirQuads.get(quadI);
                    MeshQuad meshQuad = nextQuad = quadI == planeDirQuads.size() - 1 ? null : (MeshQuad)planeDirQuads.get(quadI + 1);
                    if (quad.onSamePlaneAs(nextQuad)) continue;
                    ChunkMesh.simplifyPlane(planeDirQuads.subList(planeStart, quadI + 1));
                    planeStart = quadI + 1;
                }
            }
        }
        this.quadCount = ChunkMesh.countValidQuads(quads);
        this.buffer = this.createBuffer(quads, this.quadCount);
        usedRAM += this.buffer.limit();
        quadBuf.reset();
    }

    private static void simplifyPlane(List<MeshQuad> planeQuads) {
        int i;
        block0: for (int i2 = 0; i2 < planeQuads.size(); ++i2) {
            MeshQuad a = planeQuads.get(i2);
            for (int j = i2 + 1; j < planeQuads.size(); ++j) {
                MeshQuad b = planeQuads.get(j);
                if (a.noMerge || !a.isPosEqual(b)) continue block0;
                a.noMerge = true;
                b.noMerge = true;
            }
        }
        MeshQuad lastQuad = null;
        for (MeshQuad quad : planeQuads) {
            if (lastQuad != null) {
                lastQuad.tryToMerge(quad);
            }
            if (!MeshQuad.isValid(quad)) continue;
            lastQuad = quad;
        }
        for (i = 0; i < planeQuads.size(); ++i) {
            planeQuads.get((int)i).mergeReference = null;
        }
        for (i = 0; i < planeQuads.size(); ++i) {
            for (int j = i + 1; j < planeQuads.size(); ++j) {
                planeQuads.get(i).tryToMerge(planeQuads.get(j));
            }
        }
    }

    private static int countValidQuads(List<MeshQuad> quads) {
        int quadCount = 0;
        for (MeshQuad quad : quads) {
            if (quad.deleted) continue;
            ++quadCount;
        }
        return quadCount;
    }

    private ByteBuffer createBuffer(List<? extends MeshQuad> quads, int quadCount) {
        boolean sortByNormals;
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(quadCount * 4 * MeshQuad.getStride()));
        BufferWriter out = new BufferWriter(buffer);
        boolean bl = sortByNormals = this.pass == 0;
        if (sortByNormals) {
            quads.sort(MESH_QUAD_RENDER_COMPARATOR);
        }
        try {
            int i = 0;
            for (MeshQuad meshQuad : quads) {
                if (i >= quadCount) continue;
                if (MeshQuad.isValid(meshQuad)) {
                    int subMeshStartIdx;
                    int n = subMeshStartIdx = sortByNormals ? QUAD_NORMAL_TO_NORMAL_ORDER[meshQuad.normal.ordinal()] : 0;
                    if (this.subMeshStart[subMeshStartIdx] == -1) {
                        this.subMeshStart[subMeshStartIdx] = i;
                    }
                    meshQuad.writeToBuffer(out);
                    ++i;
                    continue;
                }
                if (!sortByNormals) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buffer.flip();
        return buffer;
    }

    void destroy() {
        if (this.buffer != null) {
            usedRAM -= this.buffer.limit();
            --instances;
            this.buffer = null;
            if (this.gpuStatus == Mesh.GPUStatus.SENT) {
                this.gpuStatus = Mesh.GPUStatus.PENDING_DELETE;
            }
        }
    }

    @Override
    public void destroyBuffer() {
        this.destroy();
    }

    @Override
    public int getStride() {
        return MeshQuad.getStride();
    }

    static List<ChunkMesh> getChunkMesh(int theX, int theY, int theZ) {
        WorldRenderer wr = new WorldRenderer((World)Minecraft.func_71410_x().field_71441_e, new ArrayList(), theX * 16, theY * 16, theZ * 16, 100000);
        wr.field_78935_u = false;
        wr.field_78936_t = true;
        wr.field_78927_l = true;
        wr.field_78937_s = 0;
        wr.func_78914_f();
        wr.func_147892_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        return ((IWorldRenderer)wr).getChunkMeshes();
    }

    @Override
    public int writeToIndexBuffer(IntBuffer piFirst, IntBuffer piCount, int cameraXDiv, int cameraYDiv, int cameraZDiv, int pass) {
        if (!Config.cullFaces) {
            return super.writeToIndexBuffer(piFirst, piCount, cameraXDiv, cameraYDiv, cameraZDiv, pass);
        }
        int renderedMeshes = 0;
        int startIndex = -1;
        for (int i = 0; i < NORMAL_ORDER.length + 1; ++i) {
            boolean isVisible;
            if (i < this.subMeshStart.length && this.subMeshStart[i] == -1) continue;
            QuadNormal normal = i < NORMAL_ORDER.length ? NORMAL_ORDER[i] : null;
            boolean bl = isVisible = normal != null && this.isNormalVisible(normal, cameraXDiv, cameraYDiv, cameraZDiv, pass);
            if (isVisible && startIndex == -1) {
                startIndex = this.subMeshStart[QUAD_NORMAL_TO_NORMAL_ORDER[normal.ordinal()]];
                continue;
            }
            if (isVisible || startIndex == -1) continue;
            int endIndex = i < this.subMeshStart.length ? this.subMeshStart[i] : this.quadCount;
            piFirst.put(this.iFirst + startIndex * 4);
            piCount.put((endIndex - startIndex) * 4);
            ++renderedMeshes;
            startIndex = -1;
        }
        return renderedMeshes;
    }

    private boolean isNormalVisible(QuadNormal normal, int interpXDiv, int interpYDiv, int interpZDiv, int pass) {
        switch (normal) {
            case POSITIVE_X: {
                return interpXDiv >= this.x + 0;
            }
            case NEGATIVE_X: {
                return interpXDiv < this.x + 1;
            }
            case POSITIVE_Y: {
                return interpYDiv >= this.y + 0;
            }
            case NEGATIVE_Y: {
                return interpYDiv < this.y + 1;
            }
            case POSITIVE_Z: {
                return interpZDiv >= this.z + 0;
            }
            case NEGATIVE_Z: {
                return interpZDiv < this.z + 1;
            }
        }
        return pass != 0 || Config.maxUnalignedQuadDistance == Integer.MAX_VALUE || Util.distSq(interpXDiv, interpYDiv, interpZDiv, this.x, this.y, this.z) < Math.pow(Config.maxUnalignedQuadDistance, 2.0);
    }

    public double distSq(Entity player) {
        int centerX = this.x * 16 + 8;
        int centerY = this.y * 16 + 8;
        int centerZ = this.z * 16 + 8;
        return player.func_70092_e((double)centerX, (double)centerY, (double)centerZ);
    }

    public static void setCaptureTarget(ChunkMesh cm) {
        meshCaptureTarget = cm;
    }

    static {
        NORMAL_ORDER = new QuadNormal[]{QuadNormal.NONE, QuadNormal.POSITIVE_Y, QuadNormal.POSITIVE_X, QuadNormal.POSITIVE_Z, QuadNormal.NEGATIVE_X, QuadNormal.NEGATIVE_Z, QuadNormal.NEGATIVE_Y};
        MESH_QUAD_RENDER_COMPARATOR = new MeshQuadRenderOrderComparator();
        FLAGS = new Flags(true, true, true, false);
        QUAD_NORMAL_TO_NORMAL_ORDER = new int[QuadNormal.values().length];
        for (int i = 0; i < QuadNormal.values().length; ++i) {
            int idx = Arrays.asList(NORMAL_ORDER).indexOf((Object)QuadNormal.values()[i]);
            if (idx == -1) {
                idx = 0;
            }
            ChunkMesh.QUAD_NORMAL_TO_NORMAL_ORDER[i] = idx;
        }
    }

    private static class MeshQuadRenderOrderComparator
    implements Comparator<MeshQuad> {
        private MeshQuadRenderOrderComparator() {
        }

        @Override
        public int compare(MeshQuad a, MeshQuad b) {
            if (!MeshQuad.isValid(b)) {
                return -1;
            }
            if (!MeshQuad.isValid(a)) {
                return 1;
            }
            return QUAD_NORMAL_TO_NORMAL_ORDER[a.normal.ordinal()] - QUAD_NORMAL_TO_NORMAL_ORDER[b.normal.ordinal()];
        }
    }

    public static class Flags {
        boolean hasTexture;
        boolean hasBrightness;
        boolean hasColor;
        boolean hasNormals;

        public Flags(byte flags) {
            this.hasTexture = (flags & 1) != 0;
            this.hasBrightness = (flags & 2) != 0;
            this.hasColor = (flags & 4) != 0;
            this.hasNormals = (flags & 8) != 0;
        }

        public Flags(boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals) {
            this.hasTexture = hasTexture;
            this.hasBrightness = hasBrightness;
            this.hasColor = hasColor;
            this.hasNormals = hasNormals;
        }

        public byte toByte() {
            byte flags = 0;
            if (this.hasTexture) {
                flags = (byte)(flags | 1);
            }
            if (this.hasBrightness) {
                flags = (byte)(flags | 2);
            }
            if (this.hasColor) {
                flags = (byte)(flags | 4);
            }
            if (this.hasNormals) {
                flags = (byte)(flags | 8);
            }
            return flags;
        }
    }
}

