/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import makamys.neodymium.config.Config;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.QuadNormal;
import makamys.neodymium.util.BufferWriter;
import org.lwjgl.util.vector.Vector3f;

public class MeshQuad {
    public float[] xs = new float[4];
    public float[] ys = new float[4];
    public float[] zs = new float[4];
    public float minX = Float.POSITIVE_INFINITY;
    public float minY = Float.POSITIVE_INFINITY;
    public float minZ = Float.POSITIVE_INFINITY;
    public float maxX = Float.NEGATIVE_INFINITY;
    public float maxY = Float.NEGATIVE_INFINITY;
    public float maxZ = Float.NEGATIVE_INFINITY;
    public float[] us = new float[4];
    public float[] vs = new float[4];
    public int[] bs = new int[4];
    public int[] cs = new int[4];
    public boolean deleted;
    public boolean noMerge;
    public QuadNormal normal;
    public int offset;
    public ChunkMesh.Flags flags;
    public boolean uDirectionIs01;
    public boolean isRectangle;
    private int[] quadCountByDirection = new int[]{1, 1};
    public static int[] totalMergeCountByPlane = new int[3];
    public MeshQuad mergeReference;
    private static Vector3f vectorA = new Vector3f();
    private static Vector3f vectorB = new Vector3f();
    private static Vector3f vectorC = new Vector3f();

    private void read(int[] rawBuffer, int offset, float offsetX, float offsetY, float offsetZ, int drawMode) {
        int vertices = drawMode == 4 ? 3 : 4;
        for (int vi = 0; vi < vertices; ++vi) {
            int i = offset + vi * 8;
            this.xs[vi] = Float.intBitsToFloat(rawBuffer[i + 0]) + offsetX;
            this.ys[vi] = Float.intBitsToFloat(rawBuffer[i + 1]) + offsetY;
            this.zs[vi] = Float.intBitsToFloat(rawBuffer[i + 2]) + offsetZ;
            this.us[vi] = Float.intBitsToFloat(rawBuffer[i + 3]);
            this.vs[vi] = Float.intBitsToFloat(rawBuffer[i + 4]);
            this.bs[vi] = rawBuffer[i + 7];
            this.cs[vi] = rawBuffer[i + 5];
            i += 8;
        }
        if (vertices == 3) {
            this.xs[3] = this.xs[2];
            this.ys[3] = this.ys[2];
            this.zs[3] = this.zs[2];
            this.us[3] = this.us[2];
            this.vs[3] = this.vs[2];
            this.bs[3] = this.bs[2];
            this.cs[3] = this.cs[2];
        }
    }

    public void setState(int[] rawBuffer, int offset, ChunkMesh.Flags flags, int drawMode, float offsetX, float offsetY, float offsetZ) {
        this.resetState();
        this.read(rawBuffer, offset, offsetX, offsetY, offsetZ, drawMode);
        this.uDirectionIs01 = this.us[0] != this.us[1];
        this.updateMinMaxXYZ();
        this.updateIsRectangle();
        if (!this.isRectangle) {
            this.noMerge = true;
        }
        vectorA.set(this.xs[1] - this.xs[0], this.ys[1] - this.ys[0], this.zs[1] - this.zs[0]);
        vectorB.set(this.xs[2] - this.xs[1], this.ys[2] - this.ys[1], this.zs[2] - this.zs[1]);
        Vector3f.cross((Vector3f)vectorA, (Vector3f)vectorB, (Vector3f)vectorC);
        this.normal = QuadNormal.fromVector(vectorC);
    }

    private void resetState() {
        Arrays.fill(this.xs, 0.0f);
        Arrays.fill(this.ys, 0.0f);
        Arrays.fill(this.zs, 0.0f);
        Arrays.fill(this.us, 0.0f);
        Arrays.fill(this.vs, 0.0f);
        Arrays.fill(this.bs, 0);
        Arrays.fill(this.cs, 0);
        this.minX = Float.POSITIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.minZ = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.maxZ = Float.NEGATIVE_INFINITY;
        this.noMerge = false;
        this.deleted = false;
        this.normal = null;
        this.offset = 0;
        this.flags = null;
        this.uDirectionIs01 = false;
        Arrays.fill(this.quadCountByDirection, 1);
        Arrays.fill(totalMergeCountByPlane, 0);
        this.mergeReference = null;
    }

    public void writeToBuffer(BufferWriter out) throws IOException {
        for (int vertexI = 0; vertexI < 4; ++vertexI) {
            int vi = vertexI;
            int provokingI = 3;
            float x = this.xs[vi];
            float y = this.ys[vi];
            float z = this.zs[vi];
            out.writeFloat(x);
            out.writeFloat(y);
            out.writeFloat(z);
            float u = this.us[vi];
            float v = this.vs[vi];
            if (Config.shortUV) {
                out.writeShort((short)Math.round(u * 32768.0f));
                out.writeShort((short)Math.round(v * 32768.0f));
            } else {
                out.writeFloat(u);
                out.writeFloat(v);
            }
            int b = this.bs[vi];
            out.writeInt(b);
            int c = this.cs[vi];
            out.writeInt(c);
            if (Config.simplifyChunkMeshes) {
                if (this.quadCountByUVDirection(false) == 1 && this.quadCountByUVDirection(true) == 1) {
                    out.writeByte((byte)-1);
                    out.writeByte((byte)-1);
                    out.writeByte((byte)-1);
                    out.writeByte((byte)-1);
                } else {
                    out.writeByte(this.us[vi] == this.us[provokingI] ? (byte)0 : (byte)this.quadCountByUVDirection(false));
                    out.writeByte(this.vs[vi] == this.vs[provokingI] ? (byte)0 : (byte)this.quadCountByUVDirection(true));
                    out.writeByte(this.us[vi] == this.us[provokingI] ? (byte)0 : 1);
                    out.writeByte(this.vs[vi] == this.vs[provokingI] ? (byte)0 : 1);
                }
            }
            assert (out.position() % MeshQuad.getStride() == 0);
        }
    }

    public int quadCountByUVDirection(boolean v) {
        if (v) {
            return this.quadCountByDirection[this.uDirectionIs01 ? 0 : 1];
        }
        return this.quadCountByDirection[this.uDirectionIs01 ? 1 : 0];
    }

    public static int getStride() {
        return 12 + 2 * (Config.shortUV ? 2 : 4) + 4 + 4 + (Config.simplifyChunkMeshes ? 4 : 0);
    }

    private boolean isTranslatedCopyOf(MeshQuad o, boolean checkValid) {
        int i;
        if (!MeshQuad.isValid(this) && checkValid || !MeshQuad.isValid(o) || this.normal != o.normal) {
            return false;
        }
        if (this.mergeReference != null) {
            return this.mergeReference.isTranslatedCopyOf(o, false);
        }
        for (i = 1; i < 4; ++i) {
            double relX = this.xs[i] - this.xs[0];
            double relY = this.ys[i] - this.ys[0];
            double relZ = this.zs[i] - this.zs[0];
            if ((double)o.xs[i] == (double)o.xs[0] + relX && (double)o.ys[i] == (double)o.ys[0] + relY && (double)o.zs[i] == (double)o.zs[0] + relZ) continue;
            return false;
        }
        for (i = 0; i < 4; ++i) {
            if (this.us[i] == o.us[i] && this.vs[i] == o.vs[i] && this.bs[i] == o.bs[i] && this.cs[i] == o.cs[i]) continue;
            return false;
        }
        return true;
    }

    public void tryToMerge(MeshQuad o) {
        if (this.noMerge || o.noMerge) {
            return;
        }
        if (this.isTranslatedCopyOf(o, true)) {
            int i;
            int numVerticesTouching = 0;
            boolean[] verticesTouching = new boolean[4];
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.xs[i] != o.xs[j] || this.ys[i] != o.ys[j] || this.zs[i] != o.zs[j]) continue;
                    verticesTouching[i] = true;
                    ++numVerticesTouching;
                }
            }
            if (numVerticesTouching == 2) {
                for (i = 0; i < 4; ++i) {
                    if (!verticesTouching[i]) continue;
                    this.copyVertexFrom(o, i, i);
                }
                if (verticesTouching[0] && verticesTouching[1] || verticesTouching[2] && verticesTouching[3]) {
                    this.quadCountByDirection[0] = this.quadCountByDirection[0] + o.quadCountByDirection[0];
                }
                if (verticesTouching[1] && verticesTouching[2] || verticesTouching[3] && verticesTouching[0]) {
                    this.quadCountByDirection[1] = this.quadCountByDirection[1] + o.quadCountByDirection[1];
                }
                int n = this.getPlane().ordinal() - 1;
                totalMergeCountByPlane[n] = totalMergeCountByPlane[n] + 1;
                this.mergeReference = o;
                o.deleted = true;
            }
        }
    }

    private void copyVertexFrom(MeshQuad o, int src, int dest) {
        this.xs[dest] = o.xs[src];
        this.ys[dest] = o.ys[src];
        this.zs[dest] = o.zs[src];
        this.us[dest] = o.us[src];
        this.vs[dest] = o.vs[src];
        this.bs[dest] = o.bs[src];
        this.cs[dest] = o.cs[src];
        this.updateMinMaxXYZ();
    }

    private void updateMinMaxXYZ() {
        for (int i = 0; i < 4; ++i) {
            this.minX = Math.min(this.minX, this.xs[i]);
            this.minY = Math.min(this.minY, this.ys[i]);
            this.minZ = Math.min(this.minZ, this.zs[i]);
            this.maxX = Math.max(this.maxX, this.xs[i]);
            this.maxY = Math.max(this.maxY, this.ys[i]);
            this.maxZ = Math.max(this.maxZ, this.zs[i]);
        }
    }

    private void updateIsRectangle() {
        this.isRectangle = this.vertexExists(this.minX, this.minY, this.minZ) && this.vertexExists(this.minX, this.minY, this.maxZ) && this.vertexExists(this.minX, this.maxY, this.minZ) && this.vertexExists(this.minX, this.maxY, this.maxZ) && this.vertexExists(this.maxX, this.minY, this.minZ) && this.vertexExists(this.maxX, this.minY, this.maxZ) && this.vertexExists(this.maxX, this.maxY, this.minZ) && this.vertexExists(this.maxX, this.maxY, this.maxZ);
    }

    private boolean vertexExists(float x, float y, float z) {
        for (int i = 0; i < 4; ++i) {
            if (this.xs[i] != x || this.ys[i] != y || this.zs[i] != z) continue;
            return true;
        }
        return false;
    }

    public double getMin(int coord) {
        return coord == 0 ? (double)this.minX : (coord == 1 ? (double)this.minY : (coord == 2 ? (double)this.minZ : -1.0));
    }

    public double getMax(int coord) {
        return coord == 0 ? (double)this.maxX : (coord == 1 ? (double)this.maxY : (coord == 2 ? (double)this.maxZ : -1.0));
    }

    public boolean onSamePlaneAs(MeshQuad o) {
        return MeshQuad.isValid(this) && MeshQuad.isValid(o) && this.getPlane() == o.getPlane() && (this.getPlane() == Plane.XY && this.minZ == o.minZ || this.getPlane() == Plane.XZ && this.minY == o.minY || this.getPlane() == Plane.YZ && this.minX == o.minX);
    }

    public Plane getPlane() {
        return Plane.fromNormal(this.normal);
    }

    public static boolean isValid(MeshQuad q) {
        return q != null && !q.deleted;
    }

    public boolean isClockwiseXZ() {
        return (this.xs[1] - this.xs[0]) * (this.zs[2] - this.zs[0]) - (this.xs[2] - this.xs[0]) * (this.zs[1] - this.zs[0]) < 0.0f;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%s(%.1f, %.1f, %.1f -- %.1f, %.1f, %.1f)", this.deleted ? "XXX " : "", Float.valueOf(this.minX), Float.valueOf(this.minY), Float.valueOf(this.minZ), Float.valueOf(this.maxX), Float.valueOf(this.maxY), Float.valueOf(this.maxZ));
    }

    public boolean isPosEqual(MeshQuad b) {
        return Arrays.equals(this.xs, b.xs) && Arrays.equals(this.ys, b.ys) && Arrays.equals(this.zs, b.zs);
    }

    public static enum Plane {
        NONE,
        XY,
        XZ,
        YZ;


        public static Plane fromNormal(QuadNormal normal) {
            switch (normal) {
                case POSITIVE_X: 
                case NEGATIVE_X: {
                    return YZ;
                }
                case POSITIVE_Y: 
                case NEGATIVE_Y: {
                    return XZ;
                }
                case POSITIVE_Z: 
                case NEGATIVE_Z: {
                    return XY;
                }
            }
            return NONE;
        }
    }

    public static class QuadPlaneComparator
    implements Comparator<MeshQuad> {
        public static final QuadPlaneComparator[] quadPlaneComparators = new QuadPlaneComparator[]{new QuadPlaneComparator(2, 1, 0), new QuadPlaneComparator(1, 2, 0), new QuadPlaneComparator(0, 2, 1)};
        private int c0;
        private int c1;
        private int c2;

        public QuadPlaneComparator(int firstCoordToCompare, int secondCoordToCompare, int thirdCoordToCompare) {
            this.c0 = firstCoordToCompare;
            this.c1 = secondCoordToCompare;
            this.c2 = thirdCoordToCompare;
        }

        @Override
        public int compare(MeshQuad a, MeshQuad b) {
            if (a.getMin(this.c0) < b.getMin(this.c0)) {
                return -1;
            }
            if (a.getMin(this.c0) > b.getMin(this.c0)) {
                return 1;
            }
            if (a.getMin(this.c1) < b.getMin(this.c1)) {
                return -1;
            }
            if (a.getMin(this.c1) > b.getMin(this.c1)) {
                return 1;
            }
            if (a.getMin(this.c2) < b.getMin(this.c2)) {
                return -1;
            }
            if (a.getMin(this.c2) > b.getMin(this.c2)) {
                return 1;
            }
            return (int)Math.signum(a.offset - b.offset);
        }
    }
}

