/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import makamys.neodymium.Neodymium;
import makamys.neodymium.config.Config;
import makamys.neodymium.ducks.IWorldRenderer;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.GPUMemoryManager;
import makamys.neodymium.renderer.Mesh;
import makamys.neodymium.renderer.MeshQuad;
import makamys.neodymium.renderer.NeoChunk;
import makamys.neodymium.renderer.NeoRegion;
import makamys.neodymium.util.GuiHelper;
import makamys.neodymium.util.OFUtil;
import makamys.neodymium.util.Preprocessor;
import makamys.neodymium.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class NeoRenderer {
    private static final MeshDistanceComparator DISTANCE_COMPARATOR = new MeshDistanceComparator();
    public boolean hasInited = false;
    public boolean destroyPending;
    public boolean reloadPending;
    public int rendererSpeedup;
    private static boolean[] wasDown = new boolean[256];
    public boolean renderWorld;
    public boolean rendererActive;
    private boolean showMemoryDebugger;
    public boolean forceRenderFog;
    public boolean hasIncompatibilities;
    private static int MAX_MESHES;
    private int VAO;
    private int[] shaderProgramsFog = new int[]{0, 0};
    private int[] shaderProgramsNoFog = new int[]{0, 0};
    private IntBuffer[] piFirst = new IntBuffer[2];
    private IntBuffer[] piCount = new IntBuffer[2];
    private List<Mesh>[] sentMeshes = new ArrayList[]{new ArrayList(), new ArrayList()};
    GPUMemoryManager mem;
    private Map<ChunkCoordIntPair, NeoRegion> loadedRegionsMap = new HashMap<ChunkCoordIntPair, NeoRegion>();
    public World world;
    private double eyePosX;
    private double eyePosY;
    private double eyePosZ;
    private double eyePosXT;
    private double eyePosYT;
    private double eyePosZT;
    int eyePosXTDiv;
    int eyePosYTDiv;
    int eyePosZTDiv;
    private int renderedMeshes;
    private int renderedQuads;
    private int frameCount;
    Vector4f transformedOrigin = new Vector4f();
    FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer projBuf = BufferUtils.createFloatBuffer((int)16);
    IntBuffer viewportBuf = BufferUtils.createIntBuffer((int)16);
    FloatBuffer projInvBuf = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer fogColorBuf = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer fogStartEnd = BufferUtils.createFloatBuffer((int)2);
    Matrix4f modelViewMatrix = new Matrix4f();
    Matrix4f modelViewMatrixInv = new Matrix4f();
    Matrix4f projMatrix = new Matrix4f();

    public NeoRenderer(World world) {
        this.world = world;
        if (this.shouldRenderInWorld(world)) {
            this.hasInited = this.init();
        }
        this.renderWorld = true;
        this.rendererActive = true;
    }

    public void preRenderSortedRenderers(int renderPass, double alpha, WorldRenderer[] sortedWorldRenderers) {
        if (this.hasInited) {
            if (renderPass == 0) {
                this.renderedMeshes = 0;
                this.renderedQuads = 0;
                this.mainLoop();
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    this.handleKeyboard();
                }
                if (this.mem.getCoherenceRate() < 0.95f || this.frameCount % 4 == 0) {
                    this.mem.runGC(false);
                }
                if (this.rendererActive && this.renderWorld) {
                    this.updateGLValues();
                    this.transformedOrigin.set(0.0f, 0.0f, 0.0f, 1.0f);
                    Matrix4f.transform((Matrix4f)this.modelViewMatrixInv, (Vector4f)this.transformedOrigin, (Vector4f)this.transformedOrigin);
                    EntityLivingBase rve = Minecraft.func_71410_x().field_71451_h;
                    this.eyePosX = rve.field_70142_S + (rve.field_70165_t - rve.field_70142_S) * alpha;
                    this.eyePosY = rve.field_70137_T + (rve.field_70163_u - rve.field_70137_T) * alpha + (double)rve.func_70047_e();
                    this.eyePosZ = rve.field_70136_U + (rve.field_70161_v - rve.field_70136_U) * alpha;
                    this.eyePosXT = this.eyePosX + (double)this.transformedOrigin.x;
                    this.eyePosYT = this.eyePosY + (double)this.transformedOrigin.y;
                    this.eyePosZT = this.eyePosZ + (double)this.transformedOrigin.z;
                    this.eyePosXTDiv = Math.floorDiv((int)Math.floor(this.eyePosXT), 16);
                    this.eyePosYTDiv = Math.floorDiv((int)Math.floor(this.eyePosYT), 16);
                    this.eyePosZTDiv = Math.floorDiv((int)Math.floor(this.eyePosZT), 16);
                    this.sort(this.frameCount % 100 == 0, this.frameCount % Config.sortFrequency == 0);
                    this.updateMeshes();
                    this.initIndexBuffers();
                }
                ++this.frameCount;
            }
            if (this.rendererActive && this.renderWorld) {
                Minecraft.func_71410_x().field_71460_t.func_78463_b(alpha);
                this.render(renderPass, alpha);
                Minecraft.func_71410_x().field_71460_t.func_78483_a(alpha);
            }
        }
    }

    public void onRenderTickEnd() {
        if (this.destroyPending) {
            this.destroy();
            Neodymium.renderer = null;
            return;
        }
        if (this.reloadPending) {
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
        if (this.showMemoryDebugger && this.mem != null) {
            GuiHelper.begin();
            this.mem.drawInfo();
            GuiHelper.end();
        }
    }

    private void sort(boolean pass0, boolean pass1) {
        if (pass0) {
            this.sentMeshes[0].sort(DISTANCE_COMPARATOR.setOrigin(this.eyePosX, this.eyePosY, this.eyePosZ).setInverted(false));
        }
        if (pass1) {
            this.sentMeshes[1].sort(DISTANCE_COMPARATOR.setOrigin(this.eyePosX, this.eyePosY, this.eyePosZ).setInverted(true));
        }
    }

    private void updateMeshes() {
        for (List<Mesh> list : this.sentMeshes) {
            for (Mesh mesh : list) {
                mesh.update();
            }
        }
    }

    private void initIndexBuffers() {
        for (int i = 0; i < 2; ++i) {
            this.piFirst[i].limit(MAX_MESHES);
            this.piCount[i].limit(MAX_MESHES);
            for (Mesh mesh : this.sentMeshes[i]) {
                WorldRenderer wr = ((ChunkMesh)mesh).wr;
                if (!mesh.visible || !wr.field_78936_t || !this.shouldRenderMesh(mesh)) continue;
                int meshes = mesh.writeToIndexBuffer(this.piFirst[i], this.piCount[i], this.eyePosXTDiv, this.eyePosYTDiv, this.eyePosZTDiv, i);
                this.renderedMeshes += meshes;
                for (int j = this.piCount[i].position() - meshes; j < this.piCount[i].position(); ++j) {
                    this.renderedQuads += this.piCount[i].get(j) / 4;
                }
            }
            this.piFirst[i].flip();
            this.piCount[i].flip();
        }
    }

    private boolean shouldRenderMesh(Mesh mesh) {
        return (Config.maxMeshesPerFrame == -1 || this.renderedMeshes < Config.maxMeshesPerFrame) && (!NeoRenderer.isFogEnabled() && !Config.fogOcclusionWithoutFog || Config.fogOcclusion == !Config.fogOcclusion || mesh.distSq(this.eyePosX / 16.0, (double)mesh.y + 0.5, this.eyePosZ / 16.0) < Math.pow((double)this.fogStartEnd.get(1) / 16.0 + 1.0, 2.0));
    }

    private void mainLoop() {
        if (Minecraft.func_71410_x().field_71442_b.field_78774_b.field_147309_h) {
            Iterator<Map.Entry<ChunkCoordIntPair, NeoRegion>> it = this.loadedRegionsMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ChunkCoordIntPair, NeoRegion> kv = it.next();
                NeoRegion v = kv.getValue();
                if (v.shouldDelete()) {
                    v.destroy();
                    it.remove();
                    continue;
                }
                v.tick();
            }
        }
    }

    private void handleKeyboard() {
        if (Config.debugPrefix == 0 || Config.debugPrefix != -1 && Keyboard.isKeyDown((int)Config.debugPrefix)) {
            if (Keyboard.isKeyDown((int)33) && !wasDown[33]) {
                boolean bl = this.rendererActive = !this.rendererActive;
            }
            if (Keyboard.isKeyDown((int)47) && !wasDown[47]) {
                boolean bl = this.renderWorld = !this.renderWorld;
            }
            if (Keyboard.isKeyDown((int)19) && !wasDown[19]) {
                this.reloadShader();
            }
            if (Keyboard.isKeyDown((int)50) && !wasDown[50]) {
                boolean bl = this.showMemoryDebugger = !this.showMemoryDebugger;
            }
            if (Keyboard.isKeyDown((int)25) && !wasDown[25]) {
                Util.dumpTexture();
            }
            if (Keyboard.isKeyDown((int)203) && !wasDown[203]) {
                this.reloadPending = true;
            }
            if (Keyboard.isKeyDown((int)205) && !wasDown[205]) {
                this.rendererSpeedup = this.rendererSpeedup == 0 ? 300 : 0;
            }
        }
        for (int i = 0; i < 256; ++i) {
            NeoRenderer.wasDown[i] = Keyboard.isKeyDown((int)i);
        }
    }

    private void render(int pass, double alpha) {
        int shader = this.getShaderProgram(pass);
        if (shader == 0) {
            return;
        }
        GL30.glBindVertexArray((int)this.VAO);
        GL20.glUseProgram((int)shader);
        this.updateUniforms(alpha, pass);
        if (Config.wireframe) {
            GL11.glPolygonMode((int)1032, (int)6913);
        }
        GL14.glMultiDrawArrays((int)7, (IntBuffer)this.piFirst[pass], (IntBuffer)this.piCount[pass]);
        if (Config.wireframe) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
    }

    private void updateGLValues() {
        GL11.glGetFloat((int)2982, (FloatBuffer)this.modelView);
        GL11.glGetFloat((int)2983, (FloatBuffer)this.projBuf);
        GL11.glGetInteger((int)2978, (IntBuffer)this.viewportBuf);
        this.projMatrix.load(this.projBuf);
        this.projBuf.flip();
        this.projMatrix.invert();
        this.projMatrix.store(this.projInvBuf);
        this.projInvBuf.flip();
        this.modelViewMatrix.load(this.modelView);
        this.modelView.flip();
        this.modelViewMatrixInv.load(this.modelViewMatrix).invert();
        this.fogColorBuf.limit(16);
        GL11.glGetFloat((int)2918, (FloatBuffer)this.fogColorBuf);
        this.fogColorBuf.limit(4);
        this.fogStartEnd.put(GL11.glGetFloat((int)2915));
        this.fogStartEnd.put(GL11.glGetFloat((int)2916));
        this.fogStartEnd.flip();
    }

    private void updateUniforms(double alpha, int pass) {
        int shaderProgram = this.getShaderProgram(pass);
        int u_modelView = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"modelView");
        int u_proj = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"proj");
        int u_playerPos = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"playerPos");
        int u_light = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"lightTex");
        int u_viewport = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"viewport");
        int u_projInv = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"projInv");
        int u_fogColor = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogColor");
        int u_fogStartEnd = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogStartEnd");
        int u_fogMode = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogMode");
        int u_fogDensity = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogDensity");
        GL20.glUniformMatrix4((int)u_modelView, (boolean)false, (FloatBuffer)this.modelView);
        GL20.glUniformMatrix4((int)u_proj, (boolean)false, (FloatBuffer)this.projBuf);
        GL20.glUniformMatrix4((int)u_projInv, (boolean)false, (FloatBuffer)this.projInvBuf);
        GL20.glUniform4f((int)u_viewport, (float)this.viewportBuf.get(0), (float)this.viewportBuf.get(1), (float)this.viewportBuf.get(2), (float)this.viewportBuf.get(3));
        GL20.glUniform4((int)u_fogColor, (FloatBuffer)this.fogColorBuf);
        GL20.glUniform2((int)u_fogStartEnd, (FloatBuffer)this.fogStartEnd);
        GL20.glUniform1i((int)u_fogMode, (int)GL11.glGetInteger((int)2917));
        GL20.glUniform1f((int)u_fogDensity, (float)GL11.glGetFloat((int)2914));
        GL20.glUniform3f((int)u_playerPos, (float)((float)this.eyePosX), (float)((float)this.eyePosY), (float)((float)this.eyePosZ));
        GL20.glUniform1i((int)u_light, (int)1);
        this.modelView.position(0);
        this.projBuf.position(0);
        this.viewportBuf.position(0);
        this.projInvBuf.position(0);
        this.fogColorBuf.position(0);
        this.fogStartEnd.position(0);
    }

    public boolean init() {
        MAX_MESHES = Config.VRAMSize * 128;
        this.reloadShader();
        this.VAO = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.VAO);
        this.mem = new GPUMemoryManager();
        GL15.glBindBuffer((int)34962, (int)this.mem.VBO);
        int stride = MeshQuad.getStride();
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)(Config.shortUV ? 5123 : 5126), (boolean)false, (int)stride, (long)12L);
        int uvEnd = Config.shortUV ? 16 : 20;
        GL20.glVertexAttribPointer((int)2, (int)2, (int)5122, (boolean)false, (int)stride, (long)uvEnd);
        GL20.glVertexAttribPointer((int)3, (int)4, (int)5121, (boolean)false, (int)stride, (long)(uvEnd + 4));
        if (Config.simplifyChunkMeshes) {
            GL20.glVertexAttribPointer((int)4, (int)4, (int)5121, (boolean)false, (int)stride, (long)(uvEnd + 8));
        }
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL20.glEnableVertexAttribArray((int)3);
        if (Config.simplifyChunkMeshes) {
            GL20.glEnableVertexAttribArray((int)4);
        }
        for (int i = 0; i < 2; ++i) {
            this.piFirst[i] = BufferUtils.createIntBuffer((int)MAX_MESHES);
            this.piFirst[i].flip();
            this.piCount[i] = BufferUtils.createIntBuffer((int)MAX_MESHES);
            this.piCount[i].flip();
        }
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        return true;
    }

    public void reloadShader(int pass) {
        for (int hasFog = 0; hasFog <= 1; ++hasFog) {
            HashSet<String> defines = new HashSet<String>();
            if (hasFog == 1) {
                defines.add("RENDER_FOG");
            }
            if (Config.simplifyChunkMeshes) {
                defines.add("SIMPLIFY_MESHES");
            }
            if (Config.shortUV) {
                defines.add("SHORT_UV");
            }
            if (pass == 0) {
                defines.add("PASS_0");
            }
            boolean errors = false;
            int vertexShader = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)vertexShader, (CharSequence)Preprocessor.preprocess(Util.readFile("shaders/chunk.vert"), defines));
            GL20.glCompileShader((int)vertexShader);
            if (GL20.glGetShaderi((int)vertexShader, (int)35713) == 0) {
                System.out.println("Error compiling vertex shader: " + GL20.glGetShaderInfoLog((int)vertexShader, (int)256));
                errors = true;
            }
            int fragmentShader = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)fragmentShader, (CharSequence)Preprocessor.preprocess(Util.readFile("shaders/chunk.frag"), defines));
            GL20.glCompileShader((int)fragmentShader);
            if (GL20.glGetShaderi((int)fragmentShader, (int)35713) == 0) {
                System.out.println("Error compiling fragment shader: " + GL20.glGetShaderInfoLog((int)fragmentShader, (int)256));
                errors = true;
            }
            int newShaderProgram = GL20.glCreateProgram();
            GL20.glAttachShader((int)newShaderProgram, (int)vertexShader);
            GL20.glAttachShader((int)newShaderProgram, (int)fragmentShader);
            GL20.glLinkProgram((int)newShaderProgram);
            if (GL20.glGetProgrami((int)newShaderProgram, (int)35714) == 0) {
                System.out.println("Error linking shader: " + GL20.glGetShaderInfoLog((int)newShaderProgram, (int)256));
                errors = true;
            }
            if (!errors) {
                (hasFog == 1 ? this.shaderProgramsFog : this.shaderProgramsNoFog)[pass] = newShaderProgram;
            }
            GL20.glDeleteShader((int)vertexShader);
            GL20.glDeleteShader((int)fragmentShader);
        }
    }

    public void reloadShader() {
        this.reloadShader(0);
        this.reloadShader(1);
    }

    public void destroy() {
        if (!this.hasInited) {
            return;
        }
        GL20.glDeleteProgram((int)this.shaderProgramsFog[0]);
        GL20.glDeleteProgram((int)this.shaderProgramsFog[1]);
        GL20.glDeleteProgram((int)this.shaderProgramsNoFog[0]);
        GL20.glDeleteProgram((int)this.shaderProgramsNoFog[1]);
        GL30.glDeleteVertexArrays((int)this.VAO);
        this.mem.destroy();
        ChunkMesh.instances = 0;
        ChunkMesh.usedRAM = 0;
    }

    public void onWorldRendererChanged(WorldRenderer wr, WorldRendererChange change) {
        int x = Math.floorDiv(wr.field_78923_c, 16);
        int y = Math.floorDiv(wr.field_78920_d, 16);
        int z = Math.floorDiv(wr.field_78921_e, 16);
        NeoChunk neoChunk = this.getNeoChunk(x, z);
        boolean bl = neoChunk.isSectionVisible[y] = change == WorldRendererChange.VISIBLE;
        if (change == WorldRendererChange.DELETED) {
            this.removeMesh(neoChunk.chunkMeshes[y]);
            if (neoChunk.chunkMeshes[y] != null) {
                neoChunk.chunkMeshes[y].destroy();
                neoChunk.chunkMeshes[y] = null;
                --neoChunk.region.meshes;
            }
        }
        this.neoChunkChanged(neoChunk);
    }

    public void onWorldRendererPost(WorldRenderer wr, boolean sort) {
        int x = Math.floorDiv(wr.field_78923_c, 16);
        int y = Math.floorDiv(wr.field_78920_d, 16);
        int z = Math.floorDiv(wr.field_78921_e, 16);
        if (Minecraft.func_71410_x().field_71441_e.func_72964_e((int)x, (int)z).field_76636_d) {
            NeoChunk neoChunk = this.getNeoChunk(x, z);
            neoChunk.isSectionVisible[y] = ((IWorldRenderer)wr).isDrawn();
            neoChunk.putChunkMeshes(y, ((IWorldRenderer)wr).getChunkMeshes(), sort);
        }
    }

    public void onRenderFog() {
        this.forceRenderFog = false;
    }

    private NeoChunk getNeoChunk(int chunkX, int chunkZ) {
        return this.getRegionContaining(chunkX, chunkZ).getChunkAbsolute(chunkX, chunkZ);
    }

    private NeoRegion getRegionContaining(int chunkX, int chunkZ) {
        ChunkCoordIntPair key = new ChunkCoordIntPair(Math.floorDiv(chunkX, 32), Math.floorDiv(chunkZ, 32));
        NeoRegion region = this.loadedRegionsMap.get(key);
        if (region == null) {
            region = NeoRegion.load(Math.floorDiv(chunkX, 32), Math.floorDiv(chunkZ, 32));
            this.loadedRegionsMap.put(key, region);
        }
        return region;
    }

    public void setVisible(NeoChunk chunk, boolean visible) {
        this.setVisible(chunk, visible, false);
    }

    public void setVisible(NeoChunk neoChunk, boolean visible, boolean forceCheck) {
        if (!forceCheck && visible == neoChunk.visible) {
            return;
        }
        neoChunk.visible = visible;
        this.neoChunkChanged(neoChunk);
    }

    public void neoChunkChanged(NeoChunk neoChunk) {
        int newLOD = neoChunk.hasChunkMeshes() ? 2 : 0;
        for (int y = 0; y < 16; ++y) {
            for (int pass = 0; pass < 2; ++pass) {
                ChunkMesh cm = neoChunk.chunkMeshes[y * 2 + pass];
                if (cm == null) continue;
                if (neoChunk.isSectionVisible[y] && newLOD == 2) {
                    if (cm.visible) continue;
                    this.setMeshVisible(cm, true);
                    continue;
                }
                if (!cm.visible) continue;
                this.setMeshVisible(cm, false);
            }
        }
    }

    protected void setMeshVisible(Mesh mesh, boolean visible) {
        if (mesh == null) {
            return;
        }
        if (mesh.visible != visible) {
            mesh.visible = visible;
            if (mesh.gpuStatus == Mesh.GPUStatus.UNSENT) {
                this.mem.sendMeshToGPU(mesh);
                this.sentMeshes[mesh.pass].add(mesh);
            }
        }
    }

    public void removeMesh(Mesh mesh) {
        if (mesh == null) {
            return;
        }
        this.mem.deleteMeshFromGPU(mesh);
        this.sentMeshes[mesh.pass].remove(mesh);
        this.setMeshVisible(mesh, false);
    }

    public List<String> getDebugText() {
        ArrayList<String> text = new ArrayList<String>();
        text.addAll(Arrays.asList((!this.rendererActive ? EnumChatFormatting.RED + "(OFF) " : "") + "Neodymium " + "0.1.6"));
        text.addAll(this.mem.getDebugText());
        text.addAll(Arrays.asList("Meshes: " + ChunkMesh.instances + " (" + ChunkMesh.usedRAM / 1024 / 1024 + "MB)", "Rendered: " + this.renderedMeshes + " (" + this.renderedQuads / 1000 + "KQ)"));
        if (this.rendererSpeedup > 0) {
            text.addAll(Arrays.asList(EnumChatFormatting.YELLOW + "(!) Renderer speedup active"));
        }
        if (this.hasIncompatibilities) {
            text.addAll(Arrays.asList(EnumChatFormatting.YELLOW + "(!) Incompatibilities"));
        }
        return text;
    }

    private int getShaderProgram(int pass) {
        return (this.forceRenderFog || NeoRenderer.isFogEnabled() ? this.shaderProgramsFog : this.shaderProgramsNoFog)[pass];
    }

    private static boolean isFogEnabled() {
        switch (Config.renderFog) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return GL11.glIsEnabled((int)2912) && !OFUtil.isFogOff();
    }

    private boolean shouldRenderInWorld(World world) {
        return world != null;
    }

    public static enum WorldRendererChange {
        VISIBLE,
        INVISIBLE,
        DELETED;

    }

    public static class MeshDistanceComparator
    implements Comparator<Mesh> {
        double x;
        double y;
        double z;
        boolean inverted;

        public Comparator<? super Mesh> setInverted(boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public MeshDistanceComparator setOrigin(double x, double y, double z) {
            this.x = x / 16.0;
            this.y = y / 16.0;
            this.z = z / 16.0;
            return this;
        }

        @Override
        public int compare(Mesh a, Mesh b) {
            int mult;
            if (a.pass < b.pass) {
                return -1;
            }
            if (a.pass > b.pass) {
                return 1;
            }
            double distSqA = a.distSq(this.x, this.y, this.z);
            double distSqB = b.distSq(this.x, this.y, this.z);
            int n = mult = this.inverted ? -1 : 1;
            if (distSqA > distSqB) {
                return 1 * mult;
            }
            if (distSqA < distSqB) {
                return -1 * mult;
            }
            return 0;
        }
    }

    public static class ChunkCoordDistanceComparator
    implements Comparator<ChunkCoordIntPair> {
        double x;
        double y;
        double z;

        public ChunkCoordDistanceComparator(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public int compare(ChunkCoordIntPair p1, ChunkCoordIntPair p2) {
            int distSq2;
            int distSq1 = this.distSq(p1);
            return distSq1 < (distSq2 = this.distSq(p2)) ? -1 : (distSq1 > distSq2 ? 1 : 0);
        }

        int distSq(ChunkCoordIntPair p) {
            return (int)(Math.pow((double)(p.field_77276_a * 16) - this.x, 2.0) + Math.pow((double)(p.field_77275_b * 16) - this.z, 2.0));
        }
    }

    public static class NeoChunkComparator
    implements Comparator<NeoChunk> {
        Entity player;

        public NeoChunkComparator(Entity player) {
            this.player = player;
        }

        @Override
        public int compare(NeoChunk p1, NeoChunk p2) {
            int distSq2;
            int distSq1 = this.distSq(p1);
            return distSq1 < (distSq2 = this.distSq(p2)) ? -1 : (distSq1 > distSq2 ? 1 : 0);
        }

        int distSq(NeoChunk p) {
            return (int)(Math.pow(p.x * 16 - this.player.field_70176_ah, 2.0) + Math.pow(p.z * 16 - this.player.field_70164_aj, 2.0));
        }
    }
}

