/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.repackage.makamys.mclib.sloppydeploader;

import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import makamys.neodymium.repackage.makamys.mclib.core.MCLib;
import makamys.neodymium.repackage.makamys.mclib.sloppydeploader.ConfigSDL;
import makamys.neodymium.repackage.makamys.mclib.sloppydeploader.GuiRestartNotification;
import makamys.neodymium.repackage.makamys.mclib.sloppydeploader.SloppyDepDownloadManager;
import makamys.neodymium.repackage.makamys.mclib.sloppydeploader.SloppyDepLoaderAPI;
import makamys.neodymium.repackage.makamys.mclib.sloppydeploader.SloppyDependency;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sun.misc.URLClassPath;
import sun.net.util.URLUtil;

public class SloppyDepLoader {
    private static ByteBuffer downloadBuffer = ByteBuffer.allocateDirect(0x800000);
    private static final String owner = "Sloppy DepLoader";
    private static DepLoadInst inst;
    public static final String NS = "SloppyDepLoader";
    private static final Logger LOGGER;
    private static Map<String, String> modDeps;

    private static void addDependency(SloppyDependency dep) {
        if (inst == null) {
            inst = new DepLoadInst();
        }
        try {
            inst.addSloppyDep(dep);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void preInit() {
        ConfigSDL.reload();
        if (ConfigSDL.enabled) {
            for (Map.Entry<String, String> modDepEntry : SloppyDepLoaderAPI.modDeps.entrySet()) {
                Arrays.stream(modDepEntry.getValue().split(";")).forEach(k -> SloppyDepLoader.addDependency(new SloppyDependency(Arrays.copyOf(k.split(","), 5))));
            }
            if (inst != null) {
                inst.load();
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)NS);
        modDeps = new HashMap<String, String>();
    }

    public static class DepLoadInst {
        private File modsDir;
        private File v_modsDir;
        private IDownloadDisplay downloadMonitor;
        private Map<String, Dependency> depMap = new HashMap<String, Dependency>();
        private HashSet<String> depSet = new HashSet();
        private boolean showedRestartNotification;
        private SloppyDepDownloadManager downloadManager = new SloppyDepDownloadManager();

        public DepLoadInst() {
            String mcVer = (String)FMLInjectionData.data()[4];
            File mcDir = (File)FMLInjectionData.data()[6];
            this.modsDir = new File(mcDir, "mods");
            this.v_modsDir = new File(mcDir, "mods/" + mcVer);
            if (!this.v_modsDir.exists()) {
                this.v_modsDir.mkdirs();
            }
            MCLib.FML_MASTER.register((Object)this);
        }

        @Subscribe
        public void onInit(FMLInitializationEvent event) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onGui(GuiOpenEvent event) {
            if (event.gui instanceof GuiMainMenu && this.downloadManager.allDone()) {
                if (inst != null && !this.showedRestartNotification && !this.downloadManager.getDownloadedList().isEmpty()) {
                    ConfigSDL.reload();
                    if (ConfigSDL.showRestartNotification) {
                        event.gui = new GuiRestartNotification(event.gui, this.downloadManager.getDownloadedList());
                        this.showedRestartNotification = true;
                    }
                }
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }

        private void deleteMod(File mod) {
            if (mod.delete()) {
                return;
            }
            try {
                ClassLoader cl = SloppyDepLoader.class.getClassLoader();
                URL url = mod.toURI().toURL();
                Field f_ucp = URLClassLoader.class.getDeclaredField("ucp");
                Field f_loaders = URLClassPath.class.getDeclaredField("loaders");
                Field f_lmap = URLClassPath.class.getDeclaredField("lmap");
                f_ucp.setAccessible(true);
                f_loaders.setAccessible(true);
                f_lmap.setAccessible(true);
                URLClassPath ucp = (URLClassPath)f_ucp.get(cl);
                Closeable loader = (Closeable)((Map)f_lmap.get(ucp)).remove(URLUtil.urlNoFragString(url));
                if (loader != null) {
                    loader.close();
                    ((List)f_loaders.get(ucp)).remove(loader);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!mod.delete()) {
                mod.deleteOnExit();
                String msg = "Sloppy DepLoader was unable to delete file " + mod.getPath() + " the game will try to delete it on exit. If this message appears again, delete it manually.";
                LOGGER.error(msg);
            }
        }

        private void download(Dependency dep) {
            File libFile = new File(this.v_modsDir, dep.file.filename);
            try {
                URL libDownload = new URL(dep.url + '/' + dep.file.filename);
                this.downloadMonitor.updateProgressString("Downloading file %s", libDownload.toString());
                LOGGER.info(String.format("Downloading file %s\n", libDownload.toString()));
                URLConnection connection = libDownload.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("User-Agent", "Sloppy DepLoader Downloader");
                int sizeGuess = connection.getContentLength();
                this.download(connection.getInputStream(), sizeGuess, libFile);
                this.downloadMonitor.updateProgressString("Download complete", new Object[0]);
                LOGGER.info("Download complete");
                dep.downloaded = true;
            }
            catch (Exception e) {
                libFile.delete();
                LOGGER.error("A download error occured downloading " + dep.file.filename + " from " + dep.url + '/' + dep.file.filename + ": " + e.getMessage());
            }
        }

        private void download(InputStream is, int sizeGuess, File target) throws Exception {
            if (sizeGuess > downloadBuffer.capacity()) {
                throw new Exception(String.format("The file %s is too large to be downloaded by Sloppy DepLoader - the download is invalid", target.getName()));
            }
            downloadBuffer.clear();
            int fullLength = 0;
            this.downloadMonitor.resetProgress(sizeGuess);
            try {
                int bytesRead;
                this.downloadMonitor.setPokeThread(Thread.currentThread());
                byte[] smallBuffer = new byte[1024];
                while ((bytesRead = is.read(smallBuffer)) >= 0) {
                    downloadBuffer.put(smallBuffer, 0, bytesRead);
                    fullLength += bytesRead;
                    if (this.downloadMonitor.shouldStopIt()) break;
                    this.downloadMonitor.updateProgress(fullLength);
                }
                is.close();
                this.downloadMonitor.setPokeThread(null);
                downloadBuffer.limit(fullLength);
                downloadBuffer.position(0);
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
                throw new Exception("Stop");
            }
            catch (IOException e) {
                throw e;
            }
            if (!target.exists()) {
                target.createNewFile();
            }
            downloadBuffer.position(0);
            FileOutputStream fos = new FileOutputStream(target);
            fos.getChannel().write(downloadBuffer);
            fos.close();
        }

        private String checkExisting(Dependency dep) {
            VersionedFile vfile;
            for (File f : this.modsDir.listFiles()) {
                vfile = new VersionedFile(f.getName(), dep.file.pattern);
                if (!vfile.matches() || !vfile.name.equals(dep.file.name) || f.renameTo(new File(this.v_modsDir, f.getName()))) continue;
                this.deleteMod(f);
            }
            for (File f : this.v_modsDir.listFiles()) {
                vfile = new VersionedFile(f.getName(), dep.file.pattern);
                if (!vfile.matches() || !vfile.name.equals(dep.file.name)) continue;
                int cmp = vfile.version.compareTo(dep.file.version);
                if (cmp < 0) {
                    LOGGER.info("Deleted old version " + f.getName());
                    this.deleteMod(f);
                    return null;
                }
                if (cmp > 0) {
                    LOGGER.warn("Warning: version of " + dep.file.name + ", " + vfile.version + " is newer than request " + dep.file.version);
                    return f.getName();
                }
                return f.getName();
            }
            return null;
        }

        public void load() {
            if (this.depMap.isEmpty()) {
                return;
            }
            LOGGER.debug("Loading with depMap " + this.depMap);
            this.loadDeps();
        }

        private void loadDeps() {
            this.downloadMonitor = new DummyDownloader();
            while (!this.depSet.isEmpty()) {
                Iterator<String> it = this.depSet.iterator();
                Dependency dep = this.depMap.get(it.next());
                it.remove();
                this.loadAsync(dep);
            }
        }

        private void loadAsync(Dependency dep) {
            this.downloadManager.enqueueDownload(new SloppyDepDownloadTask(dep));
        }

        private void load(Dependency dep) {
            dep.existing = this.checkExisting(dep);
            if (dep.existing == null) {
                this.download(dep);
                dep.existing = dep.file.filename;
            }
        }

        public void addSloppyDep(SloppyDependency dep) throws IOException {
            VersionedFile file;
            boolean obfuscated = ((LaunchClassLoader)SloppyDepLoader.class.getClassLoader()).getClassBytes("net.minecraft.world.World") == null;
            String testClass = dep.testClass;
            if (SloppyDepLoader.class.getResource("/" + testClass.replace('.', '/') + ".class") != null) {
                LOGGER.trace("Skipping dependency " + dep + " because test class " + testClass + " is present");
                return;
            }
            String repo = dep.repo;
            String filename = dep.filename;
            if (!obfuscated && dep.dev.isPresent()) {
                filename = dep.dev.get();
            }
            boolean coreLib = false;
            Pattern pattern = null;
            try {
                if (dep.pattern.isPresent()) {
                    pattern = Pattern.compile(dep.pattern.get());
                }
            }
            catch (PatternSyntaxException e) {
                LOGGER.error("Invalid filename pattern: " + dep.pattern.get());
                e.printStackTrace();
            }
            if (pattern == null) {
                pattern = Pattern.compile("(\\w+).*?([\\d\\.]+)[-\\w]*\\.[^\\d]+");
            }
            if (!(file = new VersionedFile(filename, pattern)).matches()) {
                throw new RuntimeException("Invalid filename format for dependency: " + filename);
            }
            this.addDep(new Dependency(repo, file, coreLib));
        }

        private void addDep(Dependency newDep) {
            if (this.mergeNew(this.depMap.get(newDep.file.name), newDep)) {
                LOGGER.trace("Adding dependency " + newDep);
                this.depMap.put(newDep.file.name, newDep);
                this.depSet.add(newDep.file.name);
            } else {
                LOGGER.trace("Not adding dependency " + newDep + " because a newer version of it has been added already");
            }
        }

        private boolean mergeNew(Dependency oldDep, Dependency newDep) {
            if (oldDep == null) {
                return true;
            }
            Dependency newest = newDep.file.version.compareTo(oldDep.file.version) > 0 ? newDep : oldDep;
            newest.coreLib = newDep.coreLib || oldDep.coreLib;
            return newest == newDep;
        }

        class SloppyDepDownloadTask
        implements Supplier<String> {
            Dependency dep;

            public SloppyDepDownloadTask(Dependency dep) {
                this.dep = dep;
            }

            @Override
            public String get() {
                DepLoadInst.this.load(this.dep);
                return this.dep.downloaded ? this.dep.existing : null;
            }
        }
    }

    public static class Dependency {
        public String url;
        public VersionedFile file;
        public String existing;
        public boolean coreLib;
        public boolean downloaded;

        public Dependency(String url, VersionedFile file, boolean coreLib) {
            this.url = url;
            this.file = file;
            this.coreLib = coreLib;
        }

        public String toString() {
            return "Dependency{" + this.file.name + " @ " + this.url + "}";
        }
    }

    public static class VersionedFile {
        public final Pattern pattern;
        public final String filename;
        public final ComparableVersion version;
        public final String name;

        public VersionedFile(String filename, Pattern pattern) {
            this.pattern = pattern;
            this.filename = filename;
            Matcher m = pattern.matcher(filename);
            if (m.matches()) {
                this.name = m.group(1);
                this.version = new ComparableVersion(m.group(2));
            } else {
                this.name = null;
                this.version = null;
            }
        }

        public boolean matches() {
            return this.name != null;
        }
    }

    public static class DummyDownloader
    implements IDownloadDisplay {
        @Override
        public void resetProgress(int sizeGuess) {
        }

        @Override
        public void setPokeThread(Thread currentThread) {
        }

        @Override
        public void updateProgress(int fullLength) {
        }

        @Override
        public boolean shouldStopIt() {
            return false;
        }

        @Override
        public void updateProgressString(String string, Object ... data) {
        }

        @Override
        public Object makeDialog() {
            return null;
        }

        @Override
        public void showErrorDialog(String name, String url) {
        }
    }

    public static interface IDownloadDisplay {
        public void resetProgress(int var1);

        public void setPokeThread(Thread var1);

        public void updateProgress(int var1);

        public boolean shouldStopIt();

        public void updateProgressString(String var1, Object ... var2);

        public Object makeDialog();

        public void showErrorDialog(String var1, String var2);
    }
}

