/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.util;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class BufferWriter {
    private ByteBuffer buf;
    private FloatBuffer floatBuffer;
    private ShortBuffer shortBuffer;
    private IntBuffer intBuffer;

    public BufferWriter(ByteBuffer buf) {
        this.buf = buf;
        this.floatBuffer = buf.asFloatBuffer();
        this.shortBuffer = buf.asShortBuffer();
        this.intBuffer = buf.asIntBuffer();
    }

    private void incrementPosition(int add) {
        this.buf.position(this.buf.position() + add);
        this.floatBuffer.position(this.buf.position() / 4);
        this.shortBuffer.position(this.buf.position() / 2);
        this.intBuffer.position(this.buf.position() / 4);
    }

    public void writeFloat(float x) {
        try {
            this.floatBuffer.put(x);
            this.incrementPosition(4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeInt(int x) {
        this.intBuffer.put(x);
        this.incrementPosition(4);
    }

    public void writeByte(byte x) {
        this.buf.put(x);
        this.incrementPosition(0);
    }

    public int position() {
        return this.buf.position();
    }

    public void writeShort(short s) {
        this.shortBuffer.put(s);
        this.incrementPosition(2);
    }
}

