/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.util;

import java.util.HashSet;
import java.util.Set;
import makamys.neodymium.Neodymium;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ChatUtil {
    private static Set<String> shownChatMessages = new HashSet<String>();

    public static void showChatMessage(String text) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ChatComponentText cc = new ChatComponentText(text);
            player.func_146105_b((IChatComponent)cc);
        } else {
            Neodymium.LOGGER.info(text);
        }
    }

    public static void showNeoChatMessage(String text, MessageVerbosity verbosity) {
        ChatUtil.showNeoChatMessage(text, verbosity, false);
    }

    public static void showNeoChatMessage(String text, MessageVerbosity verbosity, boolean once) {
        if (shownChatMessages.contains(text)) {
            return;
        }
        String verbosityText = verbosity == MessageVerbosity.WARNING ? EnumChatFormatting.YELLOW + "WARNING" : (verbosity == MessageVerbosity.ERROR ? EnumChatFormatting.RED + "ERROR" : "INFO");
        ChatUtil.showChatMessage("[" + EnumChatFormatting.LIGHT_PURPLE + "neodymium" + EnumChatFormatting.RESET + "/" + verbosityText + EnumChatFormatting.RESET + "] " + text);
        shownChatMessages.add(text);
    }

    public static void resetShownChatMessages() {
        shownChatMessages.clear();
    }

    public static enum MessageVerbosity {
        INFO,
        WARNING,
        ERROR;

    }
}

