/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Util {
    private static boolean allowResourceOverrides = Boolean.parseBoolean(System.getProperty("neodymium.allowResourceOverrides", "false"));

    public static Path getResourcePath(String relPath) {
        File overrideFile;
        if (allowResourceOverrides && (overrideFile = new File(new File(Launch.minecraftHome, "neodymium/resources"), relPath)).exists()) {
            return overrideFile.toPath();
        }
        try {
            URL resourceURL = Util.class.getClassLoader().getResource(relPath);
            switch (resourceURL.getProtocol()) {
                case "jar": {
                    String urlString = resourceURL.getPath();
                    int lastExclamation = urlString.lastIndexOf(33);
                    String newURLString = urlString.substring(0, lastExclamation);
                    return FileSystems.newFileSystem(new File(URI.create(newURLString)).toPath(), null).getPath(relPath, new String[0]);
                }
                case "file": {
                    return new File(URI.create(resourceURL.toString())).toPath();
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String readFile(String path) {
        try {
            return new String(Files.readAllBytes(Util.getResourcePath(path)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] byteBufferToArray(ByteBuffer buffer) {
        byte[] dst = new byte[buffer.limit()];
        int pos = buffer.position();
        buffer.position(0);
        buffer.get(dst);
        buffer.position(pos);
        return dst;
    }

    public static int[] intBufferToArray(IntBuffer buffer) {
        int[] dst = new int[buffer.limit()];
        int pos = buffer.position();
        buffer.position(0);
        buffer.get(dst);
        buffer.position(pos);
        return dst;
    }

    public static float[] floatBufferToArray(FloatBuffer buffer) {
        float[] dst = new float[buffer.limit()];
        int pos = buffer.position();
        buffer.position(0);
        buffer.get(dst);
        buffer.position(pos);
        return dst;
    }

    public static double distSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static void dumpTexture() {
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        System.out.println("Dumped " + width + "x" + height + " texture.");
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(4 * width * height));
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buf);
        try {
            FileUtils.writeByteArrayToFile((File)new File("out.rgba"), (byte[])Util.byteBufferToArray(buf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

