/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.launch;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JDialog;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class DepLoader
implements IFMLLoadingPlugin,
IFMLCallHook {
    private static final ByteBuffer downloadBuffer = ByteBuffer.allocateDirect(0x800000);
    private static final String owner = "CB's DepLoader";
    private static DepLoadInst inst;

    public static void load() {
        if (inst == null) {
            inst = new DepLoadInst();
            inst.load();
        }
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public Void call() {
        DepLoader.load();
        return null;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public static class DepLoadInst {
        private File modsDir;
        private File v_modsDir;
        private IDownloadDisplay downloadMonitor;
        private JDialog popupWindow;
        private Map<String, Dependency> depMap = new HashMap<String, Dependency>();
        private HashSet<String> depSet = new HashSet();

        public DepLoadInst() {
            String mcVer = (String)FMLInjectionData.data()[4];
            File mcDir = (File)FMLInjectionData.data()[6];
            this.modsDir = new File(mcDir, "mods");
            this.v_modsDir = new File(mcDir, "mods/" + mcVer);
            if (!this.v_modsDir.exists()) {
                this.v_modsDir.mkdirs();
            }
        }

        private void addClasspath(String name) {
            try {
                ((LaunchClassLoader)DepLoader.class.getClassLoader()).addURL(new File(this.v_modsDir, name).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        private void deleteMod(File mod) {
        }

        private void download(Dependency dep) {
        }

        private void download(InputStream is, int sizeGuess, File target) throws Exception {
        }

        private String checkExisting(Dependency dep) {
            VersionedFile vfile;
            for (File f : this.modsDir.listFiles()) {
                vfile = new VersionedFile(f.getName(), dep.file.pattern);
                if (!vfile.matches() || !vfile.name.equals(dep.file.name) || f.renameTo(new File(this.v_modsDir, f.getName()))) continue;
                this.deleteMod(f);
            }
            for (File f : this.v_modsDir.listFiles()) {
                vfile = new VersionedFile(f.getName(), dep.file.pattern);
                if (!vfile.matches() || !vfile.name.equals(dep.file.name)) continue;
                int cmp = vfile.version.compareTo(dep.file.version);
                if (cmp < 0) {
                    System.out.println("Deleted old version " + f.getName());
                    this.deleteMod(f);
                    return null;
                }
                if (cmp > 0) {
                    System.err.println("Warning: version of " + dep.file.name + ", " + vfile.version + " is newer than request " + dep.file.version);
                    return f.getName();
                }
                return f.getName();
            }
            return null;
        }

        public void load() {
            this.scanDepInfos();
            if (this.depMap.isEmpty()) {
                return;
            }
            this.loadDeps();
            this.activateDeps();
        }

        private void activateDeps() {
            for (Dependency dep : this.depMap.values()) {
                if (!dep.coreLib) continue;
                this.addClasspath(dep.existing);
            }
        }

        private void loadDeps() {
            this.downloadMonitor = new DummyDownloader();
            try {
                while (!this.depSet.isEmpty()) {
                    Iterator<String> it = this.depSet.iterator();
                    Dependency dep = this.depMap.get(it.next());
                    it.remove();
                    this.load(dep);
                }
            }
            finally {
                if (this.popupWindow != null) {
                    this.popupWindow.setVisible(false);
                    this.popupWindow.dispose();
                }
            }
        }

        private void load(Dependency dep) {
            dep.existing = this.checkExisting(dep);
            if (dep.existing == null) {
                this.download(dep);
                dep.existing = dep.file.filename;
            }
        }

        private List<File> modFiles() {
            LinkedList<File> list = new LinkedList<File>();
            list.addAll(Arrays.asList(this.modsDir.listFiles()));
            list.addAll(Arrays.asList(this.v_modsDir.listFiles()));
            return list;
        }

        private void scanDepInfos() {
            for (File file : this.modFiles()) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                this.scanDepInfo(file);
            }
        }

        private void scanDepInfo(File file) {
            try {
                ZipFile zip = new ZipFile(file);
                ZipEntry e = zip.getEntry("dependancies.info");
                if (e == null) {
                    e = zip.getEntry("dependencies.info");
                }
                if (e != null) {
                    this.loadJSon(zip.getInputStream(e));
                }
                zip.close();
            }
            catch (Exception e) {
                System.err.println("Failed to load dependencies.info from " + file.getName() + " as JSON");
                e.printStackTrace();
            }
        }

        private void loadJSon(InputStream input) throws IOException {
            InputStreamReader reader = new InputStreamReader(input);
            JsonElement root = new JsonParser().parse((Reader)reader);
            if (root.isJsonArray()) {
                this.loadJSonArr(root);
            } else {
                this.loadJson(root.getAsJsonObject());
            }
            reader.close();
        }

        private void loadJSonArr(JsonElement root) throws IOException {
            for (JsonElement node : root.getAsJsonArray()) {
                this.loadJson(node.getAsJsonObject());
            }
        }

        private void loadJson(JsonObject node) throws IOException {
            VersionedFile file;
            boolean obfuscated = ((LaunchClassLoader)DepLoader.class.getClassLoader()).getClassBytes("net.minecraft.world.World") == null;
            String testClass = node.get("class").getAsString();
            if (DepLoader.class.getResource("/" + testClass.replace('.', '/') + ".class") != null) {
                return;
            }
            String repo = node.get("repo").getAsString();
            String filename = node.get("file").getAsString();
            if (!obfuscated && node.has("dev")) {
                filename = node.get("dev").getAsString();
            }
            boolean coreLib = node.has("coreLib") && node.get("coreLib").getAsBoolean();
            Pattern pattern = null;
            try {
                if (node.has("pattern")) {
                    pattern = Pattern.compile(node.get("pattern").getAsString());
                }
            }
            catch (PatternSyntaxException e) {
                System.err.println("Invalid filename pattern: " + node.get("pattern"));
                e.printStackTrace();
            }
            if (pattern == null) {
                pattern = Pattern.compile("(\\w+).*?([\\d\\.]+)[-\\w]*\\.[^\\d]+");
            }
            if (!(file = new VersionedFile(filename, pattern)).matches()) {
                throw new RuntimeException("Invalid filename format for dependency: " + filename);
            }
            this.addDep(new Dependency(repo, file, coreLib));
        }

        private void addDep(Dependency newDep) {
            if (this.mergeNew(this.depMap.get(newDep.file.name), newDep)) {
                this.depMap.put(newDep.file.name, newDep);
                this.depSet.add(newDep.file.name);
            }
        }

        private boolean mergeNew(Dependency oldDep, Dependency newDep) {
            if (oldDep == null) {
                return true;
            }
            Dependency newest = newDep.file.version.compareTo(oldDep.file.version) > 0 ? newDep : oldDep;
            newest.coreLib = newDep.coreLib || oldDep.coreLib;
            return newest == newDep;
        }
    }

    public static class Dependency {
        public String url;
        public VersionedFile file;
        public String existing;
        public boolean coreLib;

        public Dependency(String url, VersionedFile file, boolean coreLib) {
            this.url = url;
            this.file = file;
            this.coreLib = coreLib;
        }
    }

    public static class VersionedFile {
        public final Pattern pattern;
        public final String filename;
        public final ComparableVersion version;
        public final String name;

        public VersionedFile(String filename, Pattern pattern) {
            this.pattern = pattern;
            this.filename = filename;
            Matcher m = pattern.matcher(filename);
            if (m.matches()) {
                this.name = m.group(1);
                this.version = new ComparableVersion(m.group(2));
            } else {
                this.name = null;
                this.version = null;
            }
        }

        public boolean matches() {
            return this.name != null;
        }
    }

    public static class DummyDownloader
    implements IDownloadDisplay {
        @Override
        public void resetProgress(int sizeGuess) {
        }

        @Override
        public void setPokeThread(Thread currentThread) {
        }

        @Override
        public void updateProgress(int fullLength) {
        }

        @Override
        public boolean shouldStopIt() {
            return false;
        }

        @Override
        public void updateProgressString(String string, Object ... data) {
        }

        @Override
        public Object makeDialog() {
            return null;
        }

        @Override
        public void showErrorDialog(String name, String url) {
        }
    }

    public static interface IDownloadDisplay {
        public void resetProgress(int var1);

        public void setPokeThread(Thread var1);

        public void updateProgress(int var1);

        public boolean shouldStopIt();

        public void updateProgressString(String var1, Object ... var2);

        public Object makeDialog();

        public void showErrorDialog(String var1, String var2);
    }
}

