/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.SlotHandleClicks;
import codechicken.lib.packet.PacketCustom;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import org.apache.logging.log4j.LogManager;

public abstract class ContainerExtended
extends Container
implements ICrafting {
    private static final String netChannel = "CCL:Container";
    private static int nextNetworkID = 0;
    public LinkedList<EntityPlayerMP> playerCrafters = new LinkedList();
    private int netID;

    public ContainerExtended() {
        this.field_75149_d.add(this);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.netID = ++nextNetworkID;
        }
    }

    public void func_75132_a(ICrafting icrafting) {
        if (icrafting instanceof EntityPlayerMP) {
            this.playerCrafters.add((EntityPlayerMP)icrafting);
            this.sendNetID((EntityPlayerMP)icrafting);
            this.sendContainerAndContentsToPlayer(this, this.func_75138_a(), Collections.singletonList((EntityPlayerMP)icrafting));
            this.func_75142_b();
        } else {
            super.func_75132_a(icrafting);
        }
    }

    private void sendNetID(EntityPlayerMP player) {
        if (this.netID == 0) {
            LogManager.getLogger((String)"CodeChickenLib").error("Player added to container with 0 network ID");
        } else {
            new PacketCustom(netChannel, 1).writeInt(this.netID).sendToPlayer((EntityPlayer)player);
        }
    }

    public void func_82847_b(ICrafting icrafting) {
        if (icrafting instanceof EntityPlayerMP) {
            this.playerCrafters.remove(icrafting);
        } else {
            super.func_82847_b(icrafting);
        }
    }

    public void func_71110_a(Container container, List list) {
        this.sendContainerAndContentsToPlayer(container, list, this.playerCrafters);
    }

    public void sendContainerAndContentsToPlayer(Container container, List<ItemStack> list, List<EntityPlayerMP> playerCrafters) {
        ItemStack stack;
        LinkedList<ItemStack> largeStacks = new LinkedList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            stack = list.get(i);
            if (stack != null && stack.field_77994_a > 127) {
                list.set(i, null);
                largeStacks.add(stack);
                continue;
            }
            largeStacks.add(null);
        }
        for (EntityPlayerMP player : playerCrafters) {
            player.func_71110_a(container, list);
        }
        for (int i = 0; i < largeStacks.size(); ++i) {
            stack = (ItemStack)largeStacks.get(i);
            if (stack == null) continue;
            this.sendLargeStack(stack, i, playerCrafters);
        }
    }

    public void sendLargeStack(ItemStack stack, int slot, List<EntityPlayerMP> players) {
    }

    public void func_71112_a(Container container, int i, int j) {
        for (EntityPlayerMP player : this.playerCrafters) {
            player.func_71112_a(container, i, j);
        }
    }

    public void func_71111_a(Container container, int slot, ItemStack stack) {
        if (stack != null && stack.field_77994_a > 127) {
            this.sendLargeStack(stack, slot, this.playerCrafters);
        } else {
            for (EntityPlayerMP player : this.playerCrafters) {
                player.func_71111_a(container, slot, stack);
            }
        }
    }

    public ItemStack func_75144_a(int par1, int par2, int par3, EntityPlayer player) {
        Slot slot;
        if (par1 >= 0 && par1 < this.field_75151_b.size() && (slot = this.func_75139_a(par1)) instanceof SlotHandleClicks) {
            return ((SlotHandleClicks)slot).slotClick(this, player, par2, par3);
        }
        return super.func_75144_a(par1, par2, par3, player);
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotIndex) {
        ItemStack transferredStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            transferredStack = stack.func_77946_l();
            if (!this.doMergeStackAreas(slotIndex, stack)) {
                return null;
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return transferredStack;
    }

    public boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        Slot slot;
        int slotIndex;
        boolean merged = false;
        int n = slotIndex = reverse ? endIndex - 1 : startIndex;
        if (stack == null) {
            return false;
        }
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                ItemStack slotStack = slot.func_75211_c();
                if (slotStack != null && slotStack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == slotStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotStack)) {
                    int totalStackSize = slotStack.field_77994_a + stack.field_77994_a;
                    int maxStackSize = Math.min(stack.func_77976_d(), slot.func_75219_a());
                    if (totalStackSize <= maxStackSize) {
                        stack.field_77994_a = 0;
                        slotStack.field_77994_a = totalStackSize;
                        slot.func_75218_e();
                        merged = true;
                    } else if (slotStack.field_77994_a < maxStackSize) {
                        stack.field_77994_a -= maxStackSize - slotStack.field_77994_a;
                        slotStack.field_77994_a = maxStackSize;
                        slot.func_75218_e();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        if (stack.field_77994_a > 0) {
            int n2 = slotIndex = reverse ? endIndex - 1 : startIndex;
            while (stack.field_77994_a > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                if (!slot.func_75216_d() && slot.func_75214_a(stack)) {
                    int maxStackSize = Math.min(stack.func_77976_d(), slot.func_75219_a());
                    if (stack.field_77994_a <= maxStackSize) {
                        slot.func_75215_d(stack.func_77946_l());
                        slot.func_75218_e();
                        stack.field_77994_a = 0;
                        merged = true;
                    } else {
                        slot.func_75215_d(stack.func_77979_a(maxStackSize));
                        slot.func_75218_e();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        return merged;
    }

    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        return false;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        this.bindPlayerInventory(inventoryPlayer, 8, 84);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, slot, x + slot * 18, y + 58));
        }
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public void sendContainerPacket(PacketCustom packet) {
        for (EntityPlayerMP player : this.playerCrafters) {
            packet.sendToPlayer((EntityPlayer)player);
        }
    }

    public PacketCustom getPacket(int type) {
        if (this.netID == 0) {
            LogManager.getLogger((String)"CodeChickenLib").error("Tried to get packet for container with 0 network ID");
        }
        if (type == 1) {
            throw new IllegalArgumentException("Packet type 1 is reserved for network synchronisation in ContainerExtended");
        }
        return new PacketCustom(netChannel, type).writeInt(this.netID);
    }

    public void handleClientPacket(PacketCustom packet) {
    }

    public void handleServerPacket(PacketCustom packet) {
    }

    public void sendProgressBarUpdate(int barID, int value) {
        for (ICrafting crafting : this.field_75149_d) {
            crafting.func_71112_a((Container)this, barID, value);
        }
    }

    static {
        PacketCustom.assignHandler(netChannel, new PacketCustom.IClientPacketHandler(){

            @Override
            public void handlePacket(PacketCustom packet, Minecraft mc, INetHandlerPlayClient handler) {
                Container cont = mc.field_71439_g.field_71070_bA;
                if (!(cont instanceof ContainerExtended)) {
                    return;
                }
                ContainerExtended c = (ContainerExtended)cont;
                if (packet.getType() == 1) {
                    c.netID = packet.readInt();
                } else if (c.netID == packet.readInt()) {
                    c.handleClientPacket(packet);
                }
            }
        });
        PacketCustom.assignHandler(netChannel, new PacketCustom.IServerPacketHandler(){

            @Override
            public void handlePacket(PacketCustom packet, EntityPlayerMP sender, INetHandlerPlayServer handler) {
                Container cont = sender.field_71070_bA;
                if (!(cont instanceof ContainerExtended)) {
                    return;
                }
                ContainerExtended c = (ContainerExtended)cont;
                if (c.netID == packet.readInt()) {
                    c.handleServerPacket(packet);
                }
            }
        });
    }
}

