/*
 * Decompiled with CFR 0.152.
 */
package ru.stepan1404.dailyrewards.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.util.Color;
import ru.stepan1404.dailyrewards.client.util.RenderUtils;

public class DayHistoryElement {
    private int day;
    private ItemStack item;
    private final ResourceLocation ARROW = new ResourceLocation("dailyrewards", "textures/gui/arrow.png");
    private final ResourceLocation QUESTION = new ResourceLocation("dailyrewards", "textures/gui/question.png");

    public DayHistoryElement(int day, ItemStack item) {
        this.day = day;
        this.item = item;
    }

    public static int getElementSize() {
        return 36;
    }

    public DayHistoryElement(int day) {
        this.day = day;
        this.item = null;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int value) {
        this.day = value;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public void setItemStack(ItemStack value) {
        this.item = value;
    }

    public void draw(int x, int y, int alpha) {
        Color color = new Color(255, 255, 255, alpha);
        RenderUtils.drawTextureRectWithColor(this.ARROW, x - 8, y - 28, x + 8, y - 20, color);
        color = new Color(0, 0, 0, alpha);
        String text = StatCollector.func_74837_a((String)"dailyrewards.gui.day", (Object[])new Object[]{this.day});
        float scale = 0.85f;
        int size = (int)((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(text) * 0.85f);
        RenderUtils.drawString(text, x - size / 2 - 1, y - 18, 0.85f, color);
        RenderUtils.drawString(text, x - size / 2 + 1, y - 18, 0.85f, color);
        RenderUtils.drawString(text, x - size / 2, y - 18 - 1, 0.85f, color);
        RenderUtils.drawString(text, x - size / 2, y - 18 + 1, 0.85f, color);
        color = new Color(255, 255, 255, alpha);
        RenderUtils.drawString(text, x - size / 2, y - 18, 0.85f, color);
        if (this.item != null) {
            float alphaColor = (float)color.getAlpha() / 255.0f;
            RenderUtils.drawItemStackAndOverlayTextureWithAlpha(this.item, x - 8, y - 8, alphaColor);
        } else {
            Color textureColor = new Color(255, 255, 255, alpha);
            RenderUtils.drawTextureRectWithColor(this.QUESTION, x - 8, y - 8, x + 8, y + 8, textureColor);
        }
    }
}

