/*
 * Decompiled with CFR 0.152.
 */
package ru.stepan1404.dailyrewards.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.util.Color;
import ru.stepan1404.dailyrewards.client.event.JoinToServerEvent;
import ru.stepan1404.dailyrewards.client.gui.DayHistoryElement;
import ru.stepan1404.dailyrewards.client.gui.GuiIngameNotification;
import ru.stepan1404.dailyrewards.client.gui.button.GuiDailyButton;
import ru.stepan1404.dailyrewards.client.gui.effect.TriangleEffect;
import ru.stepan1404.dailyrewards.client.util.OperationController;
import ru.stepan1404.dailyrewards.client.util.RenderUtils;
import ru.stepan1404.dailyrewards.client.util.RewardUtilsClient;
import ru.stepan1404.dailyrewards.network.ApplyMessage;
import ru.stepan1404.dailyrewards.network.NetworkRegister;

public class GuiReward
extends GuiScreen {
    private static boolean showed = false;
    private static boolean isRenderReward = false;
    private static List<ItemStack> items = new ArrayList<ItemStack>();
    private static List<RewardUtilsClient.Rarity> rarities = new ArrayList<RewardUtilsClient.Rarity>();
    private static int totalDays = 0;
    private static Map<Integer, ItemStack> stats = new HashMap<Integer, ItemStack>();
    private ItemStack reward;
    private RewardUtilsClient.Rarity rewardRarity;
    private GuiDailyButton startButton;
    private Thread controller;
    private boolean started;
    private int step;
    private int finalStep;
    private int distance = 60;
    private int itemPadding = 12;
    private int distanceItemCenter = 0;
    private int rewardXPos = 0;
    private List<TriangleEffect> triangles = new ArrayList<TriangleEffect>();
    private List<DayHistoryElement> statList = new ArrayList<DayHistoryElement>();

    public static void setShowed(boolean value) {
        showed = value;
    }

    public static boolean isShowed() {
        return showed;
    }

    public static int getTotalDays() {
        return totalDays;
    }

    public static void setTotalDays(int value) {
        totalDays = value;
    }

    public static Map<Integer, ItemStack> getStats() {
        return stats;
    }

    public static ItemStack getItemStackByStatDay(int day) {
        return stats.get(day);
    }

    public static boolean containsDayStat(int day) {
        return stats.containsKey(day);
    }

    public static void setStats(Map<Integer, ItemStack> value) {
        stats = value;
    }

    public static void clearStats() {
        stats.clear();
    }

    public static void setRenderReward(boolean flag) {
        isRenderReward = flag;
    }

    public static boolean isRenderReward() {
        return isRenderReward;
    }

    public static List<ItemStack> getItems() {
        return items;
    }

    public static void setItems(List<ItemStack> values) {
        items = values;
    }

    public static void clearItems() {
        items.clear();
    }

    public static List<RewardUtilsClient.Rarity> getRarities() {
        return rarities;
    }

    public static void setRarities(List<RewardUtilsClient.Rarity> values) {
        rarities = values;
    }

    public static void clearRarities() {
        rarities.clear();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean value) {
        this.started = value;
    }

    public List<TriangleEffect> getTriangles() {
        return this.triangles;
    }

    public int getRewardXPos() {
        return this.rewardXPos;
    }

    public void setRewardXPos(int value) {
        this.rewardXPos = value;
    }

    public int getDistanceItemCenter() {
        return this.distanceItemCenter;
    }

    public void increaseDistanceItemCenter() {
        ++this.distanceItemCenter;
    }

    public void decreaseDistanceItemCenter() {
        --this.distanceItemCenter;
    }

    public int getDistanceBetweenItems() {
        return this.distance;
    }

    public void setDistanceBetweenItems(int value) {
        this.distance = value;
    }

    public RewardUtilsClient.Rarity getRewardRarity() {
        return this.rewardRarity;
    }

    public void setRewardRarity(RewardUtilsClient.Rarity value) {
        this.rewardRarity = value;
    }

    public ItemStack getReward() {
        return this.reward;
    }

    public void setReward(ItemStack value) {
        this.reward = value;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int value) {
        this.step = value;
    }

    public int getFinalStep() {
        return this.finalStep;
    }

    public void setFinalStep(int value) {
        this.finalStep = value;
    }

    public void func_73866_w_() {
        this.initController();
        RenderUtils.setDrawingOverlay(false);
        this.initTriangleEffects();
        this.initStatisticList();
        this.randomizeItems();
        Color color = new Color(0, 0, 0, 128);
        if (!GuiReward.isRenderReward()) {
            String text = StatCollector.func_74838_a((String)"dailyrewards.button.get_reward.desc");
            this.startButton = new GuiDailyButton(0, this.field_146294_l / 2 - 50, this.field_146295_m / 2 + 30, 100, 20, text, color);
            this.field_146292_n.add(this.startButton);
        }
    }

    private void initStatisticList() {
        if (this.statList.isEmpty()) {
            for (int i = 1; i <= GuiReward.getTotalDays(); ++i) {
                DayHistoryElement day;
                if (GuiReward.containsDayStat(i)) {
                    ItemStack item = GuiReward.getItemStackByStatDay(i);
                    day = new DayHistoryElement(i, item);
                } else {
                    day = new DayHistoryElement(i);
                }
                this.statList.add(day);
            }
        }
    }

    private void initTriangleEffects() {
        Random random = new Random();
        if (this.triangles.isEmpty()) {
            for (int value = 0; value < 720; value += random.nextInt(40) + 25) {
                Color triangleColor = new Color(197, 32, 152, 130);
                TriangleEffect triangle = new TriangleEffect(triangleColor, 0.0f, value);
                this.getTriangles().add(triangle);
            }
        }
    }

    private void randomizeItems() {
        this.saveReward();
        long seed = System.nanoTime();
        Collections.shuffle(items, new Random(seed));
        Collections.shuffle(rarities, new Random(seed));
    }

    private void saveReward() {
        if (this.getReward() == null) {
            this.setReward(items.get(0));
        }
        if (this.getRewardRarity() == null) {
            this.setRewardRarity(rarities.get(0));
        }
    }

    private void loadReward() {
        ItemStack bufferReward = items.get(0);
        int index = items.indexOf(this.reward);
        items.set(0, this.reward);
        items.set(index, bufferReward);
        RewardUtilsClient.Rarity bufferRarity = rarities.get(0);
        index = rarities.indexOf((Object)this.rewardRarity);
        rarities.set(0, this.rewardRarity);
        rarities.set(index, bufferRarity);
    }

    public void func_146281_b() {
        this.loadReward();
        AlphaChannel.resetAlphaChannels();
        RenderUtils.setDrawingOverlay(true);
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            JoinToServerEvent.setRewardAvailable(false);
            GuiReward.setRenderReward(true);
            this.setStarted(true);
            GuiIngameNotification.getInstance().setNotificationType(GuiIngameNotification.NotificationType.STOP);
            if (!GuiIngameNotification.getInstance().isRenderNotification()) {
                GuiIngameNotification.getInstance().setRenderNotification(true);
            }
            if (!GuiIngameNotification.getInstance().hasController()) {
                GuiIngameNotification.getInstance().initController();
            }
            this.startButton.field_146125_m = false;
            this.startButton.field_146124_l = false;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        int alpha = AlphaChannel.REWARD.getAlpha();
        int red = 255 - AlphaChannel.INFO.getAlpha();
        int green = 255 - AlphaChannel.INFO.getAlpha();
        int blue = 255 - AlphaChannel.INFO.getAlpha();
        Color color = new Color(red, green, blue, alpha);
        RenderUtils.drawRound(0, this.field_146295_m / 2 - this.field_146294_l / 2, this.field_146294_l, this.field_146295_m / 2 + this.field_146294_l / 2, color);
        if (AlphaChannel.ROULETTE.isVisible() || AlphaChannel.REWARD.isVisible()) {
            this.drawRoulette();
        }
        if (AlphaChannel.STATISTIC.isVisible()) {
            this.drawStatistic();
        }
        if (!GuiReward.isRenderReward()) {
            this.drawStartScreen(mouseX, mouseY, ticks);
        }
    }

    private void drawStartScreen(int mouseX, int mouseY, float ticks) {
        Color color = new Color(255, 255, 255, AlphaChannel.ROULETTE.getAlpha());
        RenderUtils.drawItemStackWithRarityAndScale(new ItemStack(Items.field_151065_br), RewardUtilsClient.Rarity.COMMON, color, 4.0f, this.field_146294_l / 2, this.field_146295_m / 2 - 10);
        int alpha = (int)((float)AlphaChannel.ROULETTE.getAlpha() * 0.5019608f);
        this.startButton.setAlpha(alpha);
        this.startButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
    }

    public void initController() {
        if (this.controller == null || !this.controller.isAlive()) {
            this.controller = new Thread((Runnable)new GuiRewardController(this), "Reward Controller");
            this.controller.start();
        }
    }

    public void drawStatistic() {
        int alpha = AlphaChannel.STATISTIC.getAlpha();
        int totalSize = DayHistoryElement.getElementSize() * this.statList.size();
        int startXPos = this.field_146294_l / 2 - totalSize / 2;
        for (int i = 0; i < this.statList.size(); ++i) {
            this.statList.get(i).draw(startXPos + i * DayHistoryElement.getElementSize() + 20, this.field_146295_m / 2 + 80, alpha);
        }
    }

    public void drawInfo() {
        Color color = new Color(255, 255, 255, AlphaChannel.INFO.getAlpha());
        String text = StatCollector.func_74837_a((String)"dailyrewards.gui.message.reward", (Object[])new Object[]{this.getReward().func_82833_r(), this.getReward().field_77994_a});
        float scale = 1.5f;
        int size = (int)((float)this.field_146289_q.func_78256_a(text) * 1.5f);
        RenderUtils.drawString(text, this.field_146294_l / 2 - size / 2, this.field_146295_m / 2 + 30, 1.5f, color);
    }

    public static <T> T getElementById(List<T> list, int i) {
        return list.get(i >= list.size() ? (i - 1) % list.size() : i);
    }

    public static <T> T setElementById(List<T> list, int i, T element) {
        return list.set(i >= list.size() ? (i - 1) % list.size() : i, element);
    }

    public void drawRoulette() {
        ResourceLocation resource = new ResourceLocation("dailyrewards", "textures/gui/arrow.png");
        int alphaReward = AlphaChannel.REWARD.getAlpha();
        int alphaRoulette = AlphaChannel.ROULETTE.getAlpha();
        Color colorReward = new Color(255, 255, 255, alphaReward);
        Color colorRoulette = new Color(255, 255, 255, alphaRoulette);
        RenderUtils.drawTextureRectWithColor(resource, this.field_146294_l / 2 - 10, this.field_146295_m / 2 - 45, this.field_146294_l / 2 + 10, this.field_146295_m / 2 - 35, colorReward);
        for (int i = 0; i < items.size() * 3 && i < rarities.size() * 3; ++i) {
            float value;
            int to;
            if (i == this.itemPadding && !GuiReward.isRenderReward()) continue;
            int itemPosX = this.field_146294_l / 2 + ((i - this.itemPadding) * this.getDistanceBetweenItems() - this.getStep());
            if (this.getDistanceItemCenter() != 0) {
                itemPosX -= this.getDistanceItemCenter();
            }
            if (i != (to = Math.round(value = (float)this.getFinalStep() / (float)this.getDistanceBetweenItems() + (float)this.itemPadding))) {
                if (!AlphaChannel.ROULETTE.isVisible()) continue;
                RenderUtils.drawItemStackWithRarityAndScale(GuiReward.getElementById(items, i), GuiReward.getElementById(rarities, i), colorRoulette, 2.0f, itemPosX, this.field_146295_m / 2 - 10);
                continue;
            }
            if (!AlphaChannel.REWARD.isVisible()) continue;
            this.drawReward(GuiReward.getElementById(items, i), GuiReward.getElementById(rarities, i), colorReward, itemPosX);
        }
    }

    public void drawReward(ItemStack item, RewardUtilsClient.Rarity rarity, Color colorReward, int itemPosX) {
        if (AlphaChannel.INFO.isVisible()) {
            for (TriangleEffect triangle : this.getTriangles()) {
                triangle.randomlyMoveSpeed();
                triangle.draw(AlphaChannel.INFO.getAlpha());
            }
        }
        this.setRewardXPos(itemPosX);
        RenderUtils.drawItemStackWithRarityAndScale(item, rarity, colorReward, 2.0f, itemPosX, this.field_146295_m / 2 - 10);
        if (AlphaChannel.INFO.isVisible()) {
            this.drawInfo();
        }
    }

    private static enum AlphaChannel {
        ROULETTE(16),
        REWARD(16),
        STATISTIC(0),
        INFO(0);

        private int alpha;

        private AlphaChannel(int alpha) {
            this.alpha = alpha;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public void setAlpha(int value) {
            this.alpha = value;
        }

        public void increaseAlpha() {
            int value = 3;
            this.alpha = this.alpha + 3 < 255 ? (this.alpha += 3) : 255;
        }

        public void decreaseAlpha() {
            int value = 3;
            this.alpha = this.alpha - 3 > 0 ? (this.alpha -= 3) : 0;
        }

        public boolean isVisible() {
            return this.alpha != 0;
        }

        public static void resetAlphaChannels() {
            REWARD.setAlpha(16);
            ROULETTE.setAlpha(16);
            STATISTIC.setAlpha(0);
            INFO.setAlpha(0);
        }
    }

    private static enum RewardState {
        PREVIEW,
        START,
        MIDDLE,
        END,
        SHOW,
        CLOSE;

    }

    private class GuiRewardController
    implements Runnable {
        private GuiReward gui;
        private Minecraft mc;
        private RewardState state;
        private OperationController controller;
        private int speed = 0;
        private final int border = 60;
        private int step = 0;
        private long firstMiddleTime = 0L;
        private int middleDelay = 1000 * (new Random().nextInt(2) + 2);
        private long firstShowDelay = 0L;
        private int showDelay = 3000;
        private boolean itemsIsReplaced = false;
        private int counter = 0;

        public GuiRewardController(GuiReward gui) {
            this.controller = new OperationController(60);
            this.state = RewardState.PREVIEW;
            this.gui = gui;
            this.mc = Minecraft.func_71410_x();
        }

        public int getSpeed() {
            return this.speed;
        }

        public void calculateAndSetFinalStep() {
            int i;
            int sum = 0;
            for (i = 0; i < 60; ++i) {
                sum += i / 4;
            }
            for (int j = 0; j < this.counter; ++j) {
                int n = sum;
                sum = n + 15;
            }
            while (i > 0) {
                sum += i / 4;
                --i;
            }
            this.gui.setFinalStep(sum);
        }

        public int getStep() {
            return this.step;
        }

        private void increaseStep(int value) {
            this.step += value;
        }

        public void setState(RewardState state) {
            this.state = state;
        }

        public RewardState getState() {
            return this.state;
        }

        private void increaseSpeed() {
            ++this.speed;
        }

        private void decreaseSpeed() {
            --this.speed;
        }

        @Override
        public void run() {
            while (this.mc.field_71462_r instanceof GuiReward) {
                this.controller.updateLastTickTime();
                this.controlSpeedAndAlpha();
                try {
                    long i = this.controller.calculateSleepTime();
                    if (i < 0L) continue;
                    Thread.sleep(i);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (GuiReward.isRenderReward()) {
                GuiReward.clearItems();
                GuiReward.clearRarities();
                GuiReward.clearStats();
                GuiReward.setShowed(false);
                GuiReward.setRenderReward(false);
                NetworkRegister.getNetwork().sendToServer((IMessage)new ApplyMessage());
                JoinToServerEvent.ticks = 5;
                JoinToServerEvent.close = true;
            }
        }

        private void controlSpeedAndAlpha() {
            switch (this.getState()) {
                case END: {
                    if (this.getSpeed() > 0) {
                        this.decreaseSpeed();
                    }
                    if (!this.itemsIsReplaced) {
                        this.calculateAndSetFinalStep();
                        this.itemsIsReplaced = true;
                    }
                    this.calculateRewardPosition();
                    this.calculateStep();
                    break;
                }
                case MIDDLE: {
                    if (this.firstMiddleTime == 0L) {
                        this.initMiddleTime();
                    }
                    AlphaChannel.STATISTIC.increaseAlpha();
                    this.calculateStep();
                    break;
                }
                case START: {
                    if (this.getSpeed() < 60) {
                        this.increaseSpeed();
                    }
                    this.calculateStep();
                    break;
                }
                case SHOW: {
                    this.calculateRewardPosition();
                    if (this.firstShowDelay != 0L) break;
                    this.initFirstTime();
                    break;
                }
                case CLOSE: {
                    this.mc.func_71381_h();
                    break;
                }
                case PREVIEW: {
                    AlphaChannel.ROULETTE.increaseAlpha();
                    AlphaChannel.REWARD.increaseAlpha();
                }
            }
            if (this.gui.isStarted() && this.getState() == RewardState.PREVIEW && AlphaChannel.ROULETTE.getAlpha() == 255) {
                this.setState(RewardState.START);
            }
            if (this.getSpeed() == 60 && this.getState() == RewardState.START) {
                this.setState(RewardState.MIDDLE);
            }
            if (this.firstMiddleTime != 0L && System.currentTimeMillis() - this.firstMiddleTime > (long)this.middleDelay && this.getState() == RewardState.MIDDLE) {
                this.setState(RewardState.END);
            }
            if (this.firstShowDelay != 0L && System.currentTimeMillis() - this.firstShowDelay > (long)this.showDelay && this.getState() == RewardState.SHOW) {
                if (AlphaChannel.REWARD.isVisible()) {
                    for (int i = 0; i < 2; ++i) {
                        AlphaChannel.REWARD.decreaseAlpha();
                        AlphaChannel.STATISTIC.decreaseAlpha();
                        AlphaChannel.INFO.decreaseAlpha();
                    }
                } else {
                    this.setState(RewardState.CLOSE);
                }
            }
            if (this.getState() == RewardState.MIDDLE) {
                ++this.counter;
            }
            if (this.getSpeed() == 0 && this.getState() == RewardState.END) {
                if (AlphaChannel.ROULETTE.isVisible()) {
                    AlphaChannel.ROULETTE.decreaseAlpha();
                    AlphaChannel.INFO.increaseAlpha();
                } else {
                    this.setState(RewardState.SHOW);
                }
            }
        }

        private void calulateDistanceItemCenter(int i) {
            int distance = this.gui.getFinalStep() % 60;
            if (this.gui.getFinalStep() / 60 != i) {
                int finalPosition = 60 - distance;
                if (this.gui.getDistanceItemCenter() != finalPosition) {
                    this.gui.increaseDistanceItemCenter();
                }
            } else {
                int finalPosition = -distance;
                if (this.gui.getDistanceItemCenter() != finalPosition) {
                    this.gui.decreaseDistanceItemCenter();
                }
            }
        }

        private void initFirstTime() {
            this.firstShowDelay = System.currentTimeMillis();
        }

        private void calculateStep() {
            if (this.getSpeed() != 0) {
                this.increaseStep(this.getSpeed() / 4);
            }
            this.gui.setStep(this.getStep());
        }

        private void playSound() {
            EntityClientPlayerMP player = this.mc.field_71439_g;
            WorldClient world = this.mc.field_71441_e;
            Random random = world.field_73012_v;
            float pitch = random.nextFloat() * 0.0f + 1.0f;
            world.func_72980_b(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, "gui.button.press", 3.0f, pitch, false);
        }

        private void calculateRewardPosition() {
            ItemStack reward = this.gui.getReward();
            RewardUtilsClient.Rarity rewardRarity = this.gui.getRewardRarity();
            float value = (float)this.gui.getFinalStep() / (float)this.gui.getDistanceBetweenItems() + (float)this.gui.itemPadding;
            int to = Math.round(value);
            this.calulateDistanceItemCenter(to - this.gui.itemPadding);
            ItemStack otherReward = GuiReward.getElementById(GuiReward.getItems(), to);
            RewardUtilsClient.Rarity otherRarity = GuiReward.getElementById(GuiReward.getRarities(), to);
            if (otherReward != reward) {
                GuiReward.getItems().set(0, otherReward);
                GuiReward.setElementById(GuiReward.getItems(), to, reward);
            }
            if (otherRarity != rewardRarity) {
                GuiReward.getRarities().set(0, otherRarity);
                GuiReward.setElementById(GuiReward.getRarities(), to, rewardRarity);
            }
        }

        private void initMiddleTime() {
            this.firstMiddleTime = System.currentTimeMillis();
        }
    }
}

