/*
 * Decompiled with CFR 0.152.
 */
package ru.stepan1404.dailyrewards.client.util;

import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.GuiIngameForge;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import ru.stepan1404.dailyrewards.client.util.RewardUtilsClient;

public class RenderUtils {
    static final ResourceLocation loc = new ResourceLocation("dailyrewards", "textures/gui/round.png");

    public static void drawCenteredColorTriangles(Color color, float offset) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        Tessellator t = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)(resolution.func_78326_a() / 2), (float)(resolution.func_78328_b() / 2 - 10), (float)0.0f);
        GL11.glRotatef((float)offset, (float)0.0f, (float)0.0f, (float)1.0f);
        t.func_78371_b(4);
        t.func_78369_a(red, green, blue, alpha);
        t.func_78377_a(0.0, 0.0, 0.0);
        t.func_78377_a(-25.0, (double)((float)resolution.func_78328_b() * 1.2f), 0.0);
        t.func_78377_a(25.0, (double)((float)resolution.func_78328_b() * 1.2f), 0.0);
        t.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawTextureRectWithColor(ResourceLocation resource, int x1, int y1, int x2, int y2, Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        Tessellator t = Tessellator.field_78398_a;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        GL11.glPushMatrix();
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3042);
        t.func_78382_b();
        t.func_78374_a((double)x1, (double)y2, 0.0, 0.0, 1.0);
        t.func_78374_a((double)x2, (double)y2, 0.0, 1.0, 1.0);
        t.func_78374_a((double)x2, (double)y1, 0.0, 1.0, 0.0);
        t.func_78374_a((double)x1, (double)y1, 0.0, 0.0, 0.0);
        t.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawRound(int x1, int y1, int x2, int y2, Color color) {
        Tessellator t = Tessellator.field_78398_a;
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(loc);
        GL11.glPushMatrix();
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        t.func_78382_b();
        t.func_78374_a((double)x1, (double)y2, 0.0, 0.0, 1.0);
        t.func_78374_a((double)x2, (double)y2, 0.0, 1.0, 1.0);
        t.func_78374_a((double)x2, (double)y1, 0.0, 1.0, 0.0);
        t.func_78374_a((double)x1, (double)y1, 0.0, 0.0, 0.0);
        t.func_78381_a();
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawItemStackWithRarityAndScale(ItemStack item, RewardUtilsClient.Rarity rarity, Color rouletteColor, float scale, int x, int y) {
        Color color = rarity.getColor();
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        int halfWidth = resolution.func_78326_a() / 2;
        int roundBorder = 6;
        int visibleBorder = 20;
        int alpha = rouletteColor.getAlpha();
        float alphaColor = 0.0f;
        if (x >= 20 && x <= halfWidth) {
            alphaColor = (float)(x - 20) / (float)(halfWidth - 20) / 1.5f + 0.33f;
        } else if (x >= halfWidth && x <= resolution.func_78326_a() - 20) {
            alphaColor = (1.0f - (float)(x - halfWidth + 20) / (float)(resolution.func_78326_a() - halfWidth + 20)) / 1.5f + 0.33f;
        }
        color.setAlpha(Math.round((alphaColor *= (float)alpha / 255.0f) * 255.0f));
        if (alphaColor != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            if (rarity != RewardUtilsClient.Rarity.COMMON) {
                RenderUtils.drawRound((int)(-6.0f * scale), (int)(-6.0f * scale), (int)(6.0f * scale), (int)(6.0f * scale), color);
            }
            RenderUtils.drawItemStackAndOverlayTextureWithAlpha(item, -8, -8, alphaColor);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void drawItemStackAndOverlayTexture(ItemStack itemStack, int x, int y) {
        RenderUtils.drawItemStackAndOverlayTextureWithAlpha(itemStack, x, y, 1.0f);
    }

    public static void drawItemStackAndOverlayTextureWithAlpha(ItemStack item, int x, int y, float alphaColor) {
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        ForkRenderItem.renderItemAndEffectIntoGUI(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, item, x, y, alphaColor);
        ForkRenderItem.renderItemOverlayIntoGUIWithAlpha(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, item, x, y, null, alphaColor);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
    }

    public static void drawString(String text, int x, int y, float scale, Color color) {
        int red = color.getRed() << 16;
        int green = color.getGreen() << 8;
        int blue = color.getBlue();
        int alpha = color.getAlpha() << 24;
        int colorInt = red + green + blue + alpha;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(text, 0, 0, colorInt);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glPopMatrix();
    }

    public static void drawColorRect(int x1, int y1, int x2, int y2, Color color) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        tessellator.func_78382_b();
        tessellator.func_78369_a(red, green, blue, alpha);
        tessellator.func_78377_a((double)x2, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void setDrawingOverlay(boolean value) {
        GuiIngameForge.renderCrosshairs = value;
        GuiIngameForge.renderHelmet = value;
    }

    public static class ForkRenderItem {
        private static RenderBlocks renderBlocksRi = new RenderBlocks();
        private static boolean renderWithColor = true;
        private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
        private static int zLevel;

        public static void renderItemIntoGUIWithAlpha(FontRenderer p_77015_1_, TextureManager p_77015_2_, ItemStack p_77015_3_, int p_77015_4_, int p_77015_5_, boolean renderEffect, float alpha) {
            int k = p_77015_3_.func_77960_j();
            IIcon object = p_77015_3_.func_77954_c();
            if (p_77015_3_.func_94608_d() == 0 && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)p_77015_3_.func_77973_b()).func_149645_b())) {
                p_77015_2_.func_110577_a(TextureMap.field_110575_b);
                Block block = Block.func_149634_a((Item)p_77015_3_.func_77973_b());
                GL11.glEnable((int)3008);
                if (block.func_149701_w() != 0) {
                    GL11.glAlphaFunc((int)516, (float)0.0f);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                } else {
                    GL11.glAlphaFunc((int)516, (float)0.0f);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                }
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(p_77015_4_ - 2), (float)(p_77015_5_ + 3), (float)(-3.0f + (float)zLevel));
                GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
                GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                int l = p_77015_3_.func_77973_b().func_82790_a(p_77015_3_, 0);
                float f3 = (float)(l >> 16 & 0xFF) / 255.0f;
                float f4 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f5 = (float)(l & 0xFF) / 255.0f;
                if (renderWithColor) {
                    GL11.glColor4f((float)f3, (float)f4, (float)f5, (float)alpha);
                }
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                ForkRenderItem.renderBlocksRi.field_147844_c = false;
                renderBlocksRi.func_147800_a(block, k, 1.0f);
                ForkRenderItem.renderBlocksRi.field_147844_c = true;
                if (block.func_149701_w() == 0) {
                    GL11.glAlphaFunc((int)516, (float)0.0f);
                }
                GL11.glPopMatrix();
            } else if (p_77015_3_.func_77973_b().func_77623_v()) {
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3008);
                p_77015_2_.func_110577_a(TextureMap.field_110576_c);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3553);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)0, (int)0, (int)0, (int)0);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78378_d(-1);
                tessellator.func_78377_a((double)(p_77015_4_ - 2), (double)(p_77015_5_ + 18), (double)zLevel);
                tessellator.func_78377_a((double)(p_77015_4_ + 18), (double)(p_77015_5_ + 18), (double)zLevel);
                tessellator.func_78377_a((double)(p_77015_4_ + 18), (double)(p_77015_5_ - 2), (double)zLevel);
                tessellator.func_78377_a((double)(p_77015_4_ - 2), (double)(p_77015_5_ - 2), (double)zLevel);
                tessellator.func_78381_a();
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                Item item = p_77015_3_.func_77973_b();
                for (int l = 0; l < item.getRenderPasses(k); ++l) {
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    p_77015_2_.func_110577_a(item.func_94901_k() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
                    IIcon iicon = item.getIcon(p_77015_3_, l);
                    int i1 = p_77015_3_.func_77973_b().func_82790_a(p_77015_3_, l);
                    float f5 = (float)(i1 >> 16 & 0xFF) / 255.0f;
                    float f6 = (float)(i1 >> 8 & 0xFF) / 255.0f;
                    float f7 = (float)(i1 & 0xFF) / 255.0f;
                    if (renderWithColor) {
                        GL11.glColor4f((float)f5, (float)f6, (float)f7, (float)alpha);
                    }
                    GL11.glDisable((int)2896);
                    GL11.glEnable((int)3008);
                    ForkRenderItem.renderIcon(p_77015_4_, p_77015_5_, iicon, 16, 16);
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)2896);
                    if (!renderEffect || !p_77015_3_.hasEffect(l)) continue;
                    ForkRenderItem.renderEffect(p_77015_2_, p_77015_4_, p_77015_5_, alpha);
                }
                GL11.glEnable((int)2896);
            } else {
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                ResourceLocation resourcelocation = p_77015_2_.func_130087_a(p_77015_3_.func_94608_d());
                p_77015_2_.func_110577_a(resourcelocation);
                if (object == null) {
                    object = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(resourcelocation)).func_110572_b("missingno");
                }
                int l = p_77015_3_.func_77973_b().func_82790_a(p_77015_3_, 0);
                float f3 = (float)(l >> 16 & 0xFF) / 255.0f;
                float f4 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f5 = (float)(l & 0xFF) / 255.0f;
                if (renderWithColor) {
                    GL11.glColor4f((float)f3, (float)f4, (float)f5, (float)alpha);
                }
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3042);
                ForkRenderItem.renderIcon(p_77015_4_, p_77015_5_, object, 16, 16);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                if (renderEffect && p_77015_3_.hasEffect(0)) {
                    ForkRenderItem.renderEffect(p_77015_2_, p_77015_4_, p_77015_5_, alpha / 2.0f);
                }
                GL11.glEnable((int)2896);
            }
            GL11.glEnable((int)2884);
        }

        public static void renderItemAndEffectIntoGUI(FontRenderer p_82406_1_, TextureManager p_82406_2_, final ItemStack p_82406_3_, int p_82406_4_, int p_82406_5_, float alpha) {
            if (p_82406_3_ != null) {
                zLevel += 50;
                try {
                    if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocksRi, (TextureManager)p_82406_2_, (ItemStack)p_82406_3_, (boolean)renderWithColor, (float)zLevel, (float)p_82406_4_, (float)p_82406_5_)) {
                        ForkRenderItem.renderItemIntoGUIWithAlpha(p_82406_1_, p_82406_2_, p_82406_3_, p_82406_4_, p_82406_5_, false, alpha);
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering item");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                    crashreportcategory.func_71500_a("Item Type", new Callable(){

                        public String call() {
                            return String.valueOf(p_82406_3_.func_77973_b());
                        }
                    });
                    crashreportcategory.func_71500_a("Item Aux", new Callable(){

                        public String call() {
                            return String.valueOf(p_82406_3_.func_77960_j());
                        }
                    });
                    crashreportcategory.func_71500_a("Item NBT", new Callable(){

                        public String call() {
                            return String.valueOf(p_82406_3_.func_77978_p());
                        }
                    });
                    crashreportcategory.func_71500_a("Item Foil", new Callable(){

                        public String call() {
                            return String.valueOf(p_82406_3_.func_77962_s());
                        }
                    });
                    throw new ReportedException(crashreport);
                }
                zLevel -= 50;
            }
        }

        public static void renderEffect(TextureManager manager, int x, int y, float alpha) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            manager.func_110577_a(RES_ITEM_GLINT);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)alpha);
            ForkRenderItem.renderGlint(x * 431278612 + y * 32178161, x - 2, y - 2, 20, 20);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }

        public static void renderGlint(int p_77018_1_, int x, int y, int width, int height) {
            for (int j1 = 0; j1 < 2; ++j1) {
                OpenGlHelper.func_148821_a((int)772, (int)1, (int)0, (int)0);
                float f = 0.00390625f;
                float f2 = 0.00390625f;
                float f3 = (float)(Minecraft.func_71386_F() % (long)(3000 + j1 * 1873)) / (3000.0f + (float)(j1 * 1873)) * 256.0f;
                float f4 = 0.0f;
                Tessellator tessellator = Tessellator.field_78398_a;
                float f5 = 4.0f;
                if (j1 == 1) {
                    f5 = -1.0f;
                }
                GL11.glEnable((int)3042);
                tessellator.func_78371_b(9);
                tessellator.func_78374_a((double)x, (double)(y + height), (double)zLevel, (double)((f3 + (float)height * f5) * 0.00390625f), (double)((0.0f + (float)height) * 0.00390625f));
                tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((f3 + (float)width + (float)height * f5) * 0.00390625f), (double)((0.0f + (float)height) * 0.00390625f));
                tessellator.func_78374_a((double)(x + width), (double)y, (double)zLevel, (double)((f3 + (float)width) * 0.00390625f), 0.0);
                tessellator.func_78374_a((double)x, (double)y, (double)zLevel, (double)((f3 + 0.0f) * 0.00390625f), 0.0);
                tessellator.func_78381_a();
            }
        }

        public static void renderRoundGlint(int x, int y, int radius) {
            for (int j1 = 0; j1 < 2; ++j1) {
                OpenGlHelper.func_148821_a((int)772, (int)1, (int)0, (int)0);
                float f = 0.00390625f;
                float f2 = 0.00390625f;
                float f3 = (float)(Minecraft.func_71386_F() % (long)(3000 + j1 * 1873)) / (3000.0f + (float)(j1 * 1873)) * 256.0f;
                float f4 = 0.0f;
                float f5 = 4.0f;
                Tessellator tessellator = Tessellator.field_78398_a;
                if (j1 == 1) {
                    f5 = -1.0f;
                }
                GL11.glEnable((int)3042);
                tessellator.func_78371_b(9);
                for (int i = 0; i < 360; i += 2) {
                    double radian = (double)i * (Math.PI / 180);
                    double xcos = (float)Math.cos(radian);
                    double ysin = (float)Math.sin(radian);
                    double x2 = xcos * (double)radius;
                    double y2 = ysin * (double)radius;
                    double tx = (double)(x / radius + 1) * 0.5;
                    double ty = (double)(y / radius + 1) * 0.5;
                    tessellator.func_78374_a((double)x + x2, (double)y + y2, (double)zLevel, (double)((f3 + (float)radius * f5) * 0.00390625f), (double)((0.0f + (float)radius) * 0.00390625f));
                }
                tessellator.func_78381_a();
            }
        }

        public static void renderIcon(int p_94149_1_, int p_94149_2_, IIcon p_94149_3_, int p_94149_4_, int p_94149_5_) {
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)p_94149_1_, (double)(p_94149_2_ + p_94149_5_), (double)zLevel, (double)p_94149_3_.func_94209_e(), (double)p_94149_3_.func_94210_h());
            tessellator.func_78374_a((double)(p_94149_1_ + p_94149_4_), (double)(p_94149_2_ + p_94149_5_), (double)zLevel, (double)p_94149_3_.func_94212_f(), (double)p_94149_3_.func_94210_h());
            tessellator.func_78374_a((double)(p_94149_1_ + p_94149_4_), (double)p_94149_2_, (double)zLevel, (double)p_94149_3_.func_94212_f(), (double)p_94149_3_.func_94206_g());
            tessellator.func_78374_a((double)p_94149_1_, (double)p_94149_2_, (double)zLevel, (double)p_94149_3_.func_94209_e(), (double)p_94149_3_.func_94206_g());
            tessellator.func_78381_a();
        }

        public static void renderItemOverlayIntoGUIWithAlpha(FontRenderer p_94148_1_, TextureManager p_94148_2_, ItemStack p_94148_3_, int p_94148_4_, int p_94148_5_, String p_94148_6_, float alpha) {
            if (p_94148_3_ != null) {
                if (p_94148_3_.field_77994_a > 1 || p_94148_6_ != null) {
                    String s1 = p_94148_6_ == null ? String.valueOf(p_94148_3_.field_77994_a) : p_94148_6_;
                    Color color = new Color(255, 255, 255, Math.round(alpha * 255.0f));
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3042);
                    RenderUtils.drawString(s1, p_94148_4_ + 19 - 2 - p_94148_1_.func_78256_a(s1), p_94148_5_ + 6 + 3, 1.0f, color);
                    GL11.glEnable((int)2896);
                    GL11.glEnable((int)2929);
                }
                if (p_94148_3_.func_77973_b().showDurabilityBar(p_94148_3_)) {
                    double health = p_94148_3_.func_77973_b().getDurabilityForDisplay(p_94148_3_);
                    int j1 = (int)Math.round(13.0 - health * 13.0);
                    int k = (int)Math.round(255.0 - health * 255.0);
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3553);
                    GL11.glDisable((int)3008);
                    GL11.glDisable((int)3042);
                    Tessellator tessellator = Tessellator.field_78398_a;
                    int l = 255 - k << 16 | k << 8;
                    int i1 = (255 - k) / 4 << 16 | 0x3F00;
                    ForkRenderItem.renderQuad(tessellator, p_94148_4_ + 2, p_94148_5_ + 13, 13, 2, 0);
                    ForkRenderItem.renderQuad(tessellator, p_94148_4_ + 2, p_94148_5_ + 13, 12, 1, i1);
                    ForkRenderItem.renderQuad(tessellator, p_94148_4_ + 2, p_94148_5_ + 13, j1, 1, l);
                    GL11.glEnable((int)3008);
                    GL11.glEnable((int)3553);
                    GL11.glEnable((int)2896);
                    GL11.glEnable((int)2929);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }

        public static void renderQuad(Tessellator p_77017_1_, int p_77017_2_, int p_77017_3_, int p_77017_4_, int p_77017_5_, int p_77017_6_) {
            p_77017_1_.func_78382_b();
            p_77017_1_.func_78378_d(p_77017_6_);
            p_77017_1_.func_78377_a((double)p_77017_2_, (double)p_77017_3_, 0.0);
            p_77017_1_.func_78377_a((double)p_77017_2_, (double)(p_77017_3_ + p_77017_5_), 0.0);
            p_77017_1_.func_78377_a((double)(p_77017_2_ + p_77017_4_), (double)(p_77017_3_ + p_77017_5_), 0.0);
            p_77017_1_.func_78377_a((double)(p_77017_2_ + p_77017_4_), (double)p_77017_3_, 0.0);
            p_77017_1_.func_78381_a();
        }
    }
}

