/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.grimoire.common.api.eventbus;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import io.github.crucible.grimoire.common.GrimoireCore;
import io.github.crucible.grimoire.common.api.eventbus.CoreEvent;
import io.github.crucible.grimoire.common.api.eventbus.IExceptionHandler;
import io.github.crucible.grimoire.common.api.eventbus.SubscribeCoreEvent;
import io.github.crucible.grimoire.common.events.SubscribeAnnotationWrapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CoreEventBus<T extends CoreEvent>
implements IExceptionHandler<T> {
    private static final List<CoreEventBus<? extends CoreEvent>> busRegistry = new ArrayList<CoreEventBus<? extends CoreEvent>>();
    protected static int nextBusID = 0;
    protected final int id;
    protected final String name;
    protected final Class<T> eventClass;
    protected final List<CoreEventHandler> handlerList = new ArrayList<CoreEventHandler>();
    protected final IExceptionHandler<T> exceptionHandler;
    protected boolean shutdown = false;

    protected CoreEventBus(Class<T> eventClass, String busName, IExceptionHandler<T> exceptionHandler) {
        this.eventClass = eventClass;
        this.name = busName;
        this.exceptionHandler = exceptionHandler != null ? exceptionHandler : this;
        this.id = nextBusID++;
        busRegistry.add(this);
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void register(@NotNull Object target) {
        Preconditions.checkNotNull((Object)target);
        for (CoreEventHandler handler : this.handlerList) {
            if (handler.handler != target) continue;
            return;
        }
        try {
            CoreEventHandler handler = new CoreEventHandler(target);
            if (handler.isValid) {
                this.handlerList.add(handler);
            } else {
                GrimoireCore.logger.error("Registered event handler does not have any valid event receivers: {}", new Object[]{target.getClass() == Class.class ? target : target.getClass()});
            }
        }
        catch (Exception ex) {
            GrimoireCore.logger.fatal("Error when trying to register event handler: {}", new Object[]{target.getClass()});
            Throwables.propagate((Throwable)ex);
        }
    }

    public void unregister(Object target) {
        this.handlerList.removeIf(handler -> handler.handler == target);
    }

    public List<CoreEventHandler> getHandlerList() {
        return Collections.unmodifiableList(this.handlerList);
    }

    public boolean post(T event) {
        if (this.shutdown) {
            return false;
        }
        try {
            HashMultimap receiverMap = HashMultimap.create();
            for (CoreEventHandler handler : this.handlerList) {
                for (EventReceiver receiver : handler.receiverList) {
                    if (!receiver.eventClass.isAssignableFrom(event.getClass())) continue;
                    receiverMap.put((Object)receiver.priority, (Object)receiver);
                }
            }
            for (CoreEvent.Priority priority : CoreEvent.Priority.values()) {
                for (EventReceiver receiver : receiverMap.get((Object)priority)) {
                    if (((CoreEvent)event).isCanceled() && !receiver.receiveCanceled) continue;
                    receiver.invoke(event);
                }
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(this, event, throwable);
        }
        return ((CoreEvent)event).isCancelable() && ((CoreEvent)event).isCanceled();
    }

    public void shutdown() {
        GrimoireCore.logger.warn("EventBus of type {} shutting down - future events will not be posted.", new Object[]{this.eventClass});
        this.shutdown = true;
        this.handlerList.clear();
    }

    @Override
    public void handleException(CoreEventBus<T> bus, T event, Throwable exception) {
        GrimoireCore.logger.fatal("Exception caught during firing event {}:", new Object[]{event, exception});
        GrimoireCore.logger.fatal("Listeners:");
        for (CoreEventHandler handler : this.handlerList) {
            GrimoireCore.logger.fatal(handler.handler.getClass());
        }
        Throwables.propagate((Throwable)exception);
    }

    protected boolean hasAnnotation(Method method) {
        if (method.isAnnotationPresent(SubscribeCoreEvent.class)) {
            return true;
        }
        SubscribeAnnotationWrapper wrapper = SubscribeAnnotationWrapper.getWrapper(method);
        return wrapper.annotationPresent();
    }

    protected CoreEvent.Priority getPriority(Method method) throws NullPointerException {
        if (method.isAnnotationPresent(SubscribeCoreEvent.class)) {
            return method.getAnnotation(SubscribeCoreEvent.class).priority();
        }
        SubscribeAnnotationWrapper wrapper = SubscribeAnnotationWrapper.getWrapper(method);
        return CoreEvent.Priority.values()[wrapper.getEventPriorityOrdinal()];
    }

    protected boolean receiveCanceled(Method method) throws NullPointerException {
        if (method.isAnnotationPresent(SubscribeCoreEvent.class)) {
            return method.getAnnotation(SubscribeCoreEvent.class).receiveCanceled();
        }
        SubscribeAnnotationWrapper wrapper = SubscribeAnnotationWrapper.getWrapper(method);
        return wrapper.receiveCanceled();
    }

    public static <E extends CoreEvent> CoreEventBus<E> create(@NotNull Class<E> eventClass, @NotNull String busName, IExceptionHandler<E> exceptionHandler) {
        return new CoreEventBus<E>(eventClass, busName, exceptionHandler);
    }

    public static <E extends CoreEvent> CoreEventBus<E> create(@NotNull Class<E> eventClass, String busName) {
        return CoreEventBus.create(eventClass, busName, null);
    }

    public static CoreEventBus<CoreEvent> create(String busName) {
        return CoreEventBus.create(CoreEvent.class, busName);
    }

    public static List<CoreEventBus<? extends CoreEvent>> getBusRegistry() {
        return Collections.unmodifiableList(busRegistry);
    }

    public static Optional<CoreEventBus<? extends CoreEvent>> findBus(String busName) {
        for (CoreEventBus<? extends CoreEvent> bus : busRegistry) {
            if (!Objects.equal((Object)bus.getName(), (Object)busName)) continue;
            return Optional.of(bus);
        }
        return Optional.empty();
    }

    protected class EventReceiver {
        protected final Object handler;
        protected final Class<? extends T> eventClass;
        protected final Method receiverMethod;
        protected final CoreEvent.Priority priority;
        protected final boolean receiveCanceled;

        public EventReceiver(Class<? extends T> eventClass, Method receiverMethod, Object handler) {
            this.handler = handler;
            this.eventClass = eventClass;
            this.receiverMethod = receiverMethod;
            this.priority = CoreEventBus.this.getPriority(receiverMethod);
            this.receiveCanceled = CoreEventBus.this.receiveCanceled(receiverMethod);
        }

        public void invoke(T event) {
            try {
                this.receiverMethod.invoke(this.handler, event);
            }
            catch (Exception ex) {
                GrimoireCore.logger.fatal("Error when trying to invoke event receiver!");
                Throwables.propagate((Throwable)ex);
            }
        }
    }

    protected class CoreEventHandler {
        protected final Object handler;
        protected final boolean isValid;
        protected final List<EventReceiver> receiverList = new ArrayList<EventReceiver>();

        public CoreEventHandler(Object target) {
            boolean isStatic;
            boolean valid = false;
            boolean bl = isStatic = target.getClass() == Class.class;
            if (isStatic) {
                GrimoireCore.logger.info("Analyzing static handler " + target);
            }
            Set supers = isStatic ? Sets.newHashSet((Object[])new Class[]{(Class)target}) : TypeToken.of(target.getClass()).getTypes().rawTypes();
            block2: for (Method method : (isStatic ? (Class<?>)target : target.getClass()).getMethods()) {
                if (isStatic && !Modifier.isStatic(method.getModifiers()) || !isStatic && Modifier.isStatic(method.getModifiers())) continue;
                for (Class cls : supers) {
                    try {
                        Method real = cls.getDeclaredMethod(method.getName(), method.getParameterTypes());
                        if (!CoreEventBus.this.hasAnnotation(real)) continue;
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        if (parameterTypes.length != 1) {
                            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but requires " + parameterTypes.length + " arguments. Event handler methods must require a single argument.");
                        }
                        Class<?> eventType = parameterTypes[0];
                        if (!CoreEventBus.this.eventClass.isAssignableFrom(eventType)) continue block2;
                        valid = true;
                        real.setAccessible(true);
                        this.receiverList.add(new EventReceiver(eventType, real, isStatic ? null : target));
                        continue block2;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            this.handler = target;
            this.isValid = valid;
        }
    }
}

