/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.grimoire.common.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import io.github.crucible.grimoire.common.api.grimmix.lifecycle.LoadingStage;
import io.github.crucible.grimoire.common.api.mixin.ConfigurationType;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

class DeserializedMixinJson {
    @SerializedName(value="package")
    private String mixinPackage;
    @SerializedName(value="mixins")
    private List<String> mixinClasses;
    @SerializedName(value="client")
    private List<String> mixinClassesClient;
    @SerializedName(value="server")
    private List<String> mixinClassesServer;
    @SerializedName(value="forceLoadAtStage")
    private String forceLoadAtStage;

    private DeserializedMixinJson() {
    }

    public boolean isValidConfiguration() {
        boolean valid = this.mixinPackage != null && this.mixinClasses != null && this.mixinClassesClient != null && this.mixinClassesServer != null;
        return valid;
    }

    @Nullable
    public ConfigurationType getForceLoadType() {
        if (this.forceLoadAtStage != null) {
            try {
                LoadingStage forcedStage = LoadingStage.valueOf(this.forceLoadAtStage);
                return forcedStage.getAssociatedConfigurationType();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    protected static DeserializedMixinJson deserialize(Supplier<InputStream> streamSupplier) {
        DeserializedMixinJson result = null;
        try {
            InputStream stream = streamSupplier.get();
            if (stream == null) {
                return null;
            }
            Gson gson = new GsonBuilder().create();
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            try {
                DeserializedMixinJson deserialized;
                result = deserialized = gson.fromJson((Reader)reader, DeserializedMixinJson.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            reader.close();
            stream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

