/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.grimoire.mc1_7_10.mixins.forge;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import io.github.crucible.grimoire.common.GrimoireCore;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.List;
import net.minecraft.launchwrapper.Launch;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.mixin.transformer.Proxy;

@Mixin(value={Loader.class}, remap=false)
public class MixinLoader {
    @Shadow
    private List<ModContainer> mods;
    @Shadow
    private ModClassLoader modClassLoader;

    @Inject(method={"loadMods"}, at={@At(value="INVOKE", target="Lcpw/mods/fml/common/LoadController;transition(Lcpw/mods/fml/common/LoaderState;Z)V", ordinal=1)}, remap=false)
    private void beforeConstructingMods(CallbackInfo callbackInfo) {
        if (GrimoireCore.INSTANCE.prepareModConfigs().size() <= 0) {
            GrimoireCore.logger.info("Since 0 mod-targeting configurations is present, skipping forced Mixin environment reload.");
            GrimoireCore.INSTANCE.loadModConfigs();
            GrimoireCore.INSTANCE.finish();
            return;
        }
        GrimoireCore.logger.info("Adding all mods to classpath...");
        for (ModContainer mod : this.mods) {
            try {
                this.modClassLoader.addFile(mod.getSource());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        GrimoireCore.logger.info("Proccessing mod-targeting configurations...");
        GrimoireCore.INSTANCE.loadModConfigs();
        GrimoireCore.logger.info("Attempting to forcefully reload configurations for current Mixin environment...");
        Proxy mixinProxy = (Proxy)Launch.classLoader.getTransformers().stream().filter(transformer -> transformer instanceof Proxy).findFirst().get();
        try {
            Field transformerField = Proxy.class.getDeclaredField("transformer");
            transformerField.setAccessible(true);
            MixinTransformer transformer2 = (MixinTransformer)transformerField.get(mixinProxy);
            Method selectConfigsMethod = MixinTransformer.class.getDeclaredMethod("selectConfigs", MixinEnvironment.class);
            selectConfigsMethod.setAccessible(true);
            selectConfigsMethod.invoke((Object)transformer2, MixinEnvironment.getCurrentEnvironment());
            Method prepareConfigsMethod = MixinTransformer.class.getDeclaredMethod("prepareConfigs", MixinEnvironment.class);
            prepareConfigsMethod.setAccessible(true);
            prepareConfigsMethod.invoke((Object)transformer2, MixinEnvironment.getCurrentEnvironment());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        GrimoireCore.logger.info("Configurations reloaded successfully.");
        GrimoireCore.INSTANCE.finish();
    }
}

