/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.omniconfig.api.core;

import io.github.crucible.grimoire.common.GrimoireInternals;
import io.github.crucible.grimoire.common.api.lib.Environment;
import org.jetbrains.annotations.Nullable;

public enum SidedConfigType {
    CLIENT,
    SERVER,
    COMMON;


    public boolean isSided() {
        return this != COMMON;
    }

    @Nullable
    public Environment getSide() {
        if (this == CLIENT) {
            return Environment.CLIENT;
        }
        if (this == SERVER) {
            return Environment.DEDICATED_SERVER;
        }
        return null;
    }

    public void executeSided(Runnable run) {
        if (this.isSided()) {
            GrimoireInternals.executeInEnvironment(this.getSide(), () -> run);
        } else {
            run.run();
        }
    }
}

