/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.omniconfig.core;

import io.github.crucible.omniconfig.api.core.IOmniconfig;
import io.github.crucible.omniconfig.api.core.IOmniconfigRegistry;
import io.github.crucible.omniconfig.core.Omniconfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OmniconfigRegistry
implements IOmniconfigRegistry {
    public static final OmniconfigRegistry INSTANCE = new OmniconfigRegistry();
    protected final Map<String, Omniconfig> registryMap = new HashMap<String, Omniconfig>();

    private OmniconfigRegistry() {
    }

    protected void registerConfig(Omniconfig config) {
        if (this.registryMap.containsKey(config.getFileID())) {
            throw new RuntimeException("Attempted to register two config files with the same location: " + config.getFile());
        }
        this.registryMap.put(config.getFileID(), config);
    }

    @Override
    public Collection<IOmniconfig> getRegisteredConfigs() {
        return Collections.unmodifiableCollection(this.registryMap.values());
    }

    @Override
    public Optional<IOmniconfig> getConfig(String fileID) {
        return Optional.ofNullable(this.registryMap.get(fileID));
    }
}

